/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.client.meta.ApiOperation;
import org.babyfish.jimmer.client.meta.ApiParameter;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.ApiParameterImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ApiOperationImpl<S>
extends AstNode<S>
implements ApiOperation {
    private static final JavaType ERROR_LIST_TYPE = CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe(String.class));
    private String name;
    private List<String> groups;
    private final List<ApiParameterImpl<S>> parameters = new ArrayList<ApiParameterImpl<S>>();
    private TypeRefImpl<S> returnType;
    private Map<TypeName, List<String>> errorMap = Collections.emptyMap();
    private Doc doc;
    private StringBuilder keyBuilder;
    private String key;

    ApiOperationImpl(S source, String name) {
        super(source);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups == null || groups.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(groups);
    }

    @Override
    public List<ApiParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(ApiParameterImpl<S> parameter) {
        this.parameters.add(parameter);
        this.addIgnoredParameter(parameter);
    }

    public void addIgnoredParameter(ApiParameterImpl<S> parameter) {
        TypeName typeName;
        if (this.keyBuilder == null) {
            this.keyBuilder = new StringBuilder();
            this.keyBuilder.append(this.name);
        }
        if ((typeName = parameter.getType().getTypeName()).getTypeVariable() != null) {
            throw new AssertionError((Object)("Illegal parameter \"" + parameter.getName() + "\", its type cannot be type variable"));
        }
        this.keyBuilder.append(':').append(typeName);
    }

    @Override
    @Nullable
    public TypeRef getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeRefImpl<S> returnType) {
        this.returnType = returnType;
    }

    @Override
    public Map<TypeName, List<String>> getErrorMap() {
        return this.errorMap;
    }

    public void setErrorMap(Map<TypeName, List<String>> errorMap) {
        if (errorMap.isEmpty()) {
            this.errorMap = Collections.emptyMap();
        } else {
            LinkedHashMap<TypeName, List<String>> map = new LinkedHashMap<TypeName, List<String>>((errorMap.size() * 4 + 2) / 3);
            for (Map.Entry<TypeName, List<String>> e : errorMap.entrySet()) {
                map.put(e.getKey(), Collections.unmodifiableList(e.getValue()));
            }
            this.errorMap = Collections.unmodifiableMap(map);
        }
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        try {
            for (ApiParameterImpl<S> parameter : this.parameters) {
                parameter.accept(visitor);
            }
            if (this.returnType != null) {
                this.returnType.accept(visitor);
            }
            for (TypeName typeName : this.errorMap.keySet()) {
                TypeRefImpl<S> typeRef = new TypeRefImpl<S>();
                typeRef.setTypeName(typeName);
                typeRef.accept(visitor);
            }
        }
        finally {
            visitor.visitedAstNode(this);
        }
    }

    public String toString() {
        return this.key().replaceFirst(":", "(").replace(":", ", ") + ')';
    }

    public String key() {
        String key = this.key;
        if (key == null) {
            if (this.keyBuilder == null) {
                this.key = key = this.name;
            } else {
                this.key = key = this.keyBuilder.toString();
                this.keyBuilder = null;
            }
        }
        return key;
    }

    public void setKey(String key) {
        this.key = key;
        this.keyBuilder = null;
    }

    public static class Deserializer
    extends JsonDeserializer<ApiOperationImpl<?>> {
        public ApiOperationImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            String name = jsonNode.get("name").asText();
            ApiOperationImpl<Object> operation = new ApiOperationImpl<Object>(null, name);
            operation.setKey(jsonNode.get("key").asText());
            if (jsonNode.has("doc")) {
                operation.setDoc((Doc)ctx.readTreeAsValue(jsonNode.get("doc"), Doc.class));
            }
            if (jsonNode.has("parameters")) {
                for (JsonNode paramNode : jsonNode.get("parameters")) {
                    ApiParameterImpl parameter = (ApiParameterImpl)ctx.readTreeAsValue(paramNode, ApiParameterImpl.class);
                    operation.addParameter(parameter);
                }
            }
            if (jsonNode.has("returnType")) {
                operation.setReturnType((TypeRefImpl)ctx.readTreeAsValue(jsonNode.get("returnType"), TypeRefImpl.class));
            }
            if (jsonNode.has("errors")) {
                LinkedHashMap<TypeName, List<String>> errorMap = new LinkedHashMap<TypeName, List<String>>();
                for (Map.Entry e : jsonNode.get("errors").properties()) {
                    errorMap.put(TypeName.parse((String)e.getKey()), (List)ctx.readTreeAsValue((JsonNode)e.getValue(), ERROR_LIST_TYPE));
                }
                operation.setErrorMap(errorMap);
            }
            return operation;
        }
    }

    public static class Serializer
    extends JsonSerializer<ApiOperationImpl<?>> {
        public void serialize(ApiOperationImpl<?> operation, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("name");
            gen.writeString(operation.getName());
            gen.writeFieldName("key");
            gen.writeString(operation.key());
            if (operation.getDoc() != null) {
                provider.defaultSerializeField("doc", (Object)operation.getDoc(), gen);
            }
            if (!operation.getParameters().isEmpty()) {
                provider.defaultSerializeField("parameters", operation.getParameters(), gen);
            }
            if (operation.getReturnType() != null) {
                provider.defaultSerializeField("returnType", (Object)operation.getReturnType(), gen);
            }
            if (!operation.getErrorMap().isEmpty()) {
                gen.writeFieldName("errors");
                gen.writeStartObject();
                for (Map.Entry<TypeName, List<String>> e : operation.getErrorMap().entrySet()) {
                    gen.writeFieldName(e.getKey().toString(true));
                    gen.writeObject(e.getValue());
                }
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
    }
}

