/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.jackson.meta.ConverterMetadata;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;

public class JacksonUtils {
    public static JavaType getJacksonType(ImmutableProp prop) {
        ConverterMetadata metadata = prop.getConverterMetadata();
        if (metadata != null) {
            return metadata.getTargetJacksonType();
        }
        if (prop.isReferenceList(TargetLevel.OBJECT) || prop.isScalarList()) {
            return CollectionType.construct(List.class, null, null, null, (JavaType)SimpleType.constructUnsafe(prop.getElementClass()));
        }
        try {
            return JacksonUtils.getJacksonType(prop.getGenericType());
        }
        catch (RuntimeException ex) {
            throw new ModelException("Illegal property \"prop\", cannot create jackson property: " + ex.getMessage(), ex);
        }
    }

    public static JavaType getJacksonType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType == Collection.class || rawType == List.class || rawType == Set.class) {
                return CollectionType.construct((Class)((Class)rawType), null, null, null, (JavaType)JacksonUtils.getJacksonType(parameterizedType.getActualTypeArguments()[0]));
            }
            if (rawType == Map.class) {
                return MapType.construct((Class)((Class)rawType), null, null, null, (JavaType)JacksonUtils.getJacksonType(parameterizedType.getActualTypeArguments()[0]), (JavaType)JacksonUtils.getJacksonType(parameterizedType.getActualTypeArguments()[1]));
            }
            throw new IllegalArgumentException("Parameterized type must be collection, list, set or map");
        }
        if (type instanceof TypeVariable) {
            return JacksonUtils.getJacksonType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return JacksonUtils.getJacksonType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrType = (GenericArrayType)type;
            return ArrayType.construct((JavaType)JacksonUtils.getJacksonType(arrType.getGenericComponentType()), null);
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return ArrayType.construct((JavaType)JacksonUtils.getJacksonType(clazz.getComponentType()), null);
        }
        return SimpleType.constructUnsafe((Class)clazz);
    }

    public static <A extends Annotation> A getAnnotation(ImmutableProp prop, Class<A> annotationType) {
        AnnotationSearchContext ctx = new AnnotationSearchContext(prop, annotationType);
        for (Annotation annotation : prop.getAnnotations()) {
            JacksonUtils.collectAnnotationType(annotation, ctx);
        }
        return ctx.getAnnotation();
    }

    private static <A extends Annotation> void collectAnnotationType(Annotation annotation, AnnotationSearchContext<A> ctx) {
        Class<? extends Annotation> curAnnotationType = annotation.annotationType();
        if (curAnnotationType == ctx.annotationType) {
            ctx.set(annotation);
            return;
        }
        if (!ctx.push(curAnnotationType)) {
            return;
        }
        for (Annotation deeperAnnotation : curAnnotationType.getAnnotations()) {
            JacksonUtils.collectAnnotationType(deeperAnnotation, ctx);
        }
        ctx.pop();
    }

    private static class AnnotationSearchContext<A extends Annotation> {
        private final ImmutableProp prop;
        final Class<A> annotationType;
        private LinkedList<Class<? extends Annotation>> pathStack = new LinkedList();
        private ArrayList<Class<? extends Annotation>> path;
        private A annotation;

        private AnnotationSearchContext(ImmutableProp prop, Class<A> annotationType) {
            this.prop = prop;
            this.annotationType = annotationType;
        }

        public boolean push(Class<? extends Annotation> annotationType) {
            if (this.pathStack.contains(annotationType)) {
                return false;
            }
            this.pathStack.push(annotationType);
            return true;
        }

        public void pop() {
            this.pathStack.pop();
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public void set(A annotation) {
            if (this.annotation != null && !this.annotation.equals(annotation)) {
                throw new ModelException("Illegal property \"" + this.prop + "\", conflict annotation \"@" + annotation.annotationType().getName() + "\", one " + AnnotationSearchContext.declaredPath(this.path) + " and the other one " + AnnotationSearchContext.declaredPath(this.pathStack));
            }
            if (this.annotation == null) {
                this.path = new ArrayList<Class<? extends Annotation>>(this.pathStack);
                this.annotation = annotation;
            }
        }

        private static String declaredPath(List<Class<? extends Annotation>> path) {
            if (path.isEmpty()) {
                return "is declared directly";
            }
            return "is declared as nest annotation: " + path;
        }
    }
}

