/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.util.Map;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.ApiOperationImpl;
import org.babyfish.jimmer.client.meta.impl.ApiParameterImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.PropImpl;
import org.babyfish.jimmer.client.meta.impl.SchemaBuilder;
import org.babyfish.jimmer.client.meta.impl.SchemaImpl;
import org.babyfish.jimmer.client.meta.impl.TypeDefinitionImpl;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;

public class TypeDefinitionVisitor<S>
implements AstNodeVisitor<S> {
    private final SchemaBuilder<S> builder;
    private final Map<TypeName, TypeDefinitionImpl<S>> typeDefinitionMap;

    public TypeDefinitionVisitor(SchemaBuilder<S> builder) {
        this.builder = builder;
        SchemaImpl schema = (SchemaImpl)builder.ancestor(SchemaImpl.class);
        this.typeDefinitionMap = schema.getTypeDefinitionMap();
    }

    @Override
    public void visitAstNode(AstNode<S> astNode) {
        if (astNode instanceof ApiOperationImpl || astNode instanceof ApiParameterImpl) {
            this.builder.push(astNode);
        } else if (astNode instanceof TypeRefImpl) {
            TypeName typeName = ((TypeRefImpl)astNode).getTypeName();
            if (!typeName.isGenerationRequired() || this.typeDefinitionMap.containsKey(typeName)) {
                return;
            }
            S source = this.builder.loadSource(typeName.toString());
            if (source == null) {
                this.builder.throwException(this.builder.ancestorSource(new Class[0]), "Cannot resolve the type name \"" + typeName + "\"");
            }
            this.builder.definition(source, typeName, definition -> {
                this.typeDefinitionMap.put(typeName, (TypeDefinitionImpl<S>)definition);
                this.builder.fillDefinition(source);
                for (Prop prop : definition.getPropMap().values()) {
                    ((PropImpl)prop).accept(this);
                }
                for (TypeRef superType : definition.getSuperTypes()) {
                    ((TypeRefImpl)superType).accept(this);
                }
            });
        }
    }

    @Override
    public void visitedAstNode(AstNode<S> astNode) {
        if (astNode instanceof ApiOperationImpl || astNode instanceof ApiParameterImpl) {
            this.builder.pop();
        }
    }
}

