/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.babyfish.jimmer.impl.util.LRUMap;

public class StaticCache<K, V> {
    private final Function<K, V> creator;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Map<K, V> positiveMap = new HashMap();
    private final Map<K, Void> negativeMap;

    public StaticCache(Function<K, V> creator) {
        this(creator, true);
    }

    public StaticCache(Function<K, V> creator, boolean nullable) {
        this.creator = creator;
        this.negativeMap = nullable ? new LRUMap() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V value;
        block14: {
            Lock lock = this.cacheLock.readLock();
            lock.lock();
            try {
                if (this.negativeMap != null && this.negativeMap.containsKey(key)) {
                    V v = null;
                    return v;
                }
                value = this.positiveMap.get(key);
            }
            finally {
                lock.unlock();
            }
            if (value == null) {
                lock = this.cacheLock.writeLock();
                lock.lock();
                try {
                    if (this.negativeMap != null && this.negativeMap.containsKey(key)) {
                        V v = null;
                        return v;
                    }
                    value = this.positiveMap.get(key);
                    if (value != null) break block14;
                    value = this.creator.apply(key);
                    if (value != null) {
                        this.positiveMap.put(key, value);
                        break block14;
                    }
                    if (this.negativeMap != null) {
                        this.negativeMap.put(key, null);
                        break block14;
                    }
                    throw new IllegalStateException("The creator cannot return null because current static cache does not accept null values");
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return value;
    }
}

