/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeDefinition;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.PropImpl;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TypeDefinitionImpl<S>
extends AstNode<S>
implements TypeDefinition {
    private final TypeName typeName;
    private boolean immutable;
    private Map<String, PropImpl<S>> propMap = new LinkedHashMap<String, PropImpl<S>>();
    private List<TypeRefImpl<S>> superTypes = new ArrayList<TypeRefImpl<S>>();
    private Doc doc;

    TypeDefinitionImpl(S source, TypeName typeName) {
        super(source);
        this.typeName = typeName;
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    @Override
    public Map<String, Prop> getPropMap() {
        return this.propMap;
    }

    public void addProp(PropImpl<S> prop) {
        this.propMap.put(prop.getName(), prop);
    }

    @Override
    public List<TypeRef> getSuperTypes() {
        return this.superTypes;
    }

    public void addSuperType(TypeRefImpl<S> superType) {
        this.superTypes.add(superType);
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        for (PropImpl<S> propImpl : this.propMap.values()) {
            propImpl.accept(visitor);
        }
        for (TypeRefImpl typeRefImpl : this.superTypes) {
            typeRefImpl.accept(visitor);
        }
    }

    public String toString() {
        return "TypeDefinitionImpl{typeName='" + this.typeName + '\'' + ", propMap=" + this.propMap + ", superTypes=" + this.superTypes + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<TypeDefinitionImpl<?>> {
        public TypeDefinitionImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            TypeDefinitionImpl<Object> definition = new TypeDefinitionImpl<Object>(null, (TypeName)ctx.readTreeAsValue(jsonNode.get("typeName"), TypeName.class));
            if (jsonNode.has("immutable")) {
                definition.setImmutable(jsonNode.get("immutable").asBoolean());
            }
            if (jsonNode.has("props")) {
                for (JsonNode propNode : jsonNode.get("props")) {
                    definition.addProp((PropImpl)ctx.readTreeAsValue(propNode, PropImpl.class));
                }
            }
            if (jsonNode.has("superTypes")) {
                for (JsonNode superNode : jsonNode.get("superTypes")) {
                    definition.addSuperType((TypeRefImpl)ctx.readTreeAsValue(superNode, TypeRefImpl.class));
                }
            }
            return definition;
        }
    }

    public static class Serializer
    extends JsonSerializer<TypeDefinitionImpl<?>> {
        public void serialize(TypeDefinitionImpl<?> definition, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            provider.defaultSerializeField("typeName", (Object)definition.getTypeName(), gen);
            if (definition.isImmutable()) {
                gen.writeFieldName("immutable");
                gen.writeBoolean(true);
            }
            if (!definition.getPropMap().isEmpty()) {
                provider.defaultSerializeField("props", definition.getPropMap().values(), gen);
            }
            if (!definition.getSuperTypes().isEmpty()) {
                provider.defaultSerializeField("superTypes", definition.getSuperTypes(), gen);
            }
            gen.writeEndObject();
        }
    }
}

