/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.babyfish.jimmer.client.meta.ApiParameter;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ApiParameterImpl<S>
extends AstNode<S>
implements ApiParameter {
    private final String name;
    private TypeRefImpl<S> type;

    ApiParameterImpl(S source, String name) {
        super(source);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeRef getType() {
        return this.type;
    }

    public void setType(TypeRefImpl<S> type) {
        this.type = type;
    }

    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        this.type.accept(visitor);
    }

    public String toString() {
        return "ParameterImpl{name='" + this.name + '\'' + ", type=" + this.type + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<ApiParameterImpl<?>> {
        public ApiParameterImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            ApiParameterImpl<Object> parameter = new ApiParameterImpl<Object>(null, jsonNode.get("name").asText());
            parameter.setType((TypeRefImpl)ctx.readTreeAsValue(jsonNode.get("type"), TypeRefImpl.class));
            return parameter;
        }
    }

    public static class Serializer
    extends JsonSerializer<ApiParameterImpl<?>> {
        public void serialize(ApiParameterImpl<?> parameter, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("name");
            gen.writeString(parameter.getName());
            provider.defaultSerializeField("type", (Object)parameter.getType(), gen);
            gen.writeEndObject();
        }
    }
}

