/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.client.meta.ApiOperation;
import org.babyfish.jimmer.client.meta.ApiParameter;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.ApiParameterImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ApiOperationImpl<S>
extends AstNode<S>
implements ApiOperation {
    private String name;
    private List<String> groups;
    private List<ApiParameterImpl<S>> parameters;
    private TypeRefImpl<S> returnType;
    private Doc doc;

    ApiOperationImpl(S source, String name) {
        super(source);
        this.name = name;
        this.parameters = new ArrayList<ApiParameterImpl<S>>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups == null || groups.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(groups);
    }

    @Override
    public List<ApiParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(ApiParameterImpl<S> parameter) {
        this.parameters.add(parameter);
    }

    @Override
    @Nullable
    public TypeRef getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeRefImpl<S> returnType) {
        this.returnType = returnType;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        for (ApiParameterImpl<S> parameter : this.parameters) {
            parameter.accept(visitor);
        }
        if (this.returnType != null) {
            this.returnType.accept(visitor);
        }
    }

    public String toString() {
        return "ApiOperationImpl{name='" + this.name + '\'' + ", parameters=" + this.parameters + ", returnType=" + this.returnType + ", doc='" + this.doc + '\'' + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<ApiOperationImpl<?>> {
        public ApiOperationImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            String name = jsonNode.get("name").asText();
            ApiOperationImpl<Object> operation = new ApiOperationImpl<Object>(null, name);
            if (jsonNode.has("doc")) {
                operation.setDoc((Doc)ctx.readTreeAsValue(jsonNode.get("doc"), Doc.class));
            }
            if (jsonNode.has("parameters")) {
                for (JsonNode paramNode : jsonNode.get("parameters")) {
                    ApiParameterImpl parameter = (ApiParameterImpl)ctx.readTreeAsValue(paramNode, ApiParameterImpl.class);
                    operation.addParameter(parameter);
                }
            }
            if (jsonNode.has("returnType")) {
                operation.setReturnType((TypeRefImpl)ctx.readTreeAsValue(jsonNode.get("returnType"), TypeRefImpl.class));
            }
            return operation;
        }
    }

    public static class Serializer
    extends JsonSerializer<ApiOperationImpl<?>> {
        public void serialize(ApiOperationImpl<?> operation, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("name");
            gen.writeString(operation.getName());
            if (operation.getDoc() != null) {
                provider.defaultSerializeField("doc", (Object)operation.getDoc(), gen);
            }
            if (!operation.getParameters().isEmpty()) {
                provider.defaultSerializeField("parameters", operation.getParameters(), gen);
            }
            if (operation.getReturnType() != null) {
                provider.defaultSerializeField("returnType", (Object)operation.getReturnType(), gen);
            }
            gen.writeEndObject();
        }
    }
}

