/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.evaluation;

import org.babyfish.jimmer.evaluation.Path;
import org.babyfish.jimmer.evaluation.Root;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PathImpl
implements Path {
    private final Root<?> root;
    private final PathImpl parent;
    private final ImmutableSpi source;
    private final ImmutableProp prop;
    private final int index;
    private final boolean loaded;
    private final Object value;
    private String str;

    PathImpl(Object parent, ImmutableSpi source, ImmutableProp prop, int index, boolean loaded, Object value) {
        if (parent instanceof Root) {
            this.root = (Root)parent;
            this.parent = null;
        } else {
            PathImpl parentCtx = (PathImpl)parent;
            this.root = parentCtx.root;
            this.parent = parentCtx;
        }
        this.source = source;
        this.prop = prop;
        this.index = index;
        this.loaded = loaded;
        this.value = value;
    }

    @Override
    @Nullable
    public Path getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public ImmutableSpi getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String s = this.str;
        if (s == null) {
            StringBuilder builder = new StringBuilder();
            this.toString("<root>", builder);
            this.str = s = builder.toString();
        }
        return s;
    }

    public String toString(String rootName) {
        if (rootName == null || rootName.isEmpty()) {
            return this.toString();
        }
        StringBuilder builder = new StringBuilder();
        this.toString(rootName, builder);
        return builder.toString();
    }

    private void toString(String rootName, StringBuilder builder) {
        if (this.parent != null) {
            this.parent.toString(rootName, builder);
        } else {
            builder.append(rootName);
        }
        if (this.index != -1) {
            if (this.prop.getCategory() == ImmutablePropCategory.REFERENCE_LIST) {
                builder.append('[').append(this.index).append(']');
            }
        } else {
            builder.append('.').append(this.prop.getName());
        }
    }
}

