/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.runtime.ListDraft;
import org.babyfish.jimmer.sql.collection.AbstractIdViewList;
import org.babyfish.jimmer.sql.collection.IdViewList;
import org.jetbrains.annotations.NotNull;

public final class MutableIdViewList<E, ID>
extends AbstractIdViewList<E, ID> {
    public MutableIdViewList(ImmutableType entityType, List<E> entityList) {
        super(entityType, entityList);
        if (!(entityList instanceof ListDraft)) {
            throw new IllegalArgumentException("base list of mutable id view list must be list draft");
        }
    }

    @Override
    @NotNull
    public List<ID> subList(int fromIndex, int toIndex) {
        return new IdViewList(this.entityType, this.entityList);
    }

    @Override
    @NotNull
    public Iterator<ID> iterator() {
        return new Itr(this, this.entityList.listIterator(0));
    }

    @Override
    @NotNull
    public ListIterator<ID> listIterator() {
        return new Itr(this, this.entityList.listIterator(0));
    }

    @Override
    @NotNull
    public ListIterator<ID> listIterator(int index) {
        return new Itr(this, this.entityList.listIterator(index));
    }

    @Override
    @Deprecated
    public boolean add(ID e) {
        return this.entityList.add(this.toEntity(e));
    }

    @Override
    @Deprecated
    public void add(int index, ID element) {
        this.entityList.add(index, this.toEntity(element));
    }

    @Override
    @Deprecated
    public boolean addAll(@NotNull Collection<? extends ID> c) {
        return this.entityList.addAll(this.toEntities(c));
    }

    @Override
    @Deprecated
    public boolean addAll(int index, @NotNull Collection<? extends ID> c) {
        return this.entityList.addAll(index, this.toEntities(c));
    }

    @Override
    @Deprecated
    public void clear() {
        this.entityList.clear();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        Iterator itr = this.entityList.iterator();
        while (itr.hasNext()) {
            Object entity = itr.next();
            if (!this.toId(entity).equals(o)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public ID remove(int index) {
        return this.toId(this.entityList.remove(index));
    }

    @Override
    @Deprecated
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean removed = false;
        Iterator itr = this.entityList.iterator();
        while (itr.hasNext()) {
            Object entity = itr.next();
            if (!c.contains(this.toId(entity))) continue;
            itr.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean removed = false;
        Iterator itr = this.entityList.iterator();
        while (itr.hasNext()) {
            Object entity = itr.next();
            if (c.contains(this.toId(entity))) continue;
            itr.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    public ID set(int index, ID element) {
        return this.toId(this.entityList.set(index, this.toEntity(element)));
    }

    private E toEntity(ID id) {
        return (E)Internal.produce(this.entityType, null, draft -> ((DraftSpi)draft).__set(this.idPropId, id));
    }

    private Collection<E> toEntities(Collection<? extends ID> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<E> entities = new ArrayList<E>(ids.size());
        for (ID id : ids) {
            entities.add(this.toEntity(id));
        }
        return entities;
    }

    static class Itr<E, ID>
    extends AbstractIdViewList.Itr<E, ID> {
        Itr(AbstractIdViewList<E, ID> owner, ListIterator<E> itr) {
            super(owner, itr);
        }

        @Override
        @Deprecated
        public void remove() {
            this.itr.remove();
        }

        @Override
        @Deprecated
        public void set(ID e) {
            this.itr.set(((MutableIdViewList)this.owner).toEntity(e));
        }

        @Override
        @Deprecated
        public void add(ID e) {
            this.itr.add(((MutableIdViewList)this.owner).toEntity(e));
        }
    }
}

