/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.util.function.Function;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;

public class FlatUtils {
    private FlatUtils() {
    }

    public static <T> T get(Object immutable, int[] propIds, Function<Object, Object> mapper) {
        PropId[] arr = new PropId[propIds.length];
        for (int i = propIds.length - 1; i >= 0; --i) {
            arr[i] = PropId.byIndex(propIds[i]);
        }
        return FlatUtils.get(immutable, arr, mapper);
    }

    public static <T> T get(Object immutable, PropId[] propIds, Function<Object, Object> mapper) {
        ImmutableSpi spi = (ImmutableSpi)immutable;
        for (PropId propId : propIds) {
            if (!spi.__isLoaded(propId)) {
                return null;
            }
            Object value = spi.__get(propId);
            if (!(value instanceof ImmutableSpi)) {
                return (T)(mapper != null ? mapper.apply(value) : value);
            }
            spi = (ImmutableSpi)value;
        }
        return (T)(mapper != null ? mapper.apply(spi) : spi);
    }

    public static void set(Draft draft, int[] propIds, Object value) {
        PropId[] arr = new PropId[propIds.length];
        for (int i = propIds.length - 1; i >= 0; --i) {
            arr[i] = PropId.byIndex(propIds[i]);
        }
        FlatUtils.set(draft, arr, value);
    }

    public static void set(Draft draft, PropId[] propIds, Object value) {
        PropId propId;
        int i;
        if (draft == null) {
            throw new IllegalArgumentException("draft cannot be null");
        }
        if (propIds.length == 0) {
            return;
        }
        DraftSpi spi = (DraftSpi)draft;
        int depth = propIds.length;
        DraftSpi[] sources = new DraftSpi[depth];
        ImmutableProp[] props = new ImmutableProp[depth];
        for (i = 0; i < depth; ++i) {
            propId = propIds[i];
            if (spi != null) {
                sources[i] = spi;
                props[i] = spi.__type().getProp(propId);
                spi = props[i].getTargetType() != null ? (DraftSpi)(spi.__isLoaded(propId) ? spi.__get(propId) : null) : null;
            } else {
                props[i] = props[i - 1].getTargetType().getProp(propId);
            }
            if (props[i].getTargetType() != null || i + 1 >= depth) continue;
            throw FlatUtils.notAssociation(i);
        }
        if (value == null && !props[depth - 1].isNullable()) {
            return;
        }
        for (i = depth - 1; i >= 0; --i) {
            propId = propIds[i];
            Object deeperValue = value;
            DraftSpi source = sources[i];
            if (source != null) {
                source.__set(propId, value);
                break;
            }
            ImmutableType immutableType = i > 0 ? props[i - 1].getTargetType() : ((DraftSpi)draft).__type();
            value = Internal.produce(immutableType, null, d -> ((DraftSpi)d).__set(propId, deeperValue));
        }
    }

    private static RuntimeException notAssociation(int index) {
        return new IllegalArgumentException("props[" + index + "] is not association");
    }
}

