/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.LogicalDeleted;

public final class LogicalDeletedInfo {
    private static final Map<Class<?>, Supplier<Object>> NOW_SUPPLIER_MAP;
    private final ImmutableProp prop;
    private final Action action;
    private final Object value;

    private LogicalDeletedInfo(ImmutableProp prop, Action action, Object value) {
        this.prop = prop;
        this.action = action;
        this.value = value;
    }

    public LogicalDeletedInfo to(ImmutableProp prop) {
        if (this.prop == prop) {
            return this;
        }
        return new LogicalDeletedInfo(this, prop);
    }

    private LogicalDeletedInfo(LogicalDeletedInfo base, ImmutableProp prop) {
        if (!base.prop.getName().equals(prop.getName()) || !base.prop.getDeclaringType().isAssignableFrom(prop.getDeclaringType())) {
            throw new IllegalArgumentException("\"" + prop + "\" does not hide \"" + base.prop + "\"");
        }
        this.prop = prop;
        this.action = base.action;
        this.value = base.value;
    }

    public ImmutableProp getProp() {
        return this.prop;
    }

    public Action getAction() {
        return this.action;
    }

    public Object getValue() {
        if (this.value instanceof Supplier) {
            return ((Supplier)this.value).get();
        }
        return this.value;
    }

    public String toString() {
        return "LogicalDeletedInfo{prop=" + this.prop + ", action=" + (Object)((Object)this.action) + ", value=" + this.value + '}';
    }

    public static LogicalDeletedInfo of(ImmutableProp prop) {
        LogicalDeleted deleted = prop.getAnnotation(LogicalDeleted.class);
        if (deleted == null) {
            return null;
        }
        Class<?> returnType = prop.getElementClass();
        if (prop.isAssociation(TargetLevel.OBJECT) || returnType != Boolean.TYPE && returnType != Integer.TYPE && !returnType.isEnum() && !NOW_SUPPLIER_MAP.containsKey(returnType)) {
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` so that it type must be boolean, integer, enum or time");
        }
        if (NOW_SUPPLIER_MAP.containsKey(returnType)) {
            if (!prop.isNullable()) {
                throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and returns \"" + returnType.getName() + "\" so that it must be nullable");
            }
        } else if (prop.isNullable()) {
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and returns \"" + returnType.getName() + "\" so that it cannot be nullable");
        }
        if (deleted.value().isEmpty()) {
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` but the `value` is empty string");
        }
        Object value = LogicalDeletedInfo.parseValue(prop, deleted.value(), "value");
        Action action = prop.isNullable() ? (value != null ? Action.IS_NULL : Action.IS_NOT_NULL) : Action.NE;
        return new LogicalDeletedInfo(prop, action, value);
    }

    private static Object parseValue(ImmutableProp prop, String value, String argumentName) {
        Class<?> type = prop.getElementClass();
        if (type == Boolean.TYPE) {
            switch (value) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is boolean, but the `" + argumentName + "` is \"" + value + "\" is neither \"true\" nor \"false\"");
        }
        if (type == Integer.TYPE) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is int, but the `" + argumentName + "` is \"" + value + "\" which is not a valid integer");
            }
        }
        if (type.isEnum()) {
            Enum[] constants;
            for (Enum constant : constants = (Enum[])type.getEnumConstants()) {
                if (!constant.name().equals(value)) continue;
                return constant;
            }
            throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is the enum type \"" + type.getName() + "\", but the `" + argumentName + "` is \"" + value + "\" which is not any one of: " + Arrays.stream(constants).map(Enum::name).collect(Collectors.toList()));
        }
        switch (value) {
            case "null": {
                return null;
            }
            case "now": {
                return NOW_SUPPLIER_MAP.get(type);
            }
        }
        throw new ModelException("Illegal property \"" + prop + "\", it is decorated by `@" + LogicalDeleted.class.getName() + "` and its type is the time type \"" + type.getName() + "\", but the `" + argumentName + "` is \"" + value + "\" which is neither \"null\" or \"now\"");
    }

    static {
        HashMap map = new HashMap();
        map.put(java.util.Date.class, java.util.Date::new);
        map.put(Date.class, () -> new Date(System.currentTimeMillis()));
        map.put(Time.class, () -> new Timestamp(System.currentTimeMillis()));
        map.put(Timestamp.class, () -> new Timestamp(System.currentTimeMillis()));
        map.put(LocalDateTime.class, LocalDateTime::now);
        map.put(LocalDate.class, LocalDate::now);
        map.put(LocalTime.class, LocalTime::now);
        map.put(OffsetDateTime.class, OffsetDateTime::now);
        map.put(ZonedDateTime.class, ZonedDateTime::now);
        NOW_SUPPLIER_MAP = map;
    }

    public static enum Action {
        NE,
        IS_NULL,
        IS_NOT_NULL;

    }
}

