/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.JimmerVersion;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ImmutableType {
    public static ImmutableType get(Class<?> javaClass) {
        return Metadata.get(javaClass);
    }

    public static ImmutableType tryGet(Class<?> javaClass) {
        return Metadata.tryGet(javaClass);
    }

    public static Builder newBuilder(String jimmerVersion, Class<?> javaClass, Collection<ImmutableType> superTypes, BiFunction<DraftContext, Object, Draft> draftFactory) {
        if (!JimmerVersion.CURRENT.toString().equals(jimmerVersion)) {
            throw new IllegalStateException("The version of the annotation processor for handling type \"" + javaClass.getName() + "\" is \"" + jimmerVersion + "\", but the current version of jimmer is \"" + JimmerVersion.CURRENT + "\"");
        }
        return Metadata.newTypeBuilder(javaClass, superTypes, draftFactory);
    }

    public static Builder newBuilder(String jimmerVersion, KClass<?> kotlinClass, Collection<ImmutableType> superTypes, BiFunction<DraftContext, Object, Draft> draftFactory) {
        if (!JimmerVersion.CURRENT.toString().equals(jimmerVersion)) {
            throw new IllegalStateException("The version of the KSP for handling type \"" + kotlinClass.getQualifiedName() + "\" is \"" + jimmerVersion + "\", but the current version of jimmer is \"" + JimmerVersion.CURRENT + "\"");
        }
        return Metadata.newTypeBuilder(kotlinClass, superTypes, draftFactory);
    }

    @NotNull
    public Class<?> getJavaClass();

    public boolean isKotlinClass();

    public boolean isEntity();

    public boolean isMappedSuperclass();

    public boolean isEmbeddable();

    @NotNull
    public Annotation getImmutableAnnotation();

    public boolean isAssignableFrom(ImmutableType var1);

    @Nullable
    public ImmutableType getPrimarySuperType();

    public Set<ImmutableType> getSuperTypes();

    public Set<ImmutableType> getAllTypes();

    @NotNull
    public BiFunction<DraftContext, Object, Draft> getDraftFactory();

    @NotNull
    public Map<String, ImmutableProp> getDeclaredProps();

    public ImmutableProp getIdProp();

    @Nullable
    public ImmutableProp getVersionProp();

    @Nullable
    public LogicalDeletedInfo getDeclaredLogicalDeletedInfo();

    @Nullable
    public LogicalDeletedInfo getLogicalDeletedInfo();

    @NotNull
    public Set<ImmutableProp> getKeyProps();

    @NotNull
    public Map<String, ImmutableProp> getProps();

    @NotNull
    public Map<String, ImmutableProp> getEntityProps();

    @NotNull
    public ImmutableProp getProp(String var1);

    @NotNull
    public ImmutableProp getProp(PropId var1);

    public Map<String, ImmutableProp> getSelectableProps();

    public Map<String, ImmutableProp> getSelectableScalarProps();

    public Map<String, ImmutableProp> getSelectableReferenceProps();

    public String getMicroServiceName();

    public String getTableName(MetadataStrategy var1);

    public IdGenerator getIdGenerator(MetadataStrategy var1);

    public List<ImmutableProp> getPropChain(String var1, MetadataStrategy var2);

    public static interface Builder {
        public Builder redefine(String var1, int var2);

        public Builder id(int var1, String var2, Class<?> var3);

        public Builder key(int var1, String var2, Class<?> var3, boolean var4);

        public Builder keyReference(int var1, String var2, Class<? extends Annotation> var3, Class<?> var4, boolean var5);

        public Builder version(int var1, String var2);

        public Builder logicalDeleted(int var1, String var2, Class<?> var3, boolean var4);

        public Builder add(int var1, String var2, ImmutablePropCategory var3, Class<?> var4, boolean var5);

        public Builder add(int var1, String var2, Class<? extends Annotation> var3, Class<?> var4, boolean var5);

        public ImmutableType build();
    }
}

