/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.meta;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.List;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.jackson.PropUtils;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;

class BeanMember
extends AnnotatedMember {
    private final ImmutableProp prop;
    private final JavaType type;

    BeanMember(TypeResolutionContext ctx, ImmutableProp prop) {
        super(ctx, BeanMember.annotationMap(prop));
        this.prop = prop;
        this.type = PropUtils.getJacksonType(prop);
    }

    public Annotated withAnnotations(AnnotationMap fallback) {
        return this;
    }

    public Class<?> getDeclaringClass() {
        return this.prop.getDeclaringType().getJavaClass();
    }

    public Member getMember() {
        return null;
    }

    public void setValue(Object pojo, Object value) throws UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("Cannot set immutable property");
    }

    public Object getValue(Object pojo) throws UnsupportedOperationException, IllegalArgumentException {
        return ImmutableObjects.get(pojo, this.prop.getId());
    }

    public AnnotatedElement getAnnotated() {
        return null;
    }

    protected int getModifiers() {
        return 0;
    }

    public String getName() {
        return this.prop.getName();
    }

    public JavaType getType() {
        return null;
    }

    public Class<?> getRawType() {
        if (this.prop.isScalarList() || this.prop.isReferenceList(TargetLevel.OBJECT)) {
            return List.class;
        }
        return this.prop.getElementClass();
    }

    public int hashCode() {
        return this.prop.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanMember)) {
            return false;
        }
        return this.prop == ((BeanMember)((Object)o)).prop;
    }

    public String toString() {
        return "BeanMember(" + this.prop + ")";
    }

    private static AnnotationMap annotationMap(ImmutableProp prop) {
        AnnotationMap map = new AnnotationMap();
        for (Annotation annotation : prop.getAnnotations()) {
            if (annotation.annotationType() == JsonIgnore.class || annotation.annotationType() == JsonFormat.class) {
                map = AnnotationMap.merge((AnnotationMap)map, (AnnotationMap)AnnotationMap.of(annotation.annotationType(), (Annotation)annotation));
                continue;
            }
            for (Annotation deeperAnnotation : annotation.annotationType().getAnnotations()) {
                if (deeperAnnotation.annotationType() != JsonIgnore.class && deeperAnnotation.annotationType() != JsonFormat.class) continue;
                map = AnnotationMap.merge((AnnotationMap)map, (AnnotationMap)AnnotationMap.of(deeperAnnotation.annotationType(), (Annotation)deeperAnnotation));
            }
        }
        return map;
    }
}

