/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.Column;
import org.babyfish.jimmer.sql.PropOverride;
import org.babyfish.jimmer.sql.PropOverrides;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;

class EmbeddedTree {
    private final EmbeddedTree parent;
    private final ImmutableProp prop;
    private final String path;
    private final int depth;
    private final Map<String, EmbeddedTree> childMap;
    private OverrideContext usedCtx;

    public EmbeddedTree(ImmutableProp prop) {
        this(null, prop);
        this.applyOverride();
    }

    private EmbeddedTree(EmbeddedTree parent, ImmutableProp prop) {
        EmbeddedTree p = parent;
        while (p != null) {
            if (p.prop.getDeclaringType() == prop.getTargetType()) {
                LinkedList<String> names = new LinkedList<String>();
                EmbeddedTree p2 = parent;
                while (p2 != null) {
                    names.add(0, p2.prop.getName());
                    if (p2 == p) break;
                    p2 = p2.parent;
                }
                throw new ModelException("Reference cycle is found in \"" + p.prop.getDeclaringType() + '.' + names.stream().collect(Collectors.joining(".")) + '.' + prop.getName() + "\"");
            }
            p = p.parent;
        }
        this.parent = parent;
        this.prop = prop;
        if (parent == null) {
            this.path = "";
            this.depth = 0;
        } else {
            String parentPath = parent.path;
            this.path = parentPath.isEmpty() ? prop.getName() : parentPath + '.' + prop.getName();
            this.depth = parent.depth + 1;
        }
        if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            LinkedHashMap<String, EmbeddedTree> map = new LinkedHashMap<String, EmbeddedTree>();
            for (ImmutableProp childProp : prop.getTargetType().getProps().values()) {
                map.put(childProp.getName(), new EmbeddedTree(this, childProp));
            }
            this.childMap = map;
        } else {
            this.childMap = Collections.emptyMap();
        }
    }

    private void applyOverride() {
        PropOverride propOverride;
        PropOverrides propOverrides = this.prop.getAnnotation(PropOverrides.class);
        if (propOverrides != null) {
            for (PropOverride propOverride2 : propOverrides.value()) {
                this.applyOverride(propOverride2.prop(), new OverrideContext(this.prop, this.depth, propOverride2));
            }
        }
        if ((propOverride = this.prop.getAnnotation(PropOverride.class)) != null) {
            this.applyOverride(propOverride.prop(), new OverrideContext(this.prop, this.depth, propOverride));
        }
        for (EmbeddedTree childTree : this.childMap.values()) {
            childTree.applyOverride();
        }
    }

    private void applyOverride(String path, OverrideContext ctx) {
        boolean tooLong;
        String rest;
        String propName;
        int index = path.indexOf(46);
        if (index == -1) {
            propName = path;
            rest = null;
        } else {
            propName = path.substring(0, index);
            rest = path.substring(index + 1);
        }
        EmbeddedTree childTree = this.childMap.get(propName);
        if (childTree == null) {
            throw new ModelException("Illegal property \"" + ctx.prop + "\", the path \"" + ctx.annotation.prop() + "\" of `@PropOverride` is illegal, there is no property \"" + propName + "\" declared in \"" + this.prop.getDeclaringType() + "\"");
        }
        boolean tooShort = rest == null && childTree.prop.isEmbedded(EmbeddedLevel.SCALAR);
        boolean bl = tooLong = rest != null && !childTree.prop.isEmbedded(EmbeddedLevel.SCALAR);
        if (tooLong || tooShort) {
            throw new ModelException("Illegal property \"" + ctx.prop + "\", the property path \"" + ctx.annotation.prop() + "\" of `@PropOverride` is too " + (tooLong ? "long" : "short"));
        }
        if (rest == null) {
            childTree.useOverride(ctx);
        } else {
            childTree.applyOverride(rest, ctx);
        }
    }

    private void useOverride(OverrideContext ctx) {
        if (this.usedCtx == null || ctx.depth < this.usedCtx.depth) {
            this.usedCtx = ctx;
        } else if (this.usedCtx.depth == ctx.depth) {
            throw new ModelException("Illegal property \"" + ctx.prop + "\", the property path \"" + ctx.annotation.prop() + "\" and \"" + this.usedCtx.annotation.prop() + "\" of `@PropOverride`s are conflict");
        }
    }

    public EmbeddedColumns toEmbeddedColumns(DatabaseNamingStrategy databaseNamingStrategy) {
        CollectContext ctx = new CollectContext(this.prop, databaseNamingStrategy);
        this.collect(ctx);
        return ctx.toEmbeddedColumns(this.prop.getTargetType());
    }

    private void collect(CollectContext ctx) {
        ctx.accept(this);
        for (EmbeddedTree childTree : this.childMap.values()) {
            childTree.collect(ctx);
        }
    }

    private static String userDefinedColumnName(ImmutableProp prop) {
        Column column = prop.getAnnotation(Column.class);
        if (column == null) {
            return null;
        }
        if (prop.getTargetType() != null && prop.getTargetType().isEmbeddable()) {
            throw new ModelException("Illegal property \"" + prop + "\", it cannot be decorated by \"@" + Column.class.getName() + "\" because it is embedded property");
        }
        String value = column.name();
        return value.isEmpty() ? null : column.name();
    }

    private static class OverrideContext {
        final ImmutableProp prop;
        final int depth;
        final PropOverride annotation;

        private OverrideContext(ImmutableProp prop, int depth, PropOverride annotation) {
            this.prop = prop;
            this.depth = depth;
            this.annotation = annotation;
        }
    }

    private static class CollectContext {
        private final ImmutableProp prop;
        private final DatabaseNamingStrategy databaseNamingStrategy;
        private final Map<String, String> identifierPathMap = new LinkedHashMap<String, String>();
        private final Map<String, EmbeddedColumns.PathData> pathMap = new LinkedHashMap<String, EmbeddedColumns.PathData>();

        private CollectContext(ImmutableProp prop, DatabaseNamingStrategy strategy) {
            this.prop = prop;
            this.databaseNamingStrategy = strategy;
        }

        public void accept(EmbeddedTree tree) {
            if (tree.childMap.isEmpty() && !tree.prop.isFormula()) {
                String comparableIdentifier;
                String conflictPath;
                String columnName = null;
                if (tree.usedCtx != null) {
                    columnName = ((EmbeddedTree)tree).usedCtx.annotation.columnName();
                }
                if (columnName == null && (columnName = EmbeddedTree.userDefinedColumnName(tree.prop)) == null) {
                    columnName = this.databaseNamingStrategy.columnName(tree.prop);
                }
                if ((conflictPath = this.identifierPathMap.put(comparableIdentifier = DatabaseIdentifiers.comparableIdentifier(columnName), tree.path)) != null) {
                    throw new ModelException("The property \"" + this.prop + "\" is illegal, its an embedded property but both the path `" + conflictPath + "` and `" + tree.path + "` has been mapped to an same column \"" + columnName + "\"");
                }
                EmbeddedTree t = tree;
                while (t != null) {
                    boolean isTerminal = tree == t;
                    this.pathMap.computeIfAbsent((String)((EmbeddedTree)t).path, (Function<String, EmbeddedColumns.PathData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$accept$0(boolean java.lang.String ), (Ljava/lang/String;)Lorg/babyfish/jimmer/sql/meta/EmbeddedColumns$PathData;)((boolean)isTerminal)).columnNames.add(columnName);
                    t = t.parent;
                }
            }
        }

        public EmbeddedColumns toEmbeddedColumns(ImmutableType type) {
            return new EmbeddedColumns(this.pathMap, type);
        }

        private static /* synthetic */ EmbeddedColumns.PathData lambda$accept$0(boolean isTerminal, String it) {
            return new EmbeddedColumns.PathData(isTerminal);
        }
    }
}

