/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.jetbrains.annotations.NotNull;

public class SingleColumn
implements ColumnDefinition {
    private final String name;
    private final boolean isForeignKey;
    private final String sqlElementType;
    private final String sqlType;

    public SingleColumn(String name, boolean isForeignKey, String sqlElementType, String sqlType) {
        this.name = name;
        this.isForeignKey = isForeignKey;
        this.sqlElementType = sqlElementType != null && !sqlElementType.isEmpty() ? sqlElementType : null;
        this.sqlType = sqlType != null && !sqlType.isEmpty() ? sqlType : null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public String getSqlElementType() {
        return this.sqlElementType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public String name(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.name;
    }

    @Override
    public int index(String name) {
        return this.name.equals(name) ? 0 : -1;
    }

    @Override
    public Set<String> toColumnNames() {
        return Collections.singleton(DatabaseIdentifiers.comparableIdentifier(this.name));
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Itr(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleColumn column = (SingleColumn)o;
        return this.isForeignKey == column.isForeignKey && this.name.equals(column.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isForeignKey);
    }

    public String toString() {
        return "SingleColumn{name='" + this.name + '\'' + '}';
    }

    private static class Itr
    implements Iterator<String> {
        private final String name;
        private boolean terminated;

        private Itr(String name) {
            this.name = name;
        }

        @Override
        public boolean hasNext() {
            return !this.terminated;
        }

        @Override
        public String next() {
            if (this.terminated) {
                throw new NoSuchElementException();
            }
            this.terminated = true;
            return this.name;
        }
    }
}

