/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.sql.meta.MultipleColumns;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;

public class MultipleJoinColumns
extends MultipleColumns {
    private static final String[] EMPTY_ARR = new String[0];
    private final String[] referencedColumnNames;
    private final boolean isForeignKey;

    public MultipleJoinColumns(Map<String, String> referencedColumnMap, boolean isEmbedded, boolean isForeignKey) {
        super(referencedColumnMap.keySet().toArray(EMPTY_ARR), isEmbedded);
        this.referencedColumnNames = referencedColumnMap.values().toArray(new String[0]);
        this.isForeignKey = isForeignKey;
    }

    public String referencedName(int index) {
        return this.referencedColumnNames[index];
    }

    public int referencedIndex(String referencedName) {
        referencedName = DatabaseIdentifiers.comparableIdentifier(referencedName);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!referencedName.equals(DatabaseIdentifiers.comparableIdentifier(referencedName))) continue;
            return i;
        }
        throw new IllegalArgumentException("There is no referenced column \"" + referencedName + "\"");
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultipleJoinColumns that = (MultipleJoinColumns)o;
        return this.isForeignKey == that.isForeignKey && Arrays.equals(this.referencedColumnNames, that.referencedColumnNames);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.isForeignKey);
        result = 31 * result + Arrays.hashCode(this.referencedColumnNames);
        return result;
    }

    @Override
    public String toString() {
        return "MultipleJoinColumns{arr=" + Arrays.toString(this.arr) + ", embedded=" + this.embedded + ", referencedColumnNames=" + Arrays.toString(this.referencedColumnNames) + ", isForeignKey=" + this.isForeignKey + '}';
    }
}

