/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.JoinTable;

public class JoinTableFilterInfo {
    private static final Map<Class<?>, Function<JsonNode, Object>> JSON_NODE_VALUE_GETTER_MAP;
    private final String columnName;
    private final Class<?> type;
    private final List<Object> values;
    private final Function<JsonNode, Object> jsonNodeValueGetter;

    public JoinTableFilterInfo(String columnName, Class<?> type, List<Object> values) {
        this.columnName = columnName;
        this.type = type;
        this.values = values;
        this.jsonNodeValueGetter = JSON_NODE_VALUE_GETTER_MAP.get(type);
        if (this.jsonNodeValueGetter == null) {
            throw new IllegalArgumentException("type must be one of " + JSON_NODE_VALUE_GETTER_MAP.keySet());
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinTableFilterInfo that = (JoinTableFilterInfo)o;
        if (!this.columnName.equals(that.columnName)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.columnName.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        return "JoinTableFilterInfo{columnName='" + this.columnName + '\'' + ", type=" + this.type + ", values=" + this.values + '}';
    }

    public static JoinTableFilterInfo of(ImmutableProp prop) {
        JoinTable joinTable;
        if (prop.getMappedBy() != null) {
            prop = prop.getMappedBy();
        }
        if ((joinTable = prop.getAnnotation(JoinTable.class)) == null) {
            return null;
        }
        JoinTable.JoinTableFilter filter = joinTable.filter();
        if (filter == null) {
            return null;
        }
        if (filter.columnName().equals("<illegal-column-name>")) {
            return null;
        }
        if (filter.columnName().isEmpty()) {
            throw new ModelException("Illegal property \"" + prop + "\", the argument \"columnName\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" cannot be empty string");
        }
        Class<?> type = filter.type();
        if (!(type.isPrimitive() || type == String.class || filter.type() == String.class && filter.values().length == 0)) {
            throw new ModelException("Illegal property \"" + prop + "\", the argument \"type\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" must be primitive type of string");
        }
        String[] values = filter.values();
        if (values.length == 0) {
            throw new ModelException("Illegal property \"" + prop + "\", the argument \"values\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" cannot be default value");
        }
        TreeSet<Object> parsedValues = new TreeSet<Object>();
        for (String value : values) {
            Object parsedValue = JoinTableFilterInfo.parseValue(value, type, prop);
            if (parsedValues.add(parsedValue)) continue;
            throw new ModelException("Illegal property \"" + prop + "\", the elements of the argument \"values\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" are not unique, the duplicated value is \"" + parsedValue + "\"");
        }
        return new JoinTableFilterInfo(filter.columnName(), type, Collections.unmodifiableList(new ArrayList(parsedValues)));
    }

    private static Object parseValue(String value, Class<?> type, ImmutableProp prop) {
        if (value.equals("null")) {
            throw new ModelException("Illegal property \"" + prop + "\", the argument \"values\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" cannot contains \"null\"");
        }
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (type == Character.TYPE) {
            if (value.length() != 1) {
                throw new ModelException("Illegal property \"" + prop + "\", the argument \"values\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" cannot contains \"" + value + "\" because its type is char");
            }
            return value;
        }
        try {
            if (type == Byte.TYPE) {
                return Byte.parseByte(value);
            }
            if (type == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (type == Integer.TYPE) {
                return Integer.parseInt(value);
            }
            if (type == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (type == Double.TYPE) {
                return Double.parseDouble(value);
            }
        }
        catch (NumberFormatException ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the argument \"values\" of \"@" + JoinTable.JoinTableFilter.class.getName() + "\" cannot contains \"" + value + "\" which cannot be parsed to \"" + type.getName() + "\"");
        }
        throw new AssertionError((Object)"Internal bug: Illegal filtered column type");
    }

    public Object parse(JsonNode node) {
        return this.jsonNodeValueGetter.apply(node);
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, jsonNode -> {
            String text = jsonNode.asText();
            if ("true".equals(text) || "yes".equals(text)) {
                return true;
            }
            return jsonNode.asInt() != 0;
        });
        map.put(Character.TYPE, JsonNode::asText);
        map.put(Byte.TYPE, jsonNode -> (byte)jsonNode.asInt());
        map.put(Short.TYPE, jsonNode -> (short)jsonNode.asInt());
        map.put(Integer.TYPE, JsonNode::asInt);
        map.put(Long.TYPE, JsonNode::asLong);
        map.put(Float.TYPE, jsonNode -> Float.valueOf((float)jsonNode.asDouble()));
        map.put(Double.TYPE, JsonNode::asDouble);
        map.put(String.class, JsonNode::asText);
        JSON_NODE_VALUE_GETTER_MAP = map;
    }
}

