/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.jackson.Converter;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;

public class DtoPropAccessor {
    private final boolean acceptNull;
    private final PropId propId;
    private final PropId[] propIds;
    private final Function<Object, Object> getterConverter;
    private final Function<Object, Object> setterConverter;

    public DtoPropAccessor(boolean acceptNull, int[] propIds) {
        this(acceptNull, propIds, null, null);
    }

    public DtoPropAccessor(boolean acceptNull, int[] propIds, Function<Object, Object> getterConverter, Function<Object, Object> setterConverter) {
        this.acceptNull = acceptNull;
        switch (propIds.length) {
            case 0: {
                throw new IllegalArgumentException("`propIds` cannot be empty");
            }
            case 1: {
                this.propId = PropId.byIndex(propIds[0]);
                this.propIds = null;
                break;
            }
            default: {
                this.propId = null;
                PropId[] arr = new PropId[propIds.length];
                for (int i = arr.length - 1; i >= 0; --i) {
                    arr[i] = PropId.byIndex(propIds[i]);
                }
                this.propIds = arr;
            }
        }
        this.getterConverter = getterConverter;
        this.setterConverter = setterConverter;
    }

    public <T> T get(Object immutable, String nullMessage) {
        T value = this.get(immutable);
        if (value == null) {
            throw new IllegalArgumentException(nullMessage);
        }
        return value;
    }

    public boolean isLoaded(Object immutable) {
        ImmutableSpi spi = (ImmutableSpi)immutable;
        PropId thePropId = this.propId;
        if (thePropId != null) {
            return spi.__isLoaded(thePropId);
        }
        for (PropId propId : this.propIds) {
            if (!spi.__isLoaded(propId)) {
                return false;
            }
            Object value = spi.__get(propId);
            if (!(value instanceof ImmutableSpi)) {
                return true;
            }
            spi = (ImmutableSpi)value;
        }
        return true;
    }

    public <T> T get(Object immutable) {
        ImmutableSpi spi = (ImmutableSpi)immutable;
        Function<Object, Object> mapper = this.getterConverter;
        PropId thePropId = this.propId;
        if (thePropId != null) {
            if (!spi.__isLoaded(thePropId)) {
                return null;
            }
            Object value = spi.__get(this.propId);
            return (T)(mapper != null && value != null ? mapper.apply(value) : value);
        }
        for (PropId propId : this.propIds) {
            if (!spi.__isLoaded(propId)) {
                return null;
            }
            Object value = spi.__get(propId);
            if (!(value instanceof ImmutableSpi)) {
                return (T)(mapper != null && value != null ? mapper.apply(value) : value);
            }
            spi = (ImmutableSpi)value;
        }
        return (T)(mapper != null ? mapper.apply(spi) : spi);
    }

    public void set(Draft draft, Object value) {
        PropId propId;
        int i;
        if (draft == null) {
            throw new IllegalArgumentException("draft cannot be null");
        }
        if (value != null && this.setterConverter != null) {
            value = this.setterConverter.apply(value);
        }
        if (value == null && !this.acceptNull) {
            return;
        }
        DraftSpi spi = (DraftSpi)draft;
        PropId thePropId = this.propId;
        if (thePropId != null) {
            spi.__set(thePropId, value);
            return;
        }
        int depth = this.propIds.length;
        DraftSpi[] sources = new DraftSpi[depth];
        ImmutableProp[] props = new ImmutableProp[depth];
        for (i = 0; i < depth; ++i) {
            propId = this.propIds[i];
            if (spi != null) {
                sources[i] = spi;
                props[i] = spi.__type().getProp(propId);
                spi = props[i].getTargetType() != null ? (DraftSpi)(spi.__isLoaded(propId) ? spi.__get(propId) : null) : null;
            } else {
                props[i] = props[i - 1].getTargetType().getProp(propId);
            }
            if (props[i].getTargetType() != null || i + 1 >= depth) continue;
            throw DtoPropAccessor.notAssociation(i);
        }
        if (value == null && !props[depth - 1].isNullable()) {
            return;
        }
        for (i = depth - 1; i >= 0; --i) {
            propId = this.propIds[i];
            Object deeperValue = value;
            DraftSpi source = sources[i];
            if (source != null) {
                source.__set(propId, value);
                break;
            }
            ImmutableType immutableType = i > 0 ? props[i - 1].getTargetType() : ((DraftSpi)draft).__type();
            value = Internal.produce(immutableType, null, d -> ((DraftSpi)d).__set(propId, deeperValue));
        }
    }

    private static RuntimeException notAssociation(int index) {
        return new IllegalArgumentException("props[" + index + "] is not association");
    }

    public static Function<Object, Object> idListGetter(Class<?> targetEntityType, Converter<?, ?> targetIdConverter) {
        ImmutableType targetType = ImmutableType.get(targetEntityType);
        PropId targetIdPropId = targetType.getIdProp().getId();
        return arg -> {
            List targets = (List)arg;
            ArrayList<Object> targetIds = new ArrayList<Object>(targets.size());
            if (targetIdConverter == null) {
                for (ImmutableSpi target : targets) {
                    targetIds.add(target.__get(targetIdPropId));
                }
            } else {
                for (ImmutableSpi target : targets) {
                    targetIds.add(targetIdConverter.output(target.__get(targetIdPropId)));
                }
            }
            return targetIds;
        };
    }

    public static Function<Object, Object> idListSetter(Class<?> targetEntityType, Converter<?, ?> targetIdConverter) {
        ImmutableType targetType = ImmutableType.get(targetEntityType);
        PropId targetIdPropId = targetType.getIdProp().getId();
        return arg -> {
            List targetIds = (List)arg;
            ArrayList<Object> targets = new ArrayList<Object>(targetIds.size());
            if (targetIdConverter == null) {
                for (Object targetId : targetIds) {
                    targets.add(Internal.produce(targetType, null, draft -> ((DraftSpi)draft).__set(targetIdPropId, targetId)));
                }
            } else {
                for (Object targetId : targetIds) {
                    targets.add(Internal.produce(targetType, null, draft -> ((DraftSpi)draft).__set(targetIdPropId, targetIdConverter.input(targetId))));
                }
            }
            return targets;
        };
    }

    public static Function<Object, Object> idReferenceGetter(Class<?> targetEntityType, Converter<?, ?> targetIdConverter) {
        ImmutableType targetType = ImmutableType.get(targetEntityType);
        PropId targetIdPropId = targetType.getIdProp().getId();
        if (targetIdConverter == null) {
            return arg -> ((ImmutableSpi)arg).__get(targetIdPropId);
        }
        return arg -> targetIdConverter.output(((ImmutableSpi)arg).__get(targetIdPropId));
    }

    public static Function<Object, Object> idReferenceSetter(Class<?> targetEntityType, Converter<?, ?> targetIdConverter) {
        ImmutableType targetType = ImmutableType.get(targetEntityType);
        PropId targetIdPropId = targetType.getIdProp().getId();
        return arg -> Internal.produce(targetType, null, draft -> ((DraftSpi)draft).__set(targetIdPropId, targetIdConverter == null ? arg : targetIdConverter.input(arg)));
    }

    public static <E, D> Function<Object, Object> objectListGetter(Function<E, D> constructor) {
        return arg -> {
            List entities = (List)arg;
            ArrayList dtoList = new ArrayList(entities.size());
            for (Object entity : entities) {
                dtoList.add(constructor.apply(entity));
            }
            return dtoList;
        };
    }

    public static <E, D> Function<Object, Object> objectListSetter(Function<D, E> toEntity) {
        return arg -> {
            List dtoList = (List)arg;
            ArrayList entities = new ArrayList(dtoList.size());
            for (Object dto : dtoList) {
                entities.add(toEntity.apply(dto));
            }
            return entities;
        };
    }

    public static <E, D> Function<Object, Object> objectReferenceGetter(Function<E, D> constructor) {
        return constructor;
    }

    public static <E, D> Function<Object, Object> objectReferenceSetter(Function<D, E> toImmutable) {
        return toImmutable;
    }
}

