/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.Scalar;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.jackson.Converter;
import org.babyfish.jimmer.jackson.ConverterMetadata;
import org.babyfish.jimmer.jackson.JacksonUtils;
import org.babyfish.jimmer.jackson.JsonConverter;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.Dependency;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.ImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.meta.impl.Utils;
import org.babyfish.jimmer.meta.spi.ImmutablePropImplementor;
import org.babyfish.jimmer.sql.Default;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ExcludeFromAllScalars;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.IdView;
import org.babyfish.jimmer.sql.JoinSql;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.OrderedProp;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.Version;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.meta.impl.LogicalDeletedValueGenerators;
import org.babyfish.jimmer.sql.meta.impl.MetaCache;
import org.babyfish.jimmer.sql.meta.impl.MetadataLiterals;
import org.babyfish.jimmer.sql.meta.impl.SqlContextCache;
import org.babyfish.jimmer.sql.meta.impl.Storages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutablePropImpl
implements ImmutableProp,
ImmutablePropImplementor {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final LogicalDeletedValueGenerator<?> NIL_LOGICAL_DELETED_VALUE_GENERATOR = new LogicalDeletedValueGenerator<Object>(){

        @Override
        public Object generate() {
            throw new UnsupportedOperationException();
        }
    };
    private static Lock META_LOCK = new ReentrantLock();
    private static final Ref<Object> NIL_REF = Ref.of(null);
    private final ImmutableTypeImpl declaringType;
    private final PropId id;
    private final String name;
    private final ImmutablePropCategory category;
    private final Class<?> elementClass;
    private final boolean nullable;
    private final boolean inputNotNull;
    private final KProperty1<?, ?> kotlinProp;
    private final Method javaGetter;
    private final Annotation associationAnnotation;
    private final Class<? extends Annotation> primaryAnnotationType;
    private final boolean isTargetTransferable;
    private final boolean isTransient;
    private final boolean hasTransientResolver;
    private final boolean isFormula;
    private final SqlTemplate sqlTemplate;
    private final DissociateAction dissociateAction;
    private final ImmutablePropImpl original;
    private ConverterMetadata converterMetadata;
    private boolean converterMetadataResolved;
    private int storageType;
    private ImmutableTypeImpl targetType;
    private boolean targetTypeResolved;
    private List<OrderedItem> orderedItems;
    private ImmutableProp mappedBy;
    private ImmutableProp acceptedMappedBy;
    private boolean mappedByResolved;
    private ImmutableProp opposite;
    private boolean oppositeResolved;
    private List<Dependency> dependencies;
    private List<ImmutableProp> propsDependOnSelf;
    private Ref<Object> defaultValueRef;
    private Boolean isExcludedFromAllScalarsRef;
    private ImmutableProp idViewProp;
    private boolean idViewPropResolved;
    private ImmutableProp idViewBaseProp;
    private boolean idViewBasePropResolved;
    private ImmutableProp manyToManyViewBaseProp;
    private ImmutableProp manyToManyViewBaseDeeperProp;
    private boolean manyToManyViewBasePropResolved;
    private Boolean isRemote;
    private final MetaCache<Storage> storageCache = new MetaCache<Storage>(it -> Storages.of(this, it));
    private final MetaCache<Boolean> isTargetForeignKeyRealCache = new MetaCache<Boolean>(this::isTargetForeignKeyReal0);
    private final SqlContextCache<LogicalDeletedValueGenerator<?>> logicalDeletedValueGeneratorCache = new SqlContextCache<LogicalDeletedValueGenerator>(it -> {
        ImmutableProp prop = this.getMappedBy() != null ? this.getMappedBy() : this;
        Object storage = prop.getStorage(it.getMetadataStrategy());
        if (storage instanceof MiddleTable) {
            LogicalDeletedValueGenerator<?> g = LogicalDeletedValueGenerators.of(((MiddleTable)storage).getLogicalDeletedInfo(), it);
            return g != null ? g : NIL_LOGICAL_DELETED_VALUE_GENERATOR;
        }
        return NIL_LOGICAL_DELETED_VALUE_GENERATOR;
    });

    ImmutablePropImpl(ImmutableTypeImpl declaringType, PropId id, String name, ImmutablePropCategory category, Class<?> elementClass, boolean nullable, Class<? extends Annotation> associationType) {
        this.declaringType = declaringType;
        this.id = id;
        this.name = name;
        this.category = category;
        this.elementClass = elementClass;
        this.nullable = nullable;
        KClass<?> kotlinClass = declaringType.getKotlinClass();
        this.kotlinProp = kotlinClass != null ? KClasses.getDeclaredMemberProperties(kotlinClass).stream().filter(it -> name.equals(it.getName())).findFirst().get() : null;
        Method javaGetter = null;
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            if (javaGetter.getReturnType() != Boolean.TYPE) {
                javaGetter = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (javaGetter == null) {
            throw new AssertionError((Object)("Internal bug: Cannot find the getter of prop \"" + name + "\" of the interface \"" + declaringType.getJavaClass().getName() + "\""));
        }
        this.javaGetter = javaGetter;
        OneToMany oneToMany = this.getAnnotation(OneToMany.class);
        this.isTargetTransferable = oneToMany != null ? oneToMany.isTargetTransferable() : true;
        Transient trans = this.getAnnotation(Transient.class);
        this.isTransient = trans != null;
        this.hasTransientResolver = trans != null && (trans.value() != Void.TYPE || !trans.ref().isEmpty());
        Formula formula = this.getAnnotation(Formula.class);
        if (declaringType.isEmbeddable() && formula != null && !formula.sql().isEmpty()) {
            throw new ModelException("Illegal property \"" + this + "\", The sql based formula property cannot be declared in embeddable type");
        }
        boolean bl = this.isFormula = formula != null;
        if (formula != null && this.isAssociation(TargetLevel.ENTITY)) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + Formula.class.getName() + "\" so that it cannot be association");
        }
        JoinSql joinSql = this.getAnnotation(JoinSql.class);
        if (formula != null && !formula.sql().isEmpty()) {
            try {
                this.sqlTemplate = FormulaTemplate.of(formula.sql());
            }
            catch (IllegalArgumentException ex) {
                throw new ModelException("Illegal property \"" + this + "\", the formula sql template: " + ex.getMessage());
            }
        } else {
            this.sqlTemplate = joinSql != null ? JoinTemplate.of(joinSql.value()) : null;
        }
        ManyToOne manyToOne = this.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        boolean bl2 = manyToOne != null ? manyToOne.inputNotNull() : (this.inputNotNull = oneToOne != null && oneToOne.inputNotNull());
        if (this.isInputNotNull() && !nullable) {
            throw new ModelException("Illegal property \"" + this + "\", the `inputNotNull` cannot be specified for non-null property");
        }
        OnDissociate onDissociate = this.getAnnotation(OnDissociate.class);
        if (onDissociate != null) {
            if (category != ImmutablePropCategory.REFERENCE) {
                throw new ModelException("Illegal property \"" + this + "\", only reference property can be decorated by @OnDissociate");
            }
            if (oneToOne != null && !oneToOne.mappedBy().isEmpty()) {
                throw new ModelException("Illegal property \"" + this + "\", the one-to-one property with `mappedBy` cannot be decorated by @OnDissociate");
            }
            this.dissociateAction = onDissociate.value();
        } else {
            this.dissociateAction = DissociateAction.NONE;
        }
        if (associationType != null) {
            this.associationAnnotation = this.getAnnotation(associationType);
            this.primaryAnnotationType = associationType;
        } else {
            this.associationAnnotation = null;
            this.primaryAnnotationType = this.isId() ? Id.class : (this.isVersion() ? Version.class : (this.isLogicalDeleted() ? LogicalDeleted.class : (this.isFormula ? Formula.class : (this.isTransient ? Transient.class : (this.getAnnotation(IdView.class) != null ? IdView.class : (this.getAnnotation(ManyToManyView.class) != null ? ManyToManyView.class : Scalar.class))))));
        }
        this.original = null;
    }

    ImmutablePropImpl(ImmutablePropImpl original, ImmutableTypeImpl declaringType, PropId id) {
        if (!original.getDeclaringType().isAssignableFrom(declaringType)) {
            throw new IllegalArgumentException("The new declaring type \"" + declaringType + "\" is illegal, it is not derived type of original declaring type \"" + original.getDeclaringType() + "\"");
        }
        while (original.original != null) {
            original = original.original;
        }
        this.declaringType = declaringType;
        this.id = id != null ? id : original.id;
        this.name = original.name;
        this.category = original.category;
        this.elementClass = original.elementClass;
        this.nullable = original.nullable;
        this.inputNotNull = original.inputNotNull;
        this.kotlinProp = original.kotlinProp;
        this.javaGetter = original.javaGetter;
        this.associationAnnotation = original.associationAnnotation;
        this.primaryAnnotationType = original.primaryAnnotationType;
        this.isTargetTransferable = original.isTargetTransferable;
        this.isTransient = original.isTransient;
        this.isFormula = original.isFormula;
        this.sqlTemplate = original.sqlTemplate;
        this.hasTransientResolver = original.hasTransientResolver;
        this.dissociateAction = original.dissociateAction;
        this.original = original;
    }

    @Override
    @NotNull
    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public PropId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ImmutablePropCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    @NotNull
    public Class<?> getReturnClass() {
        return this.javaGetter.getReturnType();
    }

    @Override
    @NotNull
    public Type getGenericType() {
        return this.javaGetter.getGenericReturnType();
    }

    @Override
    public boolean isEmbedded(EmbeddedLevel level) {
        ImmutableType targetType = this.getTargetType();
        if (level.hasReference() && this.isReference(TargetLevel.PERSISTENT) && targetType.getIdProp().isEmbedded(EmbeddedLevel.SCALAR)) {
            return true;
        }
        return level.hasScalar() && targetType != null && targetType.isEmbeddable();
    }

    @Override
    public boolean isScalar(TargetLevel level) {
        if (level == TargetLevel.OBJECT) {
            return this.category == ImmutablePropCategory.SCALAR;
        }
        ImmutableType targetType = this.getTargetType();
        return targetType == null || !targetType.isEntity();
    }

    @Override
    public boolean isScalarList() {
        return this.category == ImmutablePropCategory.SCALAR_LIST;
    }

    @Override
    public boolean isAssociation(TargetLevel level) {
        if (!this.category.isAssociation()) {
            return false;
        }
        int ordinal = level.ordinal();
        if (ordinal >= TargetLevel.ENTITY.ordinal() && !this.getTargetType().isEntity()) {
            return false;
        }
        return ordinal < TargetLevel.PERSISTENT.ordinal() || !this.isTransient && !this.isRemote();
    }

    @Override
    public boolean isReference(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE && this.isAssociation(level);
    }

    @Override
    public boolean isReferenceList(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE_LIST && this.isAssociation(level);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isInputNotNull() {
        return this.inputNotNull;
    }

    @Override
    public boolean isMutable() {
        return !this.isFormula || this.sqlTemplate instanceof FormulaTemplate;
    }

    @Override
    public Method getJavaGetter() {
        return this.javaGetter;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Annotation annotation;
        if (this.kotlinProp != null && (annotation = (Annotation)this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).findFirst().orElse(null)) != null) {
            return (A)annotation;
        }
        return this.javaGetter.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] getterArr = this.javaGetter.getAnnotations();
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = this.kotlinProp.getAnnotations().toArray(EMPTY_ANNOTATIONS);
        }
        if (propArr == null || propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = new Annotation[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        Annotation[] getterArr = this.javaGetter.getAnnotationsByType(annotationType);
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = (Annotation[])this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).toArray();
        }
        if (propArr == null || propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = (Annotation[])new Object[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    @Override
    public Class<? extends Annotation> getPrimaryAnnotationType() {
        return this.primaryAnnotationType;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean hasTransientResolver() {
        return this.hasTransientResolver;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public boolean isTargetForeignKeyReal(MetadataStrategy strategy) {
        return this.isTargetForeignKeyRealCache.get(strategy);
    }

    private boolean isTargetForeignKeyReal0(MetadataStrategy strategy) {
        if (!this.isAssociation(TargetLevel.PERSISTENT)) {
            return false;
        }
        Object storage = this.getStorage(strategy);
        if (storage == null) {
            ImmutableProp mappedBy = this.getMappedBy();
            if (mappedBy != null && !this.isRemote() && (storage = mappedBy.getStorage(strategy)) instanceof MiddleTable) {
                return ((MiddleTable)storage).getColumnDefinition().isForeignKey();
            }
            return false;
        }
        if (storage instanceof MiddleTable) {
            return ((MiddleTable)storage).getTargetColumnDefinition().isForeignKey();
        }
        if (storage instanceof ColumnDefinition) {
            return ((ColumnDefinition)storage).isForeignKey();
        }
        return false;
    }

    @Override
    @Nullable
    public SqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    @Override
    public boolean isView() {
        return this.idViewBaseProp != null || this.manyToManyViewBaseProp != null;
    }

    @Override
    public ImmutableProp getIdViewProp() {
        if (this.idViewPropResolved) {
            return this.idViewProp;
        }
        if (this.isAssociation(TargetLevel.ENTITY)) {
            for (ImmutableProp otherProp : this.declaringType.getProps().values()) {
                if (otherProp.getIdViewBaseProp() != this) continue;
                this.idViewProp = otherProp;
                break;
            }
        }
        this.idViewPropResolved = true;
        return this.idViewProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableProp getIdViewBaseProp() {
        if (this.idViewBasePropResolved) {
            return this.idViewBaseProp;
        }
        META_LOCK.lock();
        try {
            ImmutableProp baseProp;
            if (this.idViewBasePropResolved) {
                ImmutableProp immutableProp = this.idViewBaseProp;
                return immutableProp;
            }
            IdView idView = this.getAnnotation(IdView.class);
            if (idView == null) {
                baseProp = null;
            } else {
                String basePropName;
                if (this.isAssociation(TargetLevel.ENTITY)) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" so that it cannot be association");
                }
                if (idView.value().isEmpty()) {
                    basePropName = Utils.defaultViewBasePropName(this.isReferenceList(TargetLevel.OBJECT) || this.isScalarList(), this.name);
                    if (basePropName == null) {
                        throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" but the base property name cannot be determined automatically");
                    }
                } else {
                    basePropName = idView.value();
                }
                if ((baseProp = this.declaringType.getProps().get(basePropName)) == null) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" but there is not base property named \"" + basePropName + "\" in the type \"" + this.declaringType + "\"");
                }
                if (baseProp.isTransient()) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar list property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\" but the base property \"" + baseProp + "\" is not a reference list property");
                }
                if (this.isScalarList() && !baseProp.isReferenceList(TargetLevel.ENTITY)) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar list property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\" but the base property \"" + baseProp + "\" is not a reference list property");
                }
                if (!this.isScalarList() && !baseProp.isReference(TargetLevel.ENTITY)) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\" but the base property \"" + baseProp + "\" is not a reference property");
                }
                if (!Classes.matches(baseProp.getTargetType().getIdProp().getElementClass(), this.getElementClass())) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\", the base property \"" + baseProp + "\" return the entity type whose id is \"" + baseProp.getTargetType().getIdProp().getElementClass() + "\" but the element type of the current property is \"" + this.getElementClass() + "\"");
                }
                if (this.isNullable() != baseProp.isNullable()) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\", but the nullity of current property does not equal to the nullity of the base property \"" + baseProp + "\"");
                }
            }
            this.idViewBaseProp = baseProp;
            this.idViewBasePropResolved = true;
            ImmutableProp immutableProp = baseProp;
            return immutableProp;
        }
        finally {
            META_LOCK.unlock();
        }
    }

    @Override
    public ImmutableProp getManyToManyViewBaseProp() {
        this.resolveManyToManyViewBaseProp();
        return this.manyToManyViewBaseProp;
    }

    @Override
    public ImmutableProp getManyToManyViewBaseDeeperProp() {
        this.resolveManyToManyViewBaseProp();
        return this.manyToManyViewBaseDeeperProp;
    }

    private void resolveManyToManyViewBaseProp() {
        if (this.manyToManyViewBasePropResolved) {
            return;
        }
        ManyToManyView manyToManyView = this.getAnnotation(ManyToManyView.class);
        if (manyToManyView == null) {
            return;
        }
        String propName = manyToManyView.prop();
        ImmutableProp prop = this.declaringType.getProps().get(propName);
        if (prop == null) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but there is not base property named \"" + propName + "\" in the type \"" + this.declaringType + "\"");
        }
        if (prop.getAnnotation(OneToMany.class) == null) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" with `prop` \"" + propName + "\", but prop \"" + prop + "\" in the type is not an one-to-many association");
        }
        ImmutableType middleType = prop.getTargetType();
        String deeperPropName = manyToManyView.deeperProp();
        ImmutableProp deeperProp = null;
        if (deeperPropName.isEmpty()) {
            for (ImmutableProp middleProp : middleType.getProps().values()) {
                if (middleProp.getTargetType() != this.getTargetType() || middleProp.getAnnotation(ManyToOne.class) == null) continue;
                if (deeperProp != null) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but the middle entity has two many-to-one association properties pointing to target type: \"" + deeperProp + "\" and \"" + middleProp + "\"");
                }
                deeperProp = middleProp;
            }
            if (deeperProp == null) {
                throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but the middle entity \"" + middleType + "\" has no many-to-one association properties pointing to target type: ");
            }
        } else {
            deeperProp = middleType.getProps().get(deeperPropName);
            if (deeperProp == null) {
                throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but there is not property \"" + deeperPropName + "\" in the middle entity type: " + middleType);
            }
        }
        if (deeperProp.getAnnotation(ManyToOne.class) == null || deeperProp.getTargetType() != this.getTargetType()) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but the deeper property \"" + deeperProp + "\" is not a many-to-one proerty pointing to the target type \"" + this.getTargetType() + "\"");
        }
        this.manyToManyViewBaseProp = prop;
        this.manyToManyViewBaseDeeperProp = deeperProp;
        this.manyToManyViewBasePropResolved = true;
    }

    @Override
    public ConverterMetadata getConverterMetadata() {
        if (this.converterMetadataResolved) {
            return this.converterMetadata;
        }
        ConverterMetadata metadata = null;
        if (this.getIdViewBaseProp() != null) {
            metadata = this.getIdViewBaseProp().getTargetType().getIdProp().getConverterMetadata();
            if (metadata != null && this.getIdViewBaseProp().isReferenceList(TargetLevel.ENTITY)) {
                metadata = metadata.toListMetadata();
            }
        } else {
            JsonConverter jsonConverter = JacksonUtils.getAnnotation(this, JsonConverter.class);
            if (jsonConverter != null) {
                Class type;
                if (this.isAssociation(TargetLevel.OBJECT)) {
                    throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by \"@" + JsonConverter.class + "\" because it is " + (this.isReferenceList(TargetLevel.OBJECT) ? "list" : "reference") + " of immutable object");
                }
                if (JacksonUtils.getAnnotation(this, JsonFormat.class) != null) {
                    throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by both \"@" + JsonConverter.class + "\" and \"@" + JsonFormat.class + "\"");
                }
                metadata = ConverterMetadata.of(jsonConverter.value());
                Class<?> genericReturnType = this.getJavaGetter().getGenericReturnType();
                if (genericReturnType instanceof Class && (type = (Class)genericReturnType).isPrimitive()) {
                    genericReturnType = Classes.boxTypeOf(type);
                }
                if (!metadata.getSourceType().equals(genericReturnType)) {
                    throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + JsonConverter.class.getName() + ", the property type \"" + this.javaGetter.getGenericReturnType() + "\" does not match the source type \"" + metadata.getSourceType() + "\" of converter class \"" + metadata.getConverter().getClass().getName() + "\"");
                }
            }
        }
        this.converterMetadata = metadata;
        this.converterMetadataResolved = true;
        return metadata;
    }

    @Override
    @Nullable
    public <S, T> Converter<S, T> getConverter() {
        return this.getConverter(false);
    }

    @Override
    public <S, T> Converter<S, T> getConverter(boolean forList) {
        ConverterMetadata metadata = this.getConverterMetadata();
        if (metadata == null) {
            return null;
        }
        if (forList) {
            metadata = metadata.toListMetadata();
        }
        return metadata.getConverter();
    }

    @Override
    @Nullable
    public <S, T> Converter<S, T> getAssociatedIdConverter(boolean forList) {
        ImmutableType target = this.getTargetType();
        if (target == null) {
            throw new IllegalStateException("The current property \"" + this + "\" is not association");
        }
        ConverterMetadata metadata = this.targetType.getIdProp().getConverterMetadata();
        if (metadata == null) {
            return null;
        }
        metadata = forList && this.isReferenceList(TargetLevel.ENTITY) ? metadata.toListMetadata() : metadata;
        return metadata.getConverter();
    }

    @Override
    @NotNull
    public DissociateAction getDissociateAction() {
        return this.dissociateAction;
    }

    @Override
    public boolean hasStorage() {
        return this.getStorageType() > 1;
    }

    @Override
    public boolean isColumnDefinition() {
        return this.getStorageType() == 2;
    }

    @Override
    public boolean isMiddleTableDefinition() {
        return this.getStorageType() == 3;
    }

    @Override
    public <S extends Storage> S getStorage(MetadataStrategy strategy) {
        if (this.getStorageType() <= 1) {
            return null;
        }
        return (S)this.storageCache.get(strategy);
    }

    private int getStorageType() {
        int type = this.storageType;
        if (type == 0) {
            META_LOCK.lock();
            try {
                type = this.storageType;
                if (type == 0) {
                    int result = this.isTransient() || this.isFormula() || !this.getDependencies().isEmpty() || this.getSqlTemplate() instanceof JoinTemplate || this.getMappedBy() != null ? 1 : (!(this.associationAnnotation instanceof ManyToMany) && this.getAnnotation(JoinTable.class) == null ? 2 : 3);
                    this.storageType = type = result;
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return type;
    }

    @Override
    public LogicalDeletedValueGenerator<?> getLogicalDeletedValueGenerator(SqlContext sqlContext) {
        LogicalDeletedValueGenerator<?> generator = this.logicalDeletedValueGeneratorCache.get(sqlContext);
        return generator == NIL_LOGICAL_DELETED_VALUE_GENERATOR ? null : generator;
    }

    @Override
    public boolean isId() {
        return this == this.declaringType.getIdProp() || this.original != null && this.original.isId();
    }

    @Override
    public boolean isVersion() {
        return this == this.declaringType.getVersionProp() || this.original != null && this.original.isVersion();
    }

    @Override
    public boolean isLogicalDeleted() {
        LogicalDeletedInfo info = this.declaringType.getLogicalDeletedInfo();
        return info != null && info.getProp() == this || this.original != null && this.original.isLogicalDeleted();
    }

    @Override
    public ImmutableType getTargetType() {
        if (this.targetTypeResolved) {
            return this.targetType;
        }
        META_LOCK.lock();
        try {
            if (this.targetTypeResolved) {
                ImmutableTypeImpl immutableTypeImpl = this.targetType;
                return immutableTypeImpl;
            }
            if (this.isAssociation(TargetLevel.OBJECT)) {
                this.targetType = (ImmutableTypeImpl)Metadata.tryGet(this.elementClass);
                if (this.targetType == null) {
                    throw new ModelException("Cannot resolve target type of \"" + this + "\"");
                }
                if (this.sqlTemplate != null && this.declaringType.isEntity() && !this.declaringType.getMicroServiceName().equals(this.targetType.getMicroServiceName())) {
                    throw new ModelException("Illegal association property \"" + this + "\", it is is remote association so that it cannot be decorated by \"@" + JoinSql.class.getName() + "\"");
                }
            }
            this.targetTypeResolved = true;
            ImmutableTypeImpl immutableTypeImpl = this.targetType;
            return immutableTypeImpl;
        }
        finally {
            META_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderedItem> getOrderedItems() {
        List<OrderedItem> orderedItems = this.orderedItems;
        if (orderedItems == null) {
            META_LOCK.lock();
            try {
                orderedItems = this.orderedItems;
                if (orderedItems == null) {
                    OrderedProp[] orderedProps = null;
                    if (this.isReferenceList(TargetLevel.PERSISTENT)) {
                        OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                        if (oneToMany != null) {
                            orderedProps = oneToMany.orderedProps();
                        } else {
                            ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
                            if (manyToMany != null) {
                                orderedProps = manyToMany.orderedProps();
                            }
                        }
                    }
                    if (orderedProps == null || orderedProps.length == 0) {
                        orderedItems = Collections.emptyList();
                    } else {
                        ImmutableType targetType = this.getTargetType();
                        LinkedHashMap<String, OrderedItem> map = new LinkedHashMap<String, OrderedItem>((orderedProps.length * 4 + 2) / 3);
                        for (OrderedProp orderedProp : orderedProps) {
                            if (map.containsKey(orderedProp.value())) {
                                throw new ModelException("Illegal property \"" + this + "\", duplicated ordered property \"" + orderedProp.value() + "\"");
                            }
                            ImmutableProp prop = targetType.getProps().get(orderedProp.value());
                            if (prop == null) {
                                throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + orderedProp.value() + "\" is not declared in target type \"" + targetType + "\"");
                            }
                            if (!prop.isScalar(TargetLevel.PERSISTENT)) {
                                throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + prop + "\" is not scalar field");
                            }
                            map.put(orderedProp.value(), new OrderedItem(prop, orderedProp.desc()));
                        }
                        orderedItems = Collections.unmodifiableList(new ArrayList(map.values()));
                    }
                    this.orderedItems = orderedItems;
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return orderedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableProp getMappedBy() {
        if (this.mappedByResolved) {
            return this.mappedBy;
        }
        META_LOCK.lock();
        try {
            String mappedBy;
            if (this.mappedByResolved) {
                ImmutableProp immutableProp = this.mappedBy;
                return immutableProp;
            }
            if (this.isAssociation(TargetLevel.ENTITY) && !(mappedBy = this.getMappedByValue()).isEmpty()) {
                ImmutableProp resolved = this.getTargetType().getProps().get(mappedBy);
                if (resolved == null) {
                    throw new ModelException("Cannot resolve the mappedBy property name \"" + mappedBy + "\" for property \"" + this + "\"");
                }
                if (!resolved.hasStorage() && !(resolved.getSqlTemplate() instanceof JoinTemplate)) {
                    throw new ModelException("The property \"" + resolved + "\" is illegal, it's not persistence property so that \"" + this + "\" cannot reference it by \"mappedBy\"");
                }
                Annotation resolvedAssociationAnnotation = resolved.getAssociationAnnotation();
                if (resolvedAssociationAnnotation == null) {
                    throw new ModelException("Illegal property \"" + this + "\", because its \"mappedBy\" property \"" + resolved + "\" is not association property");
                }
                if (resolvedAssociationAnnotation.annotationType() == OneToOne.class && this.associationAnnotation.annotationType() != OneToOne.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
                }
                if (resolvedAssociationAnnotation.annotationType() == ManyToOne.class && this.associationAnnotation.annotationType() != OneToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
                }
                if (resolved.isReferenceList(TargetLevel.PERSISTENT) && this.associationAnnotation.annotationType() != ManyToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be many-to-many property because its \"mappedBy\" property \"" + resolved + "\" is list");
                }
                ((ImmutablePropImpl)resolved).acceptMappedBy(this);
                this.mappedBy = resolved;
            }
            this.mappedByResolved = true;
            ImmutableProp immutableProp = this.mappedBy;
            return immutableProp;
        }
        finally {
            META_LOCK.unlock();
        }
    }

    String getMappedByValue() {
        String mappedBy = "";
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            mappedBy = oneToOne.mappedBy();
        }
        if (mappedBy.isEmpty()) {
            ManyToMany manyToMany;
            OneToMany oneToMany = this.getAnnotation(OneToMany.class);
            if (oneToMany != null) {
                mappedBy = oneToMany.mappedBy();
            }
            if (mappedBy.isEmpty() && (manyToMany = this.getAnnotation(ManyToMany.class)) != null) {
                mappedBy = manyToMany.mappedBy();
            }
        }
        return mappedBy;
    }

    private void acceptMappedBy(ImmutableProp prop) {
        if (this.acceptedMappedBy != null) {
            throw new ModelException("Both `" + this.acceptedMappedBy + "` and `" + prop + "` use `mappedBy` to reference `" + this + "`");
        }
        this.acceptedMappedBy = prop;
    }

    @Override
    public ImmutableProp getOpposite() {
        if (this.oppositeResolved) {
            return this.opposite;
        }
        META_LOCK.lock();
        try {
            if (this.oppositeResolved) {
                ImmutableProp immutableProp = this.opposite;
                return immutableProp;
            }
            if (this.isAssociation(TargetLevel.PERSISTENT)) {
                if (!this.declaringType.isEntity()) {
                    throw new UnsupportedOperationException("Cannot access the `opposite` of \"" + this + "\" because it is not declared in entity");
                }
                this.opposite = this.getMappedBy();
                if (this.opposite == null) {
                    for (ImmutableProp backProp : this.getTargetType().getProps().values()) {
                        if (backProp.getMappedBy() != this) continue;
                        this.opposite = backProp;
                        break;
                    }
                }
            }
            this.oppositeResolved = true;
            ImmutableProp immutableProp = this.opposite;
            return immutableProp;
        }
        finally {
            META_LOCK.unlock();
        }
    }

    @Override
    public ImmutableProp getReal() {
        ImmutableProp mappedBy = this.getMappedBy();
        return mappedBy != null ? mappedBy : this;
    }

    @Override
    public List<Dependency> getDependencies() {
        List<Dependency> list = this.dependencies;
        if (list == null) {
            META_LOCK.lock();
            try {
                list = this.dependencies;
                if (list == null) {
                    this.dependencies = list = Collections.unmodifiableList(this.getDependenciesImpl(new LinkedList<ImmutableProp>()));
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImmutableProp> getPropsDependOnSelf() {
        List<ImmutableProp> list = this.propsDependOnSelf;
        if (list == null) {
            META_LOCK.lock();
            try {
                list = this.propsDependOnSelf;
                if (list == null) {
                    list = new ArrayList<ImmutableProp>();
                    for (ImmutableProp prop : this.getDeclaringType().getProps().values()) {
                        if (prop == this || !prop.getDependencies().stream().anyMatch(it -> it.getProps().get(0) == this)) continue;
                        list.add(prop);
                    }
                    this.propsDependOnSelf = Collections.unmodifiableList(list);
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref<Object> getDefaultValueRef() {
        Ref<Object> ref = this.defaultValueRef;
        if (ref == null) {
            META_LOCK.lock();
            try {
                ref = this.defaultValueRef;
                if (ref == null) {
                    Default dft = this.getAnnotation(Default.class);
                    if (dft == null || dft.value().isEmpty()) {
                        if (this.isLogicalDeleted()) {
                            LogicalDeletedInfo info = this.declaringType.getLogicalDeletedInfo();
                            assert (info != null);
                            ref = Ref.of(info.allocateInitializedValue());
                        } else {
                            ref = NIL_REF;
                        }
                    } else {
                        if (this.isId()) {
                            throw new ModelException("Illegal property \"" + this + "\", the id property cannot be decorated by \"@" + Default.class.getName() + "\"");
                        }
                        if (this.isReferenceList(TargetLevel.ENTITY)) {
                            throw new ModelException("Illegal property \"" + this + "\", the association property cannot be decorated by \"@" + Default.class.getName() + "\"");
                        }
                        if (this.isEmbedded(EmbeddedLevel.BOTH)) {
                            throw new ModelException("Illegal property \"" + this + "\", the embedded property cannot be decorated by \"@" + Default.class.getName() + "\"");
                        }
                        if (this.isFormula()) {
                            throw new ModelException("Illegal property \"" + this + "\", the formula property cannot be decorated by \"@" + Default.class.getName() + "\"");
                        }
                        if (this.isTransient()) {
                            throw new ModelException("Illegal property \"" + this + "\", the tranisent property cannot be decorated by \"@" + Default.class.getName() + "\"");
                        }
                        if (this.getIdViewBaseProp() != null || this.getManyToManyViewBaseProp() != null) {
                            throw new ModelException("Illegal property \"" + this + "\", the view property cannot be decorated by \"@" + Default.class.getName() + "\"");
                        }
                        Object value = MetadataLiterals.valueOf(this.getGenericType(), this.isNullable(), dft.value());
                        ref = Ref.of(value);
                    }
                    this.defaultValueRef = ref;
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return ref == NIL_REF ? null : ref;
    }

    @Override
    public boolean isExcludedFromAllScalars() {
        Boolean ref = this.isExcludedFromAllScalarsRef;
        if (ref == null) {
            META_LOCK.lock();
            try {
                ref = this.isExcludedFromAllScalarsRef;
                if (ref == null) {
                    boolean isExecluded = false;
                    if (this.kotlinProp != null) {
                        isExecluded = this.kotlinProp.getAnnotations().stream().anyMatch(it -> it.annotationType() == ExcludeFromAllScalars.class);
                    }
                    if (!isExecluded) {
                        isExecluded = this.javaGetter.isAnnotationPresent(ExcludeFromAllScalars.class);
                    }
                    this.isExcludedFromAllScalarsRef = ref = Boolean.valueOf(isExecluded);
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return ref;
    }

    @Override
    public boolean isRemote() {
        Boolean remote = this.isRemote;
        if (remote == null) {
            META_LOCK.lock();
            try {
                remote = this.isRemote;
                if (remote == null) {
                    if (this.isAssociation(TargetLevel.ENTITY)) {
                        remote = !this.declaringType.getMicroServiceName().equals(this.getTargetType().getMicroServiceName());
                        if (remote.booleanValue() && this.sqlTemplate != null) {
                            throw new ModelException("Illegal property \"" + this + "\", remote association(micro-service names of declaring type and target type are different) cannot be decorated by \"@" + JoinSql.class.getName() + "\"");
                        }
                    } else {
                        remote = false;
                    }
                    this.isRemote = remote;
                }
            }
            finally {
                META_LOCK.unlock();
            }
        }
        return remote;
    }

    @Override
    public ImmutableProp toOriginal() {
        return this.original != null ? this.original : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getDependenciesImpl(LinkedList<ImmutableProp> stack) {
        List<Dependency> list;
        block12: {
            list = this.dependencies;
            if (list == null) {
                META_LOCK.lock();
                try {
                    list = this.dependencies;
                    if (list != null) break block12;
                    list = new ArrayList<Dependency>();
                    Formula formula = this.getAnnotation(Formula.class);
                    if (formula != null) {
                        String[] arr = formula.dependencies();
                        if (arr.length == 0) break block12;
                        Map<String, ImmutableProp> propMap = this.declaringType.getProps();
                        stack.push(this);
                        try {
                            for (String dependency : arr) {
                                list.add(ImmutablePropImpl.createFormulaDependency(stack, this, dependency));
                            }
                            break block12;
                        }
                        finally {
                            stack.pop();
                        }
                    }
                    if (this.getIdViewBaseProp() != null) {
                        list.add(new Dependency(Collections.singletonList(this.getIdViewBaseProp())));
                    } else if (this.getManyToManyViewBaseProp() != null) {
                        list.add(new Dependency(this.getManyToManyViewBaseProp(), this.getManyToManyViewBaseDeeperProp()));
                    }
                }
                finally {
                    META_LOCK.unlock();
                }
            }
        }
        return list;
    }

    ImmutableProp getOriginal() {
        return this.original;
    }

    public int hashCode() {
        return this.declaringType.hashCode() ^ System.identityHashCode(this.original != null ? this.original : this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutablePropImpl)) {
            return false;
        }
        ImmutablePropImpl prop = (ImmutablePropImpl)o;
        return this.declaringType == prop.declaringType && (this.original != null ? this.original : this) == (prop.original != null ? prop.original : prop);
    }

    public String toString() {
        return this.declaringType.toString() + '.' + this.name;
    }

    private static Dependency createFormulaDependency(LinkedList<ImmutableProp> stack, ImmutableProp formulaProp, String dependency) {
        String[] propNames = DOT_PATTERN.split(dependency);
        int len = propNames.length;
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>(len);
        ImmutableType declaringType = formulaProp.getDeclaringType();
        for (int i = 0; i < len; ++i) {
            String propName = propNames[i];
            ImmutableProp prop = declaringType.getProps().get(propName);
            if (prop == null) {
                throw new ModelException("Illegal property \"" + formulaProp + "\", its dependency \"" + dependency + "\" cannot be resolved because there is no property \"" + propName + "\" in the type \"" + declaringType + "\"");
            }
            if (stack.contains(prop)) {
                throw new ModelException("Illegal entity type \"" + declaringType + "\", dependency cycle has been found: " + stack);
            }
            ImmutableType targetType = prop.getTargetType();
            if (i + 1 == len) {
                boolean isValid;
                boolean bl = isValid = prop.isFormula() || len > 1 || prop.hasStorage() || prop.isReferenceList(TargetLevel.PERSISTENT);
                if (!isValid) {
                    throw new ModelException("Illegal property \"" + formulaProp + "\", its dependency property \"" + prop + "\" must be column-mapped property or another formula property");
                }
            } else if (targetType == null) {
                throw new ModelException("Illegal property \"" + formulaProp + "\", its dependency \"" + dependency + "\" cannot be resolved because the property \"" + prop + "\" is not last property but it is neither association nor embedded property");
            }
            if (prop.isFormula()) {
                if (prop.getSqlTemplate() instanceof FormulaTemplate) {
                    throw new ModelException("Illegal property \"" + formulaProp + "\", it is an abstract formula property based on SQL exception but its dependency property \"" + prop + "\" is another formula property(This is only allowed for non-abstract formula property based on java/kotlin expression)");
                }
                ((ImmutablePropImpl)prop).getDependenciesImpl(stack);
            }
            props.add(prop);
            declaringType = targetType;
        }
        return new Dependency(props);
    }
}

