/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.meta.MultipleColumns;

public class EmbeddedColumns
extends MultipleColumns {
    private static final String[] EMPTY_ARR = new String[0];
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private final Map<String, List<ImmutableProp>> terminatorMap;
    private final List<ImmutableProp>[] propsArr;
    private final Map<String, Partial> partialMap;

    public EmbeddedColumns(Map<String, PathData> pathDataMap, ImmutableType type) {
        super(pathDataMap.get((Object)"").columnNames.toArray(EMPTY_ARR), true);
        HashMap<String, Partial> map = new HashMap<String, Partial>();
        HashMap<String, List<ImmutableProp>> terminatorMap = new HashMap<String, List<ImmutableProp>>();
        for (Map.Entry<String, PathData> e : pathDataMap.entrySet()) {
            String key = e.getKey();
            PathData pathData = e.getValue();
            map.put(key, new Partial(key, pathData.columnNames, pathData.isTerminal));
            if (pathData.columnNames.size() != 1) continue;
            String[] propNames = DOT_PATTERN.split(key);
            ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>(propNames.length);
            ImmutableType t = type;
            for (String propName : propNames) {
                ImmutableProp prop = t.getProp(propName);
                props.add(prop);
                t = prop.getTargetType();
            }
            terminatorMap.put(pathData.columnNames.get(0), Collections.unmodifiableList(props));
        }
        List[] propsArr = new List[this.size()];
        for (int i = 0; i < propsArr.length; ++i) {
            propsArr[i] = (List)terminatorMap.get(this.name(i));
        }
        this.terminatorMap = terminatorMap;
        this.propsArr = propsArr;
        this.partialMap = map;
    }

    public List<ImmutableProp> path(String columnName) {
        return this.terminatorMap.get(columnName);
    }

    public List<ImmutableProp> path(int index) {
        return this.propsArr[index];
    }

    public Partial partial(String path) {
        Partial partial;
        if (path == null) {
            path = "";
        }
        if ((partial = this.partialMap.get(path)) == null) {
            throw new IllegalArgumentException("Illegal embedded path \"" + path + "\"");
        }
        return partial;
    }

    public Map<String, Partial> getPartialMap() {
        return Collections.unmodifiableMap(this.partialMap);
    }

    @Override
    public boolean isForeignKey() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmbeddedColumns that = (EmbeddedColumns)o;
        return this.partialMap.equals(that.partialMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.partialMap);
    }

    @Override
    public String toString() {
        return "EmbeddedColumns{partialMap=" + this.partialMap + ", arr=" + Arrays.toString(this.arr) + ", embedded=" + this.embedded + '}';
    }

    public static class PathData {
        public final boolean isTerminal;
        public final List<String> columnNames = new ArrayList<String>();

        public PathData(boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public String toString() {
            return (this.isTerminal ? "column" : "embedded") + this.columnNames;
        }
    }

    public static class Partial
    extends MultipleColumns {
        private final String path;

        Partial(String path, List<String> columns, boolean isTerminal) {
            super(columns.toArray(EMPTY_ARR), !isTerminal);
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        @Override
        public boolean isForeignKey() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Partial partial = (Partial)o;
            return this.path.equals(partial.path);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.path);
        }

        @Override
        public String toString() {
            return "Partial{path='" + this.path + '\'' + ", arr=" + Arrays.toString(this.arr) + ", embedded=" + this.embedded + '}';
        }
    }
}

