/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.runtime;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.babyfish.jimmer.CircularReferenceException;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.ListDraft;
import org.babyfish.jimmer.sql.collection.AbstractIdViewList;

public class DraftContext {
    private final DraftContext parent;
    private final IdentityHashMap<Object, Draft> objDraftMap = new IdentityHashMap();
    private final IdentityHashMap<List<?>, ListDraft<?>> listDraftMap = new IdentityHashMap();
    private DisposerHolder disposerHolder;

    public DraftContext(DraftContext parent) {
        this.parent = parent;
    }

    public <D> D toDraftObject(Object obj) {
        if (obj == null || obj instanceof Draft) {
            return (D)obj;
        }
        Draft draft = this.objDraftMap.get(obj);
        if (draft == null) {
            if (obj instanceof List) {
                throw new IllegalArgumentException("DraftContext.toDraftObject dose not accept list");
            }
            draft = ((ImmutableSpi)obj).__type().getDraftFactory().apply(this, obj);
            this.objDraftMap.put(obj, draft);
        }
        return (D)draft;
    }

    public <E, D> List<D> toDraftList(List<E> list, Class<E> elementType, boolean isElementImmutable) {
        if (list == null || list instanceof Draft || list instanceof AbstractIdViewList) {
            return list;
        }
        ListDraft<Object> draft = this.listDraftMap.get(list);
        if (draft == null) {
            draft = isElementImmutable ? new ListDraft<E>(this, elementType, list) : new ListDraft<E>(elementType, list);
            this.listDraftMap.put(list, draft);
        }
        return draft;
    }

    public <E> E resolveObject(E obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            throw new IllegalArgumentException("DraftContext.resolveObject dose not accept list");
        }
        Draft draft = obj instanceof Draft ? (Draft)obj : (obj instanceof ImmutableSpi ? this.objDraftMap.get(obj) : null);
        if (draft == null) {
            return obj;
        }
        DraftSpi spi = (DraftSpi)draft;
        if (spi.__isResolved()) {
            return (E)spi.__resolve();
        }
        this.validateOtherDraft(spi.__draftContext(), "Cannot resolve the draft object because it belong to another draft context");
        return (E)spi.__resolve();
    }

    public <E> List<E> resolveList(List<E> list) {
        if (list == null) {
            return null;
        }
        ListDraft<?> draft = list instanceof Draft ? (ListDraft<?>)list : this.listDraftMap.get(list);
        if (draft == null) {
            List<E> newList = null;
            int index = 0;
            for (E e : list) {
                E resolved = this.resolveObject(e);
                if (resolved != e && newList == null) {
                    newList = new ArrayList<E>(list.subList(0, index));
                }
                if (newList != null) {
                    newList.add(resolved);
                }
                ++index;
            }
            return newList != null ? newList : list;
        }
        this.validateOtherDraft(draft.draftContext(), "Cannot resolve the draft list because it belong to another draft context");
        return draft.resolve();
    }

    private void validateOtherDraft(DraftContext ctx, String errorMessage) {
        if (ctx != null && ctx != this) {
            DraftContext parent = this.parent;
            while (parent != null) {
                if (parent == ctx) {
                    throw new CircularReferenceException();
                }
                parent = parent.parent;
            }
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public void addDisposer(Consumer<DraftContext> disposer) {
        if (disposer != null) {
            this.disposerHolder = new DisposerHolder(this.disposerHolder, disposer);
        }
    }

    public void dispose() {
        DisposerHolder holder = this.disposerHolder;
        if (holder != null) {
            holder.dispose(this);
            this.disposerHolder = null;
        }
    }

    private static class DisposerHolder {
        private final DisposerHolder parent;
        private final Consumer<DraftContext> disposer;

        private DisposerHolder(DisposerHolder parent, Consumer<DraftContext> disposer) {
            this.parent = parent;
            this.disposer = disposer;
        }

        public void dispose(DraftContext ctx) {
            this.disposer.accept(ctx);
            if (this.parent != null) {
                this.parent.dispose(ctx);
            }
        }
    }
}

