/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class TypedPropImpl<S, T>
implements TypedProp<S, T> {
    protected final ImmutableProp prop;

    protected TypedPropImpl(ImmutableProp prop) {
        if (prop instanceof TypedProp) {
            throw new IllegalArgumentException("TypedProp can only wrap raw prop");
        }
        this.prop = prop;
    }

    public String toString() {
        return this.prop.toString();
    }

    @Override
    public ImmutableProp unwrap() {
        return this.prop;
    }

    @Override
    public boolean isLoaded(Object immutable) {
        return immutable == null || ((ImmutableSpi)immutable).__isLoaded(this.prop.getId());
    }

    public static class ReferenceList<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.ReferenceList<S, T> {
        public ReferenceList(ImmutableProp prop) {
            super(prop);
            if (!prop.isReferenceList(TargetLevel.OBJECT)) {
                throw new IllegalArgumentException("\"" + prop + "\" is not reference list property");
            }
        }
    }

    public static class Reference<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.Reference<S, T> {
        public Reference(ImmutableProp prop) {
            super(prop);
            if (!prop.isReference(TargetLevel.OBJECT)) {
                throw new IllegalArgumentException("\"" + prop + "\" is not reference property");
            }
        }
    }

    public static class ScalarList<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.ScalarList<S, T> {
        public ScalarList(ImmutableProp prop) {
            super(prop);
            if (!prop.isScalarList()) {
                throw new IllegalArgumentException("\"" + prop + "\" is not scalar list property");
            }
        }
    }

    public static class Scalar<S, T>
    extends TypedPropImpl<S, T>
    implements TypedProp.Scalar<S, T> {
        private final boolean desc;
        private final boolean nullsFirst;
        private final boolean nullsLast;

        public Scalar(ImmutableProp prop) {
            this(prop, false, false, false);
        }

        private Scalar(ImmutableProp prop, boolean desc, boolean nullsFirst, boolean nullsLast) {
            super(prop);
            this.desc = desc;
            this.nullsFirst = nullsFirst;
            this.nullsLast = nullsLast;
            if (!prop.isScalar(TargetLevel.OBJECT)) {
                throw new IllegalArgumentException("\"" + prop + "\" is not scalar property");
            }
        }

        @Override
        public TypedProp.Scalar<S, T> asc() {
            if (!this.desc) {
                return this;
            }
            return new Scalar<S, T>(this.prop, false, this.nullsFirst, this.nullsLast);
        }

        @Override
        public TypedProp.Scalar<S, T> desc() {
            if (this.desc) {
                return this;
            }
            return new Scalar<S, T>(this.prop, true, this.nullsFirst, this.nullsLast);
        }

        @Override
        public TypedProp.Scalar<S, T> nullsFirst() {
            if (this.nullsFirst) {
                return this;
            }
            return new Scalar<S, T>(this.prop, this.desc, true, false);
        }

        @Override
        public TypedProp.Scalar<S, T> nullsLast() {
            if (this.nullsLast) {
                return this;
            }
            return new Scalar<S, T>(this.prop, this.desc, false, true);
        }

        @Override
        public boolean isDesc() {
            return this.desc;
        }

        @Override
        public boolean isNullsFirst() {
            return this.nullsFirst;
        }

        @Override
        public boolean isNullsLast() {
            return this.nullsLast;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            if (this.desc) {
                builder.append(" desc");
            }
            if (this.nullsFirst) {
                builder.append(" nullsFirst");
            }
            if (this.nullsLast) {
                builder.append(" nullLast");
            }
            return builder.toString();
        }
    }
}

