/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.jackson.ConverterMetadata;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;

class ImmutableAnnotationIntrospector
extends AnnotationIntrospector {
    ImmutableAnnotationIntrospector() {
    }

    public Version version() {
        return new Version(0, 8, 141, null);
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        Class<?> draftClass;
        ImmutableType type = ImmutableType.tryGet(ac.getAnnotated());
        if (type == null) {
            return super.findPOJOBuilder(ac);
        }
        try {
            draftClass = Class.forName(type.getJavaClass().getName() + "Draft", true, type.getJavaClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Cannot not load the draft type \"" + type.getJavaClass().getName() + "Draft\"");
        }
        Class<?> builderClass = null;
        for (Class<?> nestedClass : draftClass.getDeclaredClasses()) {
            if (!nestedClass.getSimpleName().equals("Builder")) continue;
            builderClass = nestedClass;
            break;
        }
        if (builderClass == null) {
            throw new AssertionError((Object)("There is no nested type \"Builder\" in \"" + draftClass.getName() + "\""));
        }
        return builderClass;
    }

    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        Class<?> declaringType = ac.getAnnotated().getDeclaringClass();
        if (declaringType != null && Draft.class.isAssignableFrom(declaringType)) {
            return new JsonPOJOBuilder.Value("build", "");
        }
        return super.findPOJOBuilderConfig(ac);
    }

    public Object findSerializationConverter(Annotated a) {
        Method method;
        ImmutableType type;
        AnnotatedElement element = a.getAnnotated();
        if (element instanceof Method && (type = ImmutableType.tryGet((method = (Method)element).getDeclaringClass())) != null) {
            ImmutableProp prop;
            ConverterMetadata metadata;
            String propName = StringUtil.propName(method.getName(), method.getReturnType() == Boolean.TYPE);
            if (propName == null) {
                propName = method.getName();
            }
            if ((metadata = (prop = type.getProp(propName)).getConverterMetadata()) != null) {
                return ImmutableAnnotationIntrospector.toOutput(metadata);
            }
        }
        return super.findSerializationConverter(a);
    }

    public Object findDeserializationConverter(Annotated a) {
        Class<?> parentClass;
        Method method;
        AnnotatedElement element = a.getAnnotated();
        if (element instanceof Method && (method = (Method)element).getDeclaringClass().getSimpleName().equals("Builder") && (parentClass = method.getDeclaringClass().getDeclaringClass()) != null && Draft.class.isAssignableFrom(parentClass)) {
            ImmutableProp prop;
            ConverterMetadata metadata;
            ImmutableType type = ImmutableType.get(parentClass);
            String propName = StringUtil.propName(method.getName(), method.getReturnType() == Boolean.TYPE);
            if (propName == null) {
                propName = method.getName();
            }
            if ((metadata = (prop = type.getProp(propName)).getConverterMetadata()) != null) {
                return ImmutableAnnotationIntrospector.toInput(metadata);
            }
        }
        return super.findDeserializationConverter(a);
    }

    private static Converter<?, ?> toOutput(final ConverterMetadata metadata) {
        return new Converter<Object, Object>(){

            public Object convert(Object value) {
                return metadata.getConverter().output(value);
            }

            public JavaType getInputType(TypeFactory typeFactory) {
                return metadata.getSourceJacksonType();
            }

            public JavaType getOutputType(TypeFactory typeFactory) {
                return metadata.getTargetJacksonType();
            }
        };
    }

    private static Converter<?, ?> toInput(final ConverterMetadata metadata) {
        return new Converter<Object, Object>(){

            public Object convert(Object value) {
                return metadata.getConverter().input(value);
            }

            public JavaType getInputType(TypeFactory typeFactory) {
                return metadata.getTargetJacksonType();
            }

            public JavaType getOutputType(TypeFactory typeFactory) {
                return metadata.getSourceJacksonType();
            }
        };
    }
}

