/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.jackson.ImmutablePropertyWriter;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;

class ImmutableSerializerModifier
extends BeanSerializerModifier {
    ImmutableSerializerModifier() {
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        ImmutableType type = ImmutableType.tryGet(beanDesc.getBeanClass());
        if (type == null) {
            return beanProperties;
        }
        ListIterator<BeanPropertyWriter> itr = beanProperties.listIterator();
        while (itr.hasNext()) {
            BeanPropertyWriter writer = itr.next();
            Method method = (Method)writer.getMember().getMember();
            if (method.getName().equals("getDummyPropForJacksonError__")) {
                itr.remove();
                continue;
            }
            String propName = StringUtil.propName(method.getName(), method.getReturnType() == Boolean.TYPE);
            ImmutableProp prop = type.getProp(propName);
            itr.set(new ImmutablePropertyWriter(writer, prop.getId()));
        }
        return beanProperties;
    }
}

