/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.ClassCache;
import org.babyfish.jimmer.jackson.Converter;
import org.babyfish.jimmer.jackson.JacksonUtils;

public class ConverterMetadata {
    private static final ClassCache<ConverterMetadata> CACHE = new ClassCache<ConverterMetadata>((Function<Class<?>, ConverterMetadata>)((Function<Class, ConverterMetadata>)ConverterMetadata::create), false);
    final Type sourceType;
    final Type targetType;
    final JavaType sourceJacksonType;
    final JavaType targetJacksonType;
    final Converter<?, ?> converter;
    private ListMetadata listMetadata;

    ConverterMetadata(Type sourceType, Type targetType, JavaType sourceJacksonType, JavaType targetJacksonType, Converter<?, ?> converter) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.sourceJacksonType = sourceJacksonType;
        this.targetJacksonType = targetJacksonType;
        this.converter = converter;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public JavaType getSourceJacksonType() {
        return this.sourceJacksonType;
    }

    public JavaType getTargetJacksonType() {
        return this.targetJacksonType;
    }

    public <S, T> Converter<S, T> getConverter() {
        return this.converter;
    }

    public static ConverterMetadata of(Class<? extends Converter<?, ?>> converterClass) {
        return (ConverterMetadata)CACHE.get(converterClass);
    }

    public ConverterMetadata toListMetadata() {
        ListMetadata listMetadata = this.listMetadata;
        if (listMetadata == null) {
            this.listMetadata = listMetadata = new ListMetadata();
        }
        return listMetadata;
    }

    private static ConverterMetadata create(Class<?> converterClass) {
        Converter converter;
        Constructor<?> constructor;
        if (converterClass.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("Illegal converter class \"" + converterClass.getName() + "\", it should not have type parameters");
        }
        Map typeMap = TypeUtils.getTypeArguments(converterClass, Converter.class);
        Type sourceType = (Type)typeMap.get(Converter.class.getTypeParameters()[0]);
        Type targetType = (Type)typeMap.get(Converter.class.getTypeParameters()[1]);
        if (sourceType == null || targetType == null) {
            throw new IllegalArgumentException("Illegal converter class \"" + converterClass.getName() + "\", it does not specify type arguments for \"" + Converter.class.getName() + "\"");
        }
        JavaType sourceJacksonType = JacksonUtils.getJacksonType(sourceType);
        JavaType targetJacksonType = JacksonUtils.getJacksonType(targetType);
        try {
            constructor = converterClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Illegal converter class \"" + converterClass.getName() + "\", it does not support default constructor");
        }
        try {
            converter = (Converter)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException("Illegal converter class \"" + converterClass.getName() + "\", cannot create instance for it", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Illegal converter class \"" + converterClass.getName() + "\", cannot create instance for it", ex.getTargetException());
        }
        return new ConverterMetadata(sourceType, targetType, sourceJacksonType, targetJacksonType, converter);
    }

    private class ListMetadata
    extends ConverterMetadata {
        public ListMetadata() {
            super(TypeUtils.parameterize(List.class, (Type[])new Type[]{ConverterMetadata.this.sourceType}), TypeUtils.parameterize(List.class, (Type[])new Type[]{ConverterMetadata.this.targetType}), (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)ConverterMetadata.this.sourceJacksonType), (JavaType)CollectionType.construct(List.class, null, null, null, (JavaType)ConverterMetadata.this.targetJacksonType), new ListConverter(ConverterMetadata.this.converter));
        }

        @Override
        public ConverterMetadata toListMetadata() {
            throw new IllegalStateException("The current metadata is already list metadata");
        }
    }

    private static class ListConverter
    implements Converter<List<?>, List<?>> {
        private final Converter<Object, Object> converter;

        private ListConverter(Converter<?, ?> converter) {
            this.converter = converter;
        }

        @Override
        public List<?> output(List<?> value) {
            ArrayList<Object> convertedList = new ArrayList<Object>(value.size());
            for (Object e : value) {
                convertedList.add(this.converter.output(e));
            }
            return convertedList;
        }

        @Override
        public List<?> input(List<?> jsonValue) {
            ArrayList<Object> convertedList = new ArrayList<Object>(jsonValue.size());
            for (Object e : jsonValue) {
                convertedList.add(this.converter.input(e));
            }
            return convertedList;
        }
    }
}

