/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kotlin.jvm.internal.ClassBasedDeclarationContainer;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.AbstractImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.ImmutablePropImpl;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Table;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.impl.IdGenerators;
import org.babyfish.jimmer.sql.meta.impl.LogicalDeletedValueGenerators;
import org.babyfish.jimmer.sql.meta.impl.MetaCache;
import org.babyfish.jimmer.sql.meta.impl.SqlContextCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableTypeImpl
extends AbstractImmutableTypeImpl {
    private static final Class<? extends Annotation>[] SQL_ANNOTATION_TYPES = new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class};
    private static final IdGenerator NIL_ID_GENERATOR = new IdGenerator(){};
    private static final LogicalDeletedValueGenerator<?> NIL_LOGICAL_DELETED_VALUE_GENERATOR = new LogicalDeletedValueGenerator<Object>(){

        @Override
        public Object generate() {
            throw new UnsupportedOperationException();
        }
    };
    private final Class<?> javaClass;
    private final boolean isEntity;
    private final boolean isMappedSupperClass;
    private final boolean isEmbeddable;
    private final Annotation immutableAnnotation;
    private KClass<?> kotlinClass;
    private final ImmutableType primarySuperType;
    private final Set<ImmutableType> superTypes;
    private Set<ImmutableType> allTypes;
    private final BiFunction<DraftContext, Object, Draft> draftFactory;
    private Map<String, ImmutableProp> declaredProps;
    private Map<String, ImmutableProp> props;
    private ImmutableProp[] propArr;
    private Map<String, List<ImmutableProp>> embeddedPaths;
    private Map<String, ImmutableProp> entityProps;
    private Map<String, ImmutableProp> selectableProps;
    private Map<String, ImmutableProp> selectableScalarProps;
    private Map<String, ImmutableProp> selectableReferenceProps;
    private Map<String, ImmutableProp> objectCacheProps;
    private Map<String, ImmutableProp> referenceProps;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private LogicalDeletedInfo declaredLogicalDeletedInfo;
    private LogicalDeletedInfo logicalDeletedInfo;
    private Set<ImmutableProp> keyProps = Collections.emptySet();
    private final String microServiceName;
    private final MetaCache<String> tableNameCache = new MetaCache<String>(this::getTableName0);
    private final SqlContextCache<IdGenerator> idGeneratorCache = new SqlContextCache<IdGenerator>(it -> {
        IdGenerator g = IdGenerators.of(this, it);
        return g != null ? g : NIL_ID_GENERATOR;
    });
    private final SqlContextCache<LogicalDeletedValueGenerator<?>> logicalDeletedValueGeneratorCache = new SqlContextCache<LogicalDeletedValueGenerator>(it -> {
        LogicalDeletedValueGenerator<?> g = LogicalDeletedValueGenerators.of(this.getLogicalDeletedInfo(), it);
        return g != null ? g : NIL_LOGICAL_DELETED_VALUE_GENERATOR;
    });

    ImmutableTypeImpl(Class<?> javaClass, Set<ImmutableType> superTypes, BiFunction<DraftContext, Object, Draft> draftFactory) {
        Annotation sqlAnnotation = null;
        for (Class<? extends Annotation> sqlAnnotationType : SQL_ANNOTATION_TYPES) {
            Annotation anno = javaClass.getAnnotation(sqlAnnotationType);
            if (anno == null) continue;
            if (sqlAnnotation != null) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", it cannot be decorated by both @" + sqlAnnotation.annotationType().getName() + " and @" + anno.annotationType().getName());
            }
            sqlAnnotation = anno;
        }
        if (sqlAnnotation != null) {
            this.immutableAnnotation = sqlAnnotation;
        } else {
            this.immutableAnnotation = javaClass.getAnnotation(Immutable.class);
            if (this.immutableAnnotation == null) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", it is not immutable type");
            }
        }
        this.javaClass = javaClass;
        this.primarySuperType = superTypes.stream().filter(it -> !it.isMappedSuperclass()).findFirst().orElse(null);
        this.superTypes = Collections.unmodifiableSet(superTypes);
        this.draftFactory = draftFactory;
        this.isEntity = this.immutableAnnotation instanceof Entity;
        this.isMappedSupperClass = this.immutableAnnotation instanceof MappedSuperclass;
        this.isEmbeddable = this.immutableAnnotation instanceof Embeddable;
        this.microServiceName = this.isEntity ? javaClass.getAnnotation(Entity.class).microServiceName() : (this.isMappedSupperClass ? javaClass.getAnnotation(MappedSuperclass.class).microServiceName() : "");
    }

    ImmutableTypeImpl(KClass<?> kotlinClass, Set<ImmutableType> superTypes, BiFunction<DraftContext, Object, Draft> draftFactory) {
        this(((ClassBasedDeclarationContainer)kotlinClass).getJClass(), superTypes, draftFactory);
        this.kotlinClass = kotlinClass;
    }

    @Override
    @NotNull
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isKotlinClass() {
        return this.kotlinClass != null;
    }

    @Override
    public boolean isEntity() {
        return this.isEntity;
    }

    @Override
    public boolean isMappedSuperclass() {
        return this.isMappedSupperClass;
    }

    @Override
    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    @Override
    @NotNull
    public Annotation getImmutableAnnotation() {
        return this.immutableAnnotation;
    }

    @Nullable
    KClass<?> getKotlinClass() {
        return this.kotlinClass;
    }

    @Override
    public boolean isAssignableFrom(ImmutableType type) {
        return this.javaClass.isAssignableFrom(type.getJavaClass());
    }

    @Override
    @Nullable
    public ImmutableType getPrimarySuperType() {
        return this.primarySuperType;
    }

    @Override
    public Set<ImmutableType> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public Set<ImmutableType> getAllTypes() {
        Set<ImmutableType> all = this.allTypes;
        if (all == null) {
            all = new LinkedHashSet<ImmutableType>();
            this.collectAllSuperTypes(all);
            this.allTypes = all = Collections.unmodifiableSet(all);
        }
        return all;
    }

    private void collectAllSuperTypes(Set<ImmutableType> allSuperTypes) {
        allSuperTypes.add(this);
        for (ImmutableType superType : this.superTypes) {
            ((ImmutableTypeImpl)superType).collectAllSuperTypes(allSuperTypes);
        }
    }

    @Override
    @NotNull
    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        return this.draftFactory;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    @Override
    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    @Override
    @Nullable
    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    @Override
    @Nullable
    public LogicalDeletedInfo getDeclaredLogicalDeletedInfo() {
        return this.declaredLogicalDeletedInfo;
    }

    @Override
    @Nullable
    public LogicalDeletedInfo getLogicalDeletedInfo() {
        return this.logicalDeletedInfo;
    }

    @Override
    @NotNull
    public Set<ImmutableProp> getKeyProps() {
        return this.keyProps;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getProps() {
        return this.props;
    }

    private Map<String, ImmutableProp> createPropMap(Map<String, PropId> redirectedMap) {
        LinkedHashMap<String, ImmutableProp> propMap = new LinkedHashMap<String, ImmutableProp>();
        for (ImmutableType superType : this.superTypes) {
            for (ImmutableProp prop : superType.getProps().values()) {
                if (propMap.containsKey(prop.getName())) continue;
                propMap.putIfAbsent(prop.getName(), new ImmutablePropImpl((ImmutablePropImpl)prop, this, redirectedMap.get(prop.getName())));
            }
        }
        for (ImmutableProp declaredProp : this.declaredProps.values()) {
            ImmutableProp conflictProp = propMap.put(declaredProp.getName(), declaredProp);
            if (conflictProp == null || conflictProp == ((ImmutablePropImpl)declaredProp).getOriginal()) continue;
            throw new ModelException("The property \"" + declaredProp + "\" overrides property of super type, this is not allowed");
        }
        return propMap;
    }

    @Override
    @NotNull
    public ImmutableProp getProp(String name) {
        ImmutableProp prop = this.getProps().get(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property \"" + name + "\" in \"" + this + "\"");
        }
        return prop;
    }

    @Override
    @NotNull
    public ImmutableProp getProp(PropId id) {
        int index = id.asIndex();
        if (index == -1) {
            return this.getProp(id.asName());
        }
        ImmutableProp[] arr = this.getPropArr();
        if (index < 0 || index >= arr.length) {
            throw new IllegalArgumentException("There is no property whose id is " + id + " in \"" + this + "\"");
        }
        return arr[index];
    }

    @NotNull
    private ImmutableProp[] getPropArr() {
        ImmutableProp[] arr = this.propArr;
        if (arr == null) {
            if (this.isMappedSupperClass) {
                arr = this.getProps().values().toArray(new ImmutableProp[0]);
            } else {
                arr = new ImmutableProp[this.getProps().size() + 1];
                Iterator<ImmutableProp> iterator = this.getProps().values().iterator();
                while (iterator.hasNext()) {
                    ImmutableProp prop;
                    arr[prop.getId().asIndex()] = prop = iterator.next();
                }
            }
            this.propArr = arr;
        }
        return arr;
    }

    @Override
    public Map<String, List<ImmutableProp>> getEmbeddedPaths() {
        Map<String, List<ImmutableProp>> paths = this.embeddedPaths;
        if (paths == null) {
            paths = new LinkedHashMap<String, List<ImmutableProp>>();
            this.collectEmbeddedPaths(new ArrayList<ImmutableProp>(), paths);
            this.embeddedPaths = paths;
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectEmbeddedPaths(ArrayList<ImmutableProp> stack, Map<String, List<ImmutableProp>> pathMap) {
        if (!this.isEmbeddable) {
            return;
        }
        for (ImmutableProp prop : this.getProps().values()) {
            if (prop.isFormula()) continue;
            stack.add(prop);
            try {
                ImmutableType targetType = prop.getTargetType();
                if (targetType != null) {
                    ((ImmutableTypeImpl)targetType).collectEmbeddedPaths(stack, pathMap);
                    continue;
                }
                pathMap.put(stack.stream().map(ImmutableProp::getName).collect(Collectors.joining(".")), Collections.unmodifiableList(new ArrayList<ImmutableProp>(stack)));
            }
            finally {
                stack.remove(stack.size() - 1);
            }
        }
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getEntityProps() {
        Map<String, ImmutableProp> map = this.entityProps;
        if (map == null) {
            map = this.isEntity ? (this.primarySuperType != null && this.primarySuperType.isEntity() ? this.declaredProps : this.props) : Collections.emptyMap();
            this.entityProps = map;
        }
        return map;
    }

    @Override
    public Map<String, ImmutableProp> getSelectableProps() {
        Map<String, ImmutableProp> map = this.selectableProps;
        if (map == null) {
            map = new LinkedHashMap<String, ImmutableProp>();
            map.put(this.idProp.getName(), this.idProp);
            for (ImmutableProp prop : this.getProps().values()) {
                if (prop.isId() || !prop.isColumnDefinition()) continue;
                map.put(prop.getName(), prop);
            }
            this.selectableProps = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    @Override
    public Map<String, ImmutableProp> getSelectableScalarProps() {
        Map<String, ImmutableProp> map = this.selectableScalarProps;
        if (map == null) {
            map = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableProp prop : this.getSelectableProps().values()) {
                if (prop.isAssociation(TargetLevel.ENTITY) || prop.isLogicalDeleted()) continue;
                map.put(prop.getName(), prop);
            }
            this.selectableScalarProps = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    @Override
    public Map<String, ImmutableProp> getSelectableReferenceProps() {
        Map<String, ImmutableProp> map = this.selectableReferenceProps;
        if (map == null) {
            map = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableProp prop : this.getProps().values()) {
                if (!prop.isReference(TargetLevel.PERSISTENT) || !prop.isColumnDefinition()) continue;
                map.put(prop.getName(), prop);
            }
            this.selectableReferenceProps = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    @Override
    public Map<String, ImmutableProp> getReferenceProps() {
        Map<String, ImmutableProp> map = this.referenceProps;
        if (map == null) {
            map = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableProp prop : this.getProps().values()) {
                if (!prop.isReference(TargetLevel.PERSISTENT)) continue;
                map.put(prop.getName(), prop);
            }
            this.referenceProps = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    @Override
    public Map<String, ImmutableProp> getObjectCacheProps() {
        Map<String, ImmutableProp> map = this.objectCacheProps;
        if (map == null) {
            for (ImmutableProp prop : this.getProps().values()) {
                if (!prop.isFormula() || prop.getSqlTemplate() == null) continue;
                if (map == null) {
                    map = new LinkedHashMap<String, ImmutableProp>(this.getSelectableProps());
                }
                map.put(prop.getName(), prop);
            }
            map = map == null ? this.getSelectableProps() : Collections.unmodifiableMap(map);
            this.objectCacheProps = map;
        }
        return map;
    }

    void setProps(Map<String, ImmutableProp> declaredPropMap, Map<String, PropId> redefinedMap) {
        this.declaredProps = Collections.unmodifiableMap(declaredPropMap);
        this.props = Collections.unmodifiableMap(this.createPropMap(redefinedMap));
    }

    void setIdProp(ImmutableProp idProp) {
        if (idProp.getDeclaringType() != this) {
            idProp = this.getProp(idProp.getName());
        }
        if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
            this.validateEmbeddedIdType(idProp.getTargetType(), null);
        }
        this.idProp = idProp;
    }

    void setVersionProp(ImmutableProp versionProp) {
        if (versionProp != null && versionProp.getDeclaringType() != this) {
            versionProp = this.getProp(versionProp.getName());
        }
        this.versionProp = versionProp;
    }

    void setDeclaredLogicalDeletedInfo(LogicalDeletedInfo declaredLogicalDeletedInfo) {
        ImmutableType superType;
        LogicalDeletedInfo superInfo = null;
        Iterator<ImmutableType> iterator = this.superTypes.iterator();
        while (iterator.hasNext() && (superInfo = (superType = iterator.next()).getLogicalDeletedInfo()) == null) {
        }
        if (superInfo != null && declaredLogicalDeletedInfo != null) {
            throw new AssertionError((Object)("Internal bug, @LogicalDeleted field is configured in both \"" + this + "\" and its super type"));
        }
        this.declaredLogicalDeletedInfo = declaredLogicalDeletedInfo;
        this.logicalDeletedInfo = superInfo != null ? superInfo.to(this.getProp(superInfo.getProp().getName())) : declaredLogicalDeletedInfo;
    }

    void setKeyProps(Set<ImmutableProp> keyProps) {
        LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
        for (ImmutableProp keyProp : keyProps) {
            if (keyProp.getDeclaringType() != this) {
                keyProp = this.getProp(keyProp.getName());
            }
            set.add(keyProp);
        }
        this.keyProps = Collections.unmodifiableSet(set);
    }

    @Override
    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @Override
    public String getTableName(MetadataStrategy strategy) {
        return this.tableNameCache.get(strategy);
    }

    private String getTableName0(MetadataStrategy strategy) {
        String tableName;
        Table table = this.javaClass.getAnnotation(Table.class);
        String string = tableName = table != null ? table.name() : "";
        if (tableName.isEmpty()) {
            return strategy.getNamingStrategy().tableName(this);
        }
        return tableName;
    }

    @Override
    public IdGenerator getIdGenerator(SqlContext sqlContext) {
        IdGenerator generator = this.idGeneratorCache.get(sqlContext);
        return generator == NIL_ID_GENERATOR ? null : generator;
    }

    @Override
    public LogicalDeletedValueGenerator<?> getLogicalDeletedValueGenerator(SqlContext sqlContext) {
        LogicalDeletedValueGenerator<?> generator = this.logicalDeletedValueGeneratorCache.get(sqlContext);
        return generator == NIL_LOGICAL_DELETED_VALUE_GENERATOR ? null : generator;
    }

    public String toString() {
        return this.javaClass.getName();
    }

    private void validateEntity() {
        if (!this.isEntity) {
            throw new IllegalStateException("The current type \"" + this + "\" is not entity");
        }
    }

    private void validateEmbeddedIdType(ImmutableType type, String path) {
        String prefix = path != null ? path + '.' : "";
        for (ImmutableProp prop : type.getProps().values()) {
            if (prop.isNullable()) {
                throw new ModelException("Illegal id property \"" + this + "\", the embedded property \"" + prefix + prop.getName() + "\" cannot be nullable");
            }
            if (!prop.isEmbedded(EmbeddedLevel.SCALAR)) continue;
            this.validateEmbeddedIdType(prop.getTargetType(), prefix + prop.getName());
        }
    }

    private static class PropBuilder {
        final PropId id;
        final String name;
        final ImmutablePropCategory category;
        final Class<?> elementType;
        final boolean nullable;
        final Class<? extends Annotation> associationType;

        PropBuilder(PropId id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            this.id = id;
            this.name = name;
            this.category = category;
            this.elementType = elementType;
            this.nullable = nullable;
            this.associationType = associationType;
        }

        public ImmutableProp build(ImmutableTypeImpl declaringType) {
            return new ImmutablePropImpl(declaringType, this.id, this.name, this.category, this.elementType, this.nullable, this.associationType);
        }
    }

    public static class BuilderImpl
    implements ImmutableType.Builder {
        private final KClass<?> kotlinType;
        private final Class<?> javaClass;
        private final Set<ImmutableType> superTypes;
        private final BiFunction<DraftContext, Object, Draft> draftFactory;
        private String idPropName;
        private String versionPropName;
        private String logicalDeletedPropName;
        private final List<String> keyPropNames = new ArrayList<String>();
        private final Map<String, PropBuilder> propBuilderMap = new LinkedHashMap<String, PropBuilder>();
        private final Set<PropId> propIds = new LinkedHashSet<PropId>();
        private final Map<String, PropId> redefinedMap = new HashMap<String, PropId>();

        BuilderImpl(Class<?> javaClass, Collection<ImmutableType> superTypes, BiFunction<DraftContext, Object, Draft> draftFactory) {
            if (View.class.isAssignableFrom(javaClass)) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", immutable type can not inherit \"" + View.class.getName() + "\"");
            }
            this.kotlinType = null;
            this.javaClass = javaClass;
            this.superTypes = this.standardSuperTypes(superTypes);
            this.draftFactory = draftFactory;
            for (ImmutableType superType : superTypes) {
                for (ImmutableProp prop : superType.getProps().values()) {
                    PropId id = prop.getId();
                    if (id.asIndex() == -1) continue;
                    this.propIds.add(id);
                }
            }
        }

        BuilderImpl(KClass<?> kotlinType, Collection<ImmutableType> superTypes, BiFunction<DraftContext, Object, Draft> draftFactory) {
            Class javaClass = ((ClassBasedDeclarationContainer)kotlinType).getJClass();
            if (View.class.isAssignableFrom(javaClass)) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", immutable type can not inherit \"" + View.class.getName() + "\"");
            }
            this.kotlinType = kotlinType;
            this.javaClass = javaClass;
            this.superTypes = this.standardSuperTypes(superTypes);
            this.draftFactory = draftFactory;
            for (ImmutableType superType : superTypes) {
                for (ImmutableProp prop : superType.getProps().values()) {
                    PropId id = prop.getId();
                    if (id.asIndex() == -1) continue;
                    this.propIds.add(id);
                }
            }
        }

        private Set<ImmutableType> standardSuperTypes(Collection<ImmutableType> superTypes) {
            if (superTypes.isEmpty()) {
                return Collections.emptySet();
            }
            if (this.javaClass.isAnnotationPresent(Embeddable.class)) {
                throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", embeddable type does not support inheritance");
            }
            LinkedHashSet<ImmutableType> set = new LinkedHashSet<ImmutableType>(superTypes);
            if (this.javaClass.isAnnotationPresent(Immutable.class)) {
                if (set.size() > 1) {
                    throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", simple immutable type does not support multiple inheritance");
                }
                if (!((ImmutableType)set.iterator().next()).getJavaClass().isAnnotationPresent(Immutable.class)) {
                    throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", simple immutable type can only inherit simple immutable type");
                }
            } else {
                for (ImmutableType superType : set) {
                    if (superType.isEntity()) {
                        if (this.javaClass.isAnnotationPresent(Entity.class)) {
                            throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", inheriting from entity type is not supported now, it will be supported in the future");
                        }
                        throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", mapped super class cannot inherit entity type");
                    }
                    if (superType.isMappedSuperclass()) continue;
                    throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", the super type \"" + superType + "\"" + (this.javaClass.isAnnotationPresent(Entity.class) ? " is neither entity nor mapped super class" : " is not mapped super class"));
                }
            }
            if (set.size() > 1) {
                HashMap<String, ImmutableProp> superPropMap = new HashMap<String, ImmutableProp>();
                for (ImmutableType superType : superTypes) {
                    for (ImmutableProp prop : superType.getProps().values()) {
                        ImmutableProp oldProp = superPropMap.put(prop.getName(), prop);
                        if (oldProp == null) continue;
                        if (oldProp.getCategory() != prop.getCategory()) {
                            throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", conflict super properties: \"" + oldProp + "\" and \"" + prop + "\", this first one is " + (Object)((Object)oldProp.getCategory()) + " and the second is " + (Object)((Object)prop.getCategory()));
                        }
                        if (!oldProp.getGenericType().equals(prop.getGenericType())) {
                            throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", conflict super properties: \"" + oldProp + "\" and \"" + prop + "\", their types are different");
                        }
                        if (oldProp.isNullable() != prop.isNullable()) {
                            throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", conflict super properties: \"" + oldProp + "\" and \"" + prop + "\", their nullity are different");
                        }
                        if (oldProp.isInputNotNull() != prop.isInputNotNull()) {
                            throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", conflict super properties: \"" + oldProp + "\" and \"" + prop + "\", their input nullity are different");
                        }
                        if (!((ImmutablePropImpl)oldProp).getMappedByValue().equals(((ImmutablePropImpl)prop).getMappedByValue())) {
                            throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", conflict super properties: \"" + oldProp + "\" and \"" + prop + "\", their configuration `mappedBy` are different");
                        }
                        if (oldProp.getPrimaryAnnotationType() == prop.getPrimaryAnnotationType()) continue;
                        throw new ModelException("Illegal type \"" + this.javaClass.getName() + "\", conflict super properties: \"" + oldProp + "\" and \"" + prop + "\", the first one is decorated by \"@" + oldProp.getPrimaryAnnotationType().getName() + "\" but the second one is decorated by \"@" + prop.getPrimaryAnnotationType().getName() + "\"");
                    }
                }
            }
            return Collections.unmodifiableSet(set);
        }

        @Override
        public ImmutableType.Builder redefine(String name, int id) {
            ImmutableType superType;
            ImmutableProp superProp = null;
            Iterator<ImmutableType> iterator = this.superTypes.iterator();
            while (iterator.hasNext() && (superProp = (superType = iterator.next()).getProps().get(name)) == null) {
            }
            if (superProp == null) {
                throw new IllegalArgumentException("Cannot redefine \"" + name + "\" because there is no such property in super types");
            }
            if (superProp.getId().asIndex() != -1) {
                throw new IllegalArgumentException("Cannot redefine the property \"" + name + "\" because it is already based on integer id");
            }
            this.redefinedMap.put(name, PropId.byIndex(id));
            return this;
        }

        @Override
        public ImmutableType.Builder id(int id, String name, Class<?> elementType) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set id property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            for (ImmutableType superType : this.superTypes) {
                if (superType.getIdProp() == null) continue;
                throw new IllegalStateException("Cannot set id property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + superType.getJavaClass().getName() + "\"");
            }
            if (this.idPropName != null) {
                throw new IllegalStateException("Conflict id properties \"" + this.idPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.idPropName = name;
            return this.add(id, name, BuilderImpl.category(elementType), elementType, false);
        }

        @Override
        public ImmutableType.Builder key(int id, String name, Class<?> elementType, boolean nullable) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set key property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            this.keyPropNames.add(name);
            return this.add(id, name, BuilderImpl.category(elementType), elementType, nullable);
        }

        @Override
        public ImmutableType.Builder keyReference(int id, String name, Class<? extends Annotation> associationAnnotationType, Class<?> elementType, boolean nullable) {
            if (associationAnnotationType != OneToOne.class && associationAnnotationType != ManyToOne.class) {
                throw new IllegalArgumentException("The `associationAnnotationType` must be `OneOne` or `ManyToOne`");
            }
            this.keyPropNames.add(name);
            return this.add(id, name, ImmutablePropCategory.REFERENCE, elementType, nullable, associationAnnotationType);
        }

        @Override
        public ImmutableType.Builder version(int id, String name) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set version property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            for (ImmutableType superType : this.superTypes) {
                if (superType.getVersionProp() == null) continue;
                throw new IllegalStateException("Cannot set version property for type \"" + this.javaClass.getName() + "\" because there is an version property in the super type \"" + superType.getJavaClass().getName() + "\"");
            }
            if (this.versionPropName != null) {
                throw new IllegalStateException("Conflict version properties \"" + this.versionPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.versionPropName = name;
            return this.add(id, name, ImmutablePropCategory.SCALAR, Integer.TYPE, false);
        }

        @Override
        public ImmutableType.Builder logicalDeleted(int id, String name, Class<?> elementType, boolean nullable) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set logical deleted property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            for (ImmutableType superType : this.superTypes) {
                if (superType.getLogicalDeletedInfo() == null) continue;
                throw new IllegalStateException("Cannot set logical deleted property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + superType.getJavaClass().getName() + "\"");
            }
            if (this.logicalDeletedPropName != null) {
                throw new IllegalStateException("Conflict logical deleted properties \"" + this.logicalDeletedPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.logicalDeletedPropName = name;
            return this.add(id, name, ImmutablePropCategory.SCALAR, elementType, nullable);
        }

        @Override
        public ImmutableType.Builder add(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable) {
            return this.add(id, name, category, elementType, nullable, null);
        }

        @Override
        public ImmutableType.Builder add(int id, String name, Class<? extends Annotation> associationType, Class<?> elementType, boolean nullable) {
            ImmutablePropCategory category;
            if (associationType == OneToOne.class || associationType == ManyToOne.class) {
                category = ImmutablePropCategory.REFERENCE;
            } else if (associationType == OneToMany.class || associationType == ManyToMany.class || associationType == ManyToManyView.class) {
                category = ImmutablePropCategory.REFERENCE_LIST;
            } else {
                throw new IllegalArgumentException("Invalid association type");
            }
            return this.add(id, name, category, elementType, nullable, associationType);
        }

        private ImmutableType.Builder add(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            PropId propId;
            if (category.isAssociation() && elementType.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set association for type that is not entity or mapped super class");
            }
            if (id == -1) {
                propId = PropId.byName(name);
            } else {
                if (this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                    throw new IllegalArgumentException("The prop-id of properties in mapped super class must be -1");
                }
                propId = PropId.byIndex(id);
                if (!this.propIds.add(propId)) {
                    throw new IllegalArgumentException("The property id \"" + id + "." + name + "\" is already exists in current type or the super type");
                }
            }
            if (this.propBuilderMap.containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.javaClass.getName() + "." + name + "\", it is already exists");
            }
            for (ImmutableType superType : this.superTypes) {
                ImmutableProp superProp = superType.getProps().get(name);
                if (superProp == null || superProp.getId().asIndex() == -1) continue;
                throw new IllegalArgumentException("The property \"" + this.javaClass.getName() + "." + name + "\" is already exists in super type \"" + superType + "\"");
            }
            this.propBuilderMap.put(name, new PropBuilder(propId, name, category, elementType, nullable, associationType));
            return this;
        }

        private static ImmutablePropCategory category(Class<?> elementType) {
            return elementType.isAnnotationPresent(Embeddable.class) ? ImmutablePropCategory.REFERENCE : ImmutablePropCategory.SCALAR;
        }

        @Override
        public ImmutableTypeImpl build() {
            ImmutableTypeImpl type = this.kotlinType != null ? new ImmutableTypeImpl(this.kotlinType, this.superTypes, this.draftFactory) : new ImmutableTypeImpl(this.javaClass, this.superTypes, this.draftFactory);
            LinkedHashMap<String, ImmutableProp> map = new LinkedHashMap<String, ImmutableProp>();
            for (Map.Entry<String, PropBuilder> e : this.propBuilderMap.entrySet()) {
                map.put(e.getKey(), e.getValue().build(type));
            }
            type.setProps(map, this.redefinedMap);
            if (this.idPropName != null) {
                type.setIdProp((ImmutableProp)type.declaredProps.get(this.idPropName));
            } else {
                for (ImmutableType superType : type.superTypes) {
                    ImmutableProp superIdProp = superType.getIdProp();
                    if (superIdProp == null) continue;
                    type.setIdProp(superIdProp);
                    break;
                }
            }
            if (this.versionPropName != null) {
                type.setVersionProp((ImmutableProp)type.declaredProps.get(this.versionPropName));
            } else {
                for (ImmutableType superType : type.superTypes) {
                    ImmutableProp superVersionProp = superType.getVersionProp();
                    if (superVersionProp == null) continue;
                    type.setVersionProp(superVersionProp);
                    break;
                }
            }
            if (this.logicalDeletedPropName != null) {
                type.setDeclaredLogicalDeletedInfo(LogicalDeletedInfo.of((ImmutableProp)type.declaredProps.get(this.logicalDeletedPropName)));
            } else {
                type.setDeclaredLogicalDeletedInfo(null);
            }
            LinkedHashMap<String, ImmutableProp> keyPropMap = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableType superType : this.superTypes) {
                for (ImmutableProp keyProp : superType.getKeyProps()) {
                    keyPropMap.putIfAbsent(keyProp.getName(), keyProp);
                }
            }
            for (String keyPropName : this.keyPropNames) {
                keyPropMap.put(keyPropName, (ImmutableProp)type.declaredProps.get(keyPropName));
            }
            type.setKeyProps(new LinkedHashSet<ImmutableProp>(keyPropMap.values()));
            return type;
        }
    }
}

