/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.babyfish.jimmer.impl.util.LRUMap;

public class StaticCache<K, V> {
    private final Function<K, V> creator;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Map<K, V> positiveMap = new HashMap();
    private final Map<K, Void> negativeMap;

    public StaticCache(Function<K, V> creator) {
        this(creator, true);
    }

    public StaticCache(Function<K, V> creator, boolean nullable) {
        this.creator = creator;
        this.negativeMap = nullable ? new LRUMap() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V value;
        Lock lock = this.cacheLock.readLock();
        lock.lock();
        try {
            if (this.negativeMap != null && this.negativeMap.containsKey(key)) {
                V v = null;
                return v;
            }
            value = this.positiveMap.get(key);
        }
        finally {
            lock.unlock();
        }
        if (value == null) {
            lock = this.cacheLock.writeLock();
            lock.lock();
            try {
                V v = this.getWithoutLock(key);
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        return value;
    }

    protected final V getWithoutLock(K key) {
        if (this.negativeMap != null && this.negativeMap.containsKey(key)) {
            return null;
        }
        V value = this.positiveMap.get(key);
        if (value == null) {
            value = this.creator.apply(key);
            if (value != null) {
                this.positiveMap.put(key, value);
                try {
                    this.onCreated(key, value);
                }
                catch (Error | RuntimeException ex) {
                    this.positiveMap.remove(key);
                    throw ex;
                }
            } else if (this.negativeMap != null) {
                this.negativeMap.put(key, null);
            } else {
                throw new IllegalStateException("The creator cannot return null because current static cache does not accept null values");
            }
        }
        return value;
    }

    protected void onCreated(K key, V value) {
    }
}

