/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.jetbrains.annotations.Nullable;

public class ImmutableObjects {
    private static final ObjectMapper MAPPER;

    private ImmutableObjects() {
    }

    public static boolean isLoaded(Object immutable, PropId prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__isLoaded(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static boolean isLoaded(Object immutable, String prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__isLoaded(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static boolean isLoaded(Object immutable, ImmutableProp prop) {
        return ImmutableObjects.isLoaded(immutable, prop.getId());
    }

    public static boolean isLoaded(Object immutable, TypedProp<?, ?> prop) {
        return ImmutableObjects.isLoaded(immutable, prop.unwrap().getId());
    }

    public static boolean isLoadedChain(Object immutable, PropId ... propIds) {
        ImmutableSpi spi = (ImmutableSpi)immutable;
        int parentCount = propIds.length - 1;
        if (parentCount == -1) {
            return true;
        }
        for (int i = 0; i < parentCount; ++i) {
            if (spi == null) {
                return true;
            }
            PropId propId = propIds[i];
            if (!spi.__isLoaded(propId)) {
                return false;
            }
            Object value = spi.__get(propId);
            if (!(value instanceof ImmutableSpi)) {
                if (spi.__type().getProp(propId).isReferenceList(TargetLevel.ENTITY)) {
                    List list = (List)value;
                    PropId[] itemPropIds = Arrays.copyOfRange(propIds, i + 1, propIds.length);
                    for (Object item : list) {
                        if (ImmutableObjects.isLoadedChain(item, itemPropIds)) continue;
                        return false;
                    }
                    return true;
                }
                throw new IllegalArgumentException("The properties[" + i + "] \"" + spi.__type().getProp(propId) + "\" is neither association nor embedded property");
            }
            spi = (ImmutableSpi)value;
        }
        return spi == null || spi.__isLoaded(propIds[parentCount]);
    }

    public static Object get(Object immutable, PropId prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__get(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static Object get(Object immutable, String prop) {
        if (immutable instanceof ImmutableSpi) {
            return ((ImmutableSpi)immutable).__get(prop);
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static Object get(Object immutable, ImmutableProp prop) {
        return ImmutableObjects.get(immutable, prop.getId());
    }

    public static <T, X> X get(T immutable, TypedProp<T, X> prop) {
        return (X)ImmutableObjects.get(immutable, prop.unwrap().getId());
    }

    public static boolean isIdOnly(Object immutable) {
        if (immutable == null) {
            return false;
        }
        if (immutable instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)immutable;
            ImmutableType type = spi.__type();
            ImmutableProp idProp = type.getIdProp();
            if (idProp == null) {
                throw new IllegalArgumentException("The object type \"" + type + "\" does not have id property");
            }
            for (ImmutableProp prop : type.getProps().values()) {
                if (prop.isId()) {
                    if (spi.__isLoaded(prop.getId())) continue;
                    throw new IllegalArgumentException("The id of " + spi + " is unloaded");
                }
                if (!spi.__isLoaded(prop.getId())) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    @Nullable
    public static <T> T makeIdOnly(Class<T> type, @Nullable Object id) {
        return ImmutableObjects.makeIdOnly(ImmutableType.get(type), id);
    }

    @Nullable
    public static <T> T makeIdOnly(ImmutableType type, @Nullable Object id) {
        ImmutableProp idProp = type.getIdProp();
        if (idProp == null) {
            throw new IllegalArgumentException("No id property in \"" + type + "\"");
        }
        if (id == null) {
            return null;
        }
        return (T)Internal.produce(type, null, draft -> {
            DraftSpi targetDraft = (DraftSpi)draft;
            targetDraft.__set(idProp.getId(), id);
        });
    }

    public static boolean isLonely(Object immutable) {
        if (immutable instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)immutable;
            ImmutableType type = spi.__type();
            for (ImmutableProp prop : type.getProps().values()) {
                if (!prop.isAssociation(TargetLevel.ENTITY) || !spi.__isLoaded(prop.getId())) continue;
                if (prop.isColumnDefinition()) {
                    ImmutableSpi target = (ImmutableSpi)spi.__get(prop.getId());
                    if (target == null || ImmutableObjects.isIdOnly(target)) continue;
                    return false;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("The first argument is immutable object created by jimmer");
    }

    public static <T> T toLonely(T immutable) {
        if (immutable == null) {
            return null;
        }
        ImmutableSpi spi = (ImmutableSpi)immutable;
        ImmutableType type = spi.__type();
        return (T)Internal.produce(type, immutable, draft -> {
            for (ImmutableProp prop : type.getProps().values()) {
                PropId propId = prop.getId();
                if (!prop.isAssociation(TargetLevel.ENTITY) || !spi.__isLoaded(propId)) continue;
                if (prop.isColumnDefinition()) {
                    ImmutableSpi target = (ImmutableSpi)spi.__get(propId);
                    if (target == null) continue;
                    ImmutableType targetType = prop.getTargetType();
                    PropId targetIdPropId = targetType.getIdProp().getId();
                    if (!target.__isLoaded(targetIdPropId)) {
                        ((DraftSpi)draft).__unload(propId);
                        continue;
                    }
                    if (ImmutableObjects.isIdOnly(target)) continue;
                    Object targetId = target.__get(targetIdPropId);
                    ((DraftSpi)draft).__set(propId, ImmutableObjects.makeIdOnly(targetType, targetId));
                    continue;
                }
                ((DraftSpi)draft).__unload(propId);
            }
        });
    }

    public static <T> Collection<T> toIdOnly(Iterable<T> immutables) {
        if (immutables instanceof Set) {
            return ImmutableObjects.toIdOnly((Set)immutables);
        }
        ArrayList<T> idOnlyList = immutables instanceof Collection ? new ArrayList<T>(((Collection)immutables).size()) : new ArrayList();
        for (T immutable : immutables) {
            idOnlyList.add(ImmutableObjects.toIdOnly(immutable));
        }
        return idOnlyList;
    }

    public static <T> Set<T> toIdOnly(Set<T> immutables) {
        LinkedHashSet<T> idOnlySet = new LinkedHashSet<T>((immutables.size() * 4 + 2) / 3);
        for (T immutable : immutables) {
            idOnlySet.add(ImmutableObjects.toIdOnly(immutable));
        }
        return idOnlySet;
    }

    public static <T> List<T> toIdOnly(List<T> immutables) {
        ArrayList<T> idOnlyList = new ArrayList<T>(immutables.size());
        for (T immutable : immutables) {
            idOnlyList.add(ImmutableObjects.toIdOnly(immutable));
        }
        return idOnlyList;
    }

    public static <T> T toIdOnly(T immutable) {
        if (immutable == null) {
            return null;
        }
        ImmutableSpi spi = (ImmutableSpi)immutable;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        if (idProp == null) {
            throw new IllegalArgumentException("Cannot convert \"" + type + "\" to id only object because it is not entity");
        }
        if (!spi.__isLoaded(idProp.getId())) {
            throw new IllegalArgumentException("Cannot convert \"" + type + "\" to id only object because its id property \"" + type.getIdProp() + "\"");
        }
        return ImmutableObjects.makeIdOnly(type, spi.__get(idProp.getId()));
    }

    public static String toString(Object immutable) {
        try {
            return MAPPER.writeValueAsString(immutable);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <I> I fromString(Class<I> type, String json) throws JsonProcessingException {
        return (I)MAPPER.readValue(json, type);
    }

    public static <I> I fromString(Class<I> type, String json, ObjectMapper mapper) throws JsonProcessingException {
        return (I)mapper.readValue(json, type);
    }

    @SafeVarargs
    public static <I> I merge(I ... parts) {
        ArrayList<ImmutableSpi> spis = new ArrayList<ImmutableSpi>(parts.length);
        for (I part : parts) {
            if (part == null) continue;
            if (!(part instanceof ImmutableSpi)) {
                throw new IllegalArgumentException("Each element of `parts` must be immutable object");
            }
            ImmutableSpi spi = (ImmutableSpi)part;
            if (!spis.isEmpty() && ((ImmutableSpi)spis.get(0)).__type() != spi.__type()) {
                throw new IllegalArgumentException("All element of `parts` must belong to same type, but both \"" + ((ImmutableSpi)spis.get(0)).__type() + "\" and \"" + spi.__type() + "\" are found");
            }
            spis.add(spi);
        }
        if (spis.size() == 1) {
            return (I)spis.get(0);
        }
        return (I)Internal.produce(((ImmutableSpi)spis.get(0)).__type(), null, draft -> {
            for (ImmutableSpi spi : spis) {
                ImmutableObjects.merge((DraftSpi)draft, spi);
            }
        });
    }

    private static void merge(DraftSpi target, ImmutableSpi source) {
        for (ImmutableProp prop : source.__type().getProps().values()) {
            PropId propId = prop.getId();
            if (!source.__isLoaded(propId)) continue;
            target.__set(propId, source.__get(propId));
        }
    }

    public static <I> I deepClone(I immutable) {
        if (immutable == null) {
            return null;
        }
        ImmutableType immutableType = ImmutableType.get(immutable.getClass());
        return (I)ImmutableObjects.deepClone(immutableType, immutable);
    }

    private static Object deepClone(ImmutableType type, Object immutable) {
        ImmutableSpi from = (ImmutableSpi)immutable;
        return Internal.produce(type, null, draft -> {
            DraftSpi to = (DraftSpi)draft;
            for (ImmutableProp prop : type.getProps().values()) {
                PropId propId = prop.getId();
                if (prop.isView() || !prop.isMutable() || !from.__isLoaded(propId)) continue;
                ImmutableType targetType = prop.getTargetType();
                if (prop.isReferenceList(TargetLevel.OBJECT)) {
                    List targets = (List)from.__get(propId);
                    ArrayList<Object> clonedTargets = new ArrayList<Object>(targets.size());
                    for (Object target : targets) {
                        clonedTargets.add(ImmutableObjects.deepClone(targetType, target));
                    }
                    to.__set(propId, clonedTargets);
                    continue;
                }
                if (prop.isReference(TargetLevel.OBJECT)) {
                    Object target = from.__get(propId);
                    if (target == null) continue;
                    to.__set(propId, ImmutableObjects.deepClone(targetType, target));
                    continue;
                }
                to.__set(propId, from.__get(propId));
            }
        });
    }

    public static boolean isLogicalDeleted(Object o) {
        if (!(o instanceof ImmutableSpi)) {
            return false;
        }
        ImmutableSpi spi = (ImmutableSpi)o;
        LogicalDeletedInfo info = spi.__type().getLogicalDeletedInfo();
        if (info == null) {
            return false;
        }
        PropId propId = info.getProp().getId();
        if (!spi.__isLoaded(propId)) {
            return false;
        }
        return info.isDeleted(spi.__get(propId));
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new ImmutableModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        MAPPER = mapper;
    }
}

