/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Objects;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.Storage;

public class MiddleTable
implements Storage {
    private final String tableName;
    private final ColumnDefinition definition;
    private final ColumnDefinition targetDefinition;
    private final boolean readonly;
    private final boolean deletionBySourcePrevented;
    private final boolean deletionByTargetPrevented;
    private final boolean cascadeDeletedBySource;
    private final boolean cascadeDeletedByTarget;
    private final boolean deletedWhenEndpointIsLogicallyDeleted;
    private final LogicalDeletedInfo logicalDeletedInfo;
    private final JoinTableFilterInfo filterInfo;
    private MiddleTable inverse;

    public MiddleTable(String tableName, ColumnDefinition definition, ColumnDefinition targetDefinition, boolean readonly, boolean deletionBySourcePrevented, boolean deletionByTargetPrevented, boolean cascadeDeletedBySource, boolean cascadeDeletedByTarget, boolean deletedWhenEndpointIsLogicallyDeleted, LogicalDeletedInfo logicalDeletedInfo, JoinTableFilterInfo filterInfo) {
        if (deletionBySourcePrevented && cascadeDeletedBySource) {
            throw new IllegalArgumentException("`deletionBySourcePrevented` and `cascadeDeletedBySource` cannot be true at the same time");
        }
        if (deletionByTargetPrevented && cascadeDeletedByTarget) {
            throw new IllegalArgumentException("`deletionBySourceTarget` and `cascadeDeletedByTarget` cannot be true at the same time");
        }
        this.tableName = tableName;
        this.definition = definition;
        this.targetDefinition = targetDefinition;
        this.readonly = readonly;
        this.deletionBySourcePrevented = deletionBySourcePrevented;
        this.deletionByTargetPrevented = deletionByTargetPrevented;
        this.cascadeDeletedBySource = cascadeDeletedBySource;
        this.cascadeDeletedByTarget = cascadeDeletedByTarget;
        this.deletedWhenEndpointIsLogicallyDeleted = deletedWhenEndpointIsLogicallyDeleted;
        this.logicalDeletedInfo = logicalDeletedInfo;
        this.filterInfo = filterInfo;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ColumnDefinition getColumnDefinition() {
        return this.definition;
    }

    public ColumnDefinition getTargetColumnDefinition() {
        return this.targetDefinition;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isDeletionBySourcePrevented() {
        return this.deletionBySourcePrevented;
    }

    public boolean isDeletionByTargetPrevented() {
        return this.deletionByTargetPrevented;
    }

    public boolean isCascadeDeletedBySource() {
        return this.cascadeDeletedBySource;
    }

    public boolean isCascadeDeletedByTarget() {
        return this.cascadeDeletedByTarget;
    }

    public boolean isDeletedWhenEndpointIsLogicallyDeleted() {
        return this.deletedWhenEndpointIsLogicallyDeleted;
    }

    public LogicalDeletedInfo getLogicalDeletedInfo() {
        return this.logicalDeletedInfo;
    }

    public JoinTableFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public MiddleTable getInverse() {
        MiddleTable iv = this.inverse;
        if (iv == null) {
            this.inverse = iv = new MiddleTable(this.tableName, this.targetDefinition, this.definition, this.readonly, this.deletionByTargetPrevented, this.deletionBySourcePrevented, this.cascadeDeletedByTarget, this.cascadeDeletedBySource, this.deletedWhenEndpointIsLogicallyDeleted, this.logicalDeletedInfo, this.filterInfo);
        }
        return iv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MiddleTable that = (MiddleTable)o;
        return this.readonly == that.readonly && this.deletionBySourcePrevented == that.deletionBySourcePrevented && this.deletionByTargetPrevented == that.deletionByTargetPrevented && this.cascadeDeletedBySource == that.cascadeDeletedBySource && this.cascadeDeletedByTarget == that.cascadeDeletedByTarget && this.deletedWhenEndpointIsLogicallyDeleted == that.deletedWhenEndpointIsLogicallyDeleted && this.tableName.equals(that.tableName) && this.definition.equals(that.definition) && this.targetDefinition.equals(that.targetDefinition) && Objects.equals(this.logicalDeletedInfo, that.logicalDeletedInfo) && Objects.equals(this.filterInfo, that.filterInfo);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.definition, this.targetDefinition, this.readonly, this.deletionBySourcePrevented, this.deletionByTargetPrevented, this.cascadeDeletedBySource, this.cascadeDeletedByTarget, this.deletedWhenEndpointIsLogicallyDeleted, this.logicalDeletedInfo, this.filterInfo);
    }

    public String toString() {
        return "MiddleTable{tableName='" + this.tableName + '\'' + ", definition=" + this.definition + ", targetDefinition=" + this.targetDefinition + ", readonly=" + this.readonly + ", deletionBySourcePrevented=" + this.deletionBySourcePrevented + ", deletionByTargetPrevented=" + this.deletionByTargetPrevented + ", cascadeDeletedBySource=" + this.cascadeDeletedBySource + ", cascadeDeletedByTarget=" + this.cascadeDeletedByTarget + ", deletedWhenEndpointIsLogicallyDeleted=" + this.deletedWhenEndpointIsLogicallyDeleted + ", logicalDeletedInfo=" + this.logicalDeletedInfo + ", filterInfo=" + this.filterInfo + ", inverse=" + this.inverse + '}';
    }
}

