/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.Scalar;
import org.babyfish.jimmer.sql.Column;
import org.babyfish.jimmer.sql.Default;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.IdView;
import org.babyfish.jimmer.sql.JoinColumn;
import org.babyfish.jimmer.sql.JoinColumns;
import org.babyfish.jimmer.sql.JoinSql;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.Key;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.PropOverride;
import org.babyfish.jimmer.sql.PropOverrides;
import org.babyfish.jimmer.sql.Serialized;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.Version;
import org.jetbrains.annotations.Nullable;

public class PropDescriptor {
    public static final Set<String> MAPPED_BY_PROVIDER_NAMES = PropDescriptor.setOf(OneToOne.class.getName(), OneToMany.class.getName(), ManyToMany.class.getName());
    private final Type type;
    private final Set<Class<? extends Annotation>> annotationTypes;
    private final boolean isNullable;

    PropDescriptor(Type type, Set<Class<? extends Annotation>> annotationTypes, boolean isNullable) {
        this.type = type;
        this.annotationTypes = annotationTypes;
        this.isNullable = isNullable;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isPresent(Class<? extends Annotation> annotationType) {
        return this.annotationTypes.contains(annotationType);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return this.annotationTypes;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public static Builder newBuilder(boolean isKotlinType, String typeText, Class<? extends Annotation> typeAnnotationType, String propText, String elementText, Class<? extends Annotation> elementAnnotationType, boolean isList, Boolean explicitNullable, Function<String, RuntimeException> exceptionCreator) {
        return new Builder(isKotlinType, typeText, typeAnnotationType, propText, elementText, elementAnnotationType, isList, explicitNullable, exceptionCreator);
    }

    @SafeVarargs
    private static <E> Set<E> setOf(E ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elements[0]);
            }
        }
        return new LinkedHashSet<E>(Arrays.asList(elements));
    }

    public static enum Type {
        TRANSIENT(Transient.class, false),
        ID(Id.class, false),
        VERSION(Version.class, false),
        LOGICAL_DELETED(LogicalDeleted.class, false),
        FORMULA(Formula.class, false),
        BASIC(null, false),
        ONE_TO_ONE(OneToOne.class, true),
        MANY_TO_ONE(ManyToOne.class, true),
        ONE_TO_MANY(OneToMany.class, true),
        MANY_TO_MANY(ManyToMany.class, true),
        ID_VIEW(IdView.class, false),
        MANY_TO_MANY_VIEW(ManyToManyView.class, true);

        private final Class<? extends Annotation> annotationType;
        private final boolean isAssociation;

        private Type(Class<? extends Annotation> annotationType, boolean isAssociation) {
            this.annotationType = annotationType;
            this.isAssociation = isAssociation;
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotationType;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }

    public static class Builder {
        private static final Map<Class<? extends Annotation>, Type> TYPE_MAP;
        private static final Map<Type, Set<Class<? extends Annotation>>> FAMILY_MAP;
        private static final Map<Class<? extends Annotation>, Set<Type>> INVERSE_MAP;
        private static final Set<Class<? extends Annotation>> SQL_ANNOTATION_TYPES;
        private static final Map<String, Class<? extends Annotation>> ANNOTATION_MAP;
        private static final Set<Class<? extends Annotation>> VALUE_ANNOTATION_TYPES;
        private static final Set<Class<? extends Annotation>> REF_ANNOTATION_TYPES;
        private static final Set<Class<? extends Annotation>> ASSOCIATION_STORAGE_ANNOTATION_TYPES;
        private final boolean isKotlinType;
        private final String typeText;
        private final Class<? extends Annotation> typeAnnotationType;
        private final String propText;
        private final String elementText;
        private final Class<? extends Annotation> elementAnnotationType;
        private final boolean isList;
        private final Boolean explicitNullable;
        private final Function<String, RuntimeException> exceptionCreator;
        private Set<Class<? extends Annotation>> annotationTypes;
        private Class<? extends Annotation> explicitType;
        private Map<Type, Set<Class<? extends Annotation>>> implicitMap;
        private AnnotationNullity annotationNullity;
        private boolean hasMappedBy;

        Builder(boolean isKotlinType, String typeText, Class<? extends Annotation> typeAnnotationType, String propText, String elementText, Class<? extends Annotation> elementAnnotationType, boolean isList, Boolean explicitNullable, Function<String, RuntimeException> exceptionCreator) {
            this.isKotlinType = isKotlinType;
            this.typeText = typeText;
            this.typeAnnotationType = typeAnnotationType;
            this.propText = propText;
            this.elementText = elementText;
            this.elementAnnotationType = elementAnnotationType;
            this.isList = isList;
            this.explicitNullable = explicitNullable;
            this.exceptionCreator = exceptionCreator;
        }

        public Builder add(String annotationTypeName) {
            Class<? extends Annotation> annotationType = ANNOTATION_MAP.get(annotationTypeName);
            if (annotationType != null) {
                this.add(annotationType);
            }
            this.addAsNullityAnnotation(annotationTypeName);
            return this;
        }

        public Builder add(Class<? extends Annotation> annotationType) {
            this.addAsSqlAnnotation(annotationType);
            this.addAsNullityAnnotation(annotationType.getName());
            return this;
        }

        private void addAsSqlAnnotation(Class<? extends Annotation> annotationType) {
            if (SQL_ANNOTATION_TYPES.contains(annotationType)) {
                Set<Class<? extends Annotation>> declaringTypes;
                Set<Class<? extends Annotation>> set = declaringTypes = annotationType == Column.class || annotationType == PropOverrides.class || annotationType == PropOverride.class || annotationType == Scalar.class || annotationType == Serialized.class || annotationType == Formula.class ? VALUE_ANNOTATION_TYPES : REF_ANNOTATION_TYPES;
                if (annotationType != Scalar.class && !declaringTypes.contains(this.typeAnnotationType)) {
                    throw this.exceptionCreator.apply("It cannot be decorated by @" + annotationType.getName() + " because the declaring type \"" + this.typeText + "\" is not decorated by " + declaringTypes.stream().map(Class::getName).collect(Collectors.toList()));
                }
                Set<Class<? extends Annotation>> ats = this.annotationTypes;
                if (ats == null) {
                    this.annotationTypes = ats = new LinkedHashSet<Class<? extends Annotation>>();
                }
                if (ats.add(annotationType)) {
                    Type type = TYPE_MAP.get(annotationType);
                    if (FAMILY_MAP.containsKey((Object)type)) {
                        if (this.explicitType != null) {
                            this.conflict(this.explicitType, annotationType);
                        }
                        this.explicitType = annotationType;
                    } else if (this.explicitType == null) {
                        Set<Type> set2 = INVERSE_MAP.get(annotationType);
                        if (set2 == null) {
                            throw new AssertionError((Object)("Internal bug: Can not determine primary annotation type by @" + annotationType.getName()));
                        }
                        LinkedHashMap<Type, Set<Class<? extends Annotation>>> newImplicitMap = new LinkedHashMap<Type, Set<Class<? extends Annotation>>>();
                        for (Type implicitType : set2) {
                            newImplicitMap.computeIfAbsent(implicitType, it -> new LinkedHashSet()).add(annotationType);
                        }
                        if (this.implicitMap == null) {
                            this.implicitMap = newImplicitMap;
                        } else if (Collections.disjoint(this.implicitMap.keySet(), newImplicitMap.keySet())) {
                            this.conflict(this.implicitMap.values().iterator().next().iterator().next(), annotationType);
                        } else {
                            Iterator<Map.Entry<Type, Set<Class<? extends Annotation>>>> itr = this.implicitMap.entrySet().iterator();
                            while (itr.hasNext()) {
                                Map.Entry<Type, Set<Class<? extends Annotation>>> e = itr.next();
                                Set newSet = (Set)newImplicitMap.get((Object)e.getKey());
                                if (newSet == null) {
                                    itr.remove();
                                    continue;
                                }
                                e.getValue().addAll(newSet);
                            }
                        }
                    }
                }
            }
        }

        private void addAsNullityAnnotation(String annotationTypeName) {
            if (annotationTypeName.endsWith(".Null") || annotationTypeName.endsWith(".Nullable")) {
                this.addNullityAnnotation(annotationTypeName, true);
            } else if (annotationTypeName.endsWith(".NotNull") || annotationTypeName.endsWith(".NonNull")) {
                this.addNullityAnnotation(annotationTypeName, false);
            }
        }

        public Builder hasMappedBy() {
            this.hasMappedBy = true;
            return this;
        }

        public PropDescriptor build() {
            Type type;
            if (this.annotationTypes == null) {
                this.validateReturnType(Type.BASIC);
                return new PropDescriptor(Type.BASIC, Collections.emptySet(), this.determineNullable(Type.BASIC));
            }
            if (this.annotationTypes.contains(JoinColumns.class) && this.annotationTypes.contains(JoinTable.class)) {
                this.conflict(JoinColumns.class, JoinTable.class);
            }
            if (this.annotationTypes.contains(JoinColumn.class) && this.annotationTypes.contains(JoinTable.class)) {
                this.conflict(JoinColumn.class, JoinTable.class);
            }
            if (this.annotationTypes.contains(JoinColumns.class) && this.annotationTypes.contains(JoinSql.class)) {
                this.conflict(JoinColumns.class, JoinSql.class);
            }
            if (this.annotationTypes.contains(JoinColumn.class) && this.annotationTypes.contains(JoinSql.class)) {
                this.conflict(JoinColumn.class, JoinSql.class);
            }
            if (this.annotationTypes.contains(JoinTable.class) && this.annotationTypes.contains(JoinSql.class)) {
                this.conflict(JoinTable.class, JoinSql.class);
            }
            if (this.annotationTypes.contains(Key.class) && this.annotationTypes.contains(JoinTable.class)) {
                this.conflict(Key.class, JoinTable.class);
            }
            if (this.annotationTypes.contains(Key.class) && this.annotationTypes.contains(JoinSql.class)) {
                this.conflict(Key.class, JoinSql.class);
            }
            if (this.annotationTypes.contains(PropOverrides.class) && this.annotationTypes.contains(Column.class)) {
                this.conflict(PropOverrides.class, Column.class);
            }
            if (this.annotationTypes.contains(PropOverride.class) && this.annotationTypes.contains(Column.class)) {
                this.conflict(PropOverride.class, Column.class);
            }
            if (this.elementAnnotationType == Embeddable.class && this.annotationTypes.contains(Column.class)) {
                throw this.exceptionCreator.apply("embedded property cannot be decorated by @" + Column.class.getName());
            }
            if (this.elementAnnotationType != Embeddable.class && this.annotationTypes.contains(PropOverride.class)) {
                throw this.exceptionCreator.apply("only embedded property cannot be decorated by @" + PropOverride.class.getName());
            }
            if (this.elementAnnotationType != Embeddable.class && this.annotationTypes.contains(PropOverrides.class)) {
                throw this.exceptionCreator.apply("only embedded property cannot be decorated by @" + PropOverrides.class.getName());
            }
            Map<Type, Set<Class<? extends Annotation>>> implicitMap = this.implicitMap;
            if (this.explicitType != null) {
                type = TYPE_MAP.get(this.explicitType);
            } else if (implicitMap.size() == 1) {
                type = implicitMap.keySet().iterator().next();
            } else if (implicitMap.containsKey((Object)Type.BASIC)) {
                type = Type.BASIC;
            } else {
                throw this.exceptionCreator.apply("there are not enough annotations to determine that the current property belongs to one of the following types: " + implicitMap.keySet());
            }
            Set<Class<? extends Annotation>> expectedAnnotationTypes = FAMILY_MAP.get((Object)type);
            for (Class<? extends Annotation> annotationType : this.annotationTypes) {
                if (annotationType == type.getAnnotationType() || expectedAnnotationTypes.contains(annotationType)) continue;
                throw this.exceptionCreator.apply("the " + (Object)((Object)type) + " property cannot be decorated by @" + annotationType.getName());
            }
            this.validateList(type);
            this.validateReturnType(type);
            boolean isNullable = this.determineNullable(type);
            if (this.hasMappedBy) {
                for (Class<? extends Annotation> annotationType : this.annotationTypes) {
                    if (!ASSOCIATION_STORAGE_ANNOTATION_TYPES.contains(annotationType)) continue;
                    throw this.exceptionCreator.apply("it cannot be decorated by @" + annotationType.getName() + " because another annotation @" + type.getAnnotationType().getName() + " has the argument `mappedBy`");
                }
                if (type == Type.ONE_TO_ONE && !isNullable) {
                    throw this.exceptionCreator.apply("its annotation @" + type.getAnnotationType().getName() + " has the argument `mappedBy` so that it must be nullable");
                }
            }
            return new PropDescriptor(type, this.annotationTypes, isNullable);
        }

        private void validateList(Type type) {
            switch (type) {
                case TRANSIENT: 
                case ID_VIEW: {
                    break;
                }
                case ONE_TO_MANY: 
                case MANY_TO_MANY: 
                case MANY_TO_MANY_VIEW: {
                    if (this.isList) break;
                    throw this.exceptionCreator.apply("it is not list so that it cannot be decorated by @" + type.getAnnotationType().getName());
                }
                default: {
                    if (!type.isAssociation || !this.isList) break;
                    throw this.exceptionCreator.apply("list association property must be decorated by @" + OneToMany.class.getName() + ", @" + ManyToMany.class.getName() + " or @" + ManyToManyView.class.getName());
                }
            }
        }

        private void validateReturnType(Type type) {
            if (type.isAssociation() && this.elementAnnotationType != Entity.class) {
                throw this.exceptionCreator.apply("it is association property so that its target type \"" + this.elementText + "\" must be decorated by @" + Entity.class.getName());
            }
            if (this.typeAnnotationType == Immutable.class) {
                return;
            }
            if (this.elementAnnotationType == Entity.class && type != Type.TRANSIENT && !type.isAssociation) {
                if (this.isList) {
                    throw this.exceptionCreator.apply("it must be decorated by \"@" + OneToMany.class.getName() + "\" \"@" + ManyToMany.class.getName() + "\" or \"@" + ManyToManyView.class.getName() + "\"");
                }
                throw this.exceptionCreator.apply("it must be decorated by \"@" + ManyToOne.class.getName() + "\" or \"@" + OneToOne.class.getName() + "\"");
            }
            if (type != Type.TRANSIENT && !type.isAssociation && !this.isList && this.elementAnnotationType != null && this.elementAnnotationType != Embeddable.class) {
                throw this.exceptionCreator.apply("it is not association property, its target type \"" + this.elementText + "\" is immutable type, immutable type is not enough, please use \"@" + Embeddable.class.getName() + "\"");
            }
        }

        private void addNullityAnnotation(String annotationTypeName, boolean nullable) {
            if (this.explicitNullable != null) {
                if (this.isKotlinType) {
                    throw this.exceptionCreator.apply("it is unnecessary to use \"@" + annotationTypeName + "\" in kotlin");
                }
                if (this.explicitNullable != nullable) {
                    throw this.exceptionCreator.apply("it cannot be decorated by \"@" + annotationTypeName + "\" which let the property be " + (nullable ? "nullable" : "nonnull") + " because the property type \"" + this.elementText + "\" can only be " + (this.explicitNullable != false ? "nullable" : "nonnull"));
                }
            }
            if (this.annotationNullity != null) {
                if (this.annotationNullity.isNullable != nullable) {
                    throw this.exceptionCreator.apply("it cannot be decorated by both @" + this.annotationNullity.annotationTypeName + " and @" + annotationTypeName);
                }
            } else {
                this.annotationNullity = new AnnotationNullity(annotationTypeName, nullable);
            }
        }

        private boolean determineNullable(Type type) {
            boolean specifiedNullable = this.explicitNullable != null ? this.explicitNullable : this.annotationNullity != null && this.annotationNullity.isNullable;
            switch (type) {
                case ONE_TO_MANY: 
                case MANY_TO_MANY: 
                case ID: 
                case VERSION: {
                    if (!specifiedNullable) break;
                    throw this.exceptionCreator.apply("it cannot be nullable because it is " + (Object)((Object)type) + " property");
                }
                case ONE_TO_ONE: 
                case MANY_TO_ONE: {
                    if (!this.annotationTypes.contains(JoinTable.class) || specifiedNullable) break;
                    throw this.exceptionCreator.apply("the " + (Object)((Object)type) + " property decorated by @" + JoinTable.class + " must be nullable");
                }
                case ID_VIEW: {
                    if (!this.isList || !specifiedNullable) break;
                    throw this.exceptionCreator.apply("the list property cannot be nullable");
                }
            }
            return specifiedNullable;
        }

        private void conflict(Class<?> annotationType1, Class<?> annotationType2) {
            throw this.exceptionCreator.apply("it cannot be decorated by both @" + annotationType1.getName() + " and @" + annotationType2.getName());
        }

        static {
            VALUE_ANNOTATION_TYPES = PropDescriptor.setOf(new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class});
            REF_ANNOTATION_TYPES = PropDescriptor.setOf(new Class[]{Entity.class, MappedSuperclass.class});
            ASSOCIATION_STORAGE_ANNOTATION_TYPES = PropDescriptor.setOf(new Class[]{JoinColumns.class, JoinColumn.class, JoinTable.class, JoinSql.class});
            LinkedHashMap<Class<? extends Annotation>, Type> typeMap = new LinkedHashMap<Class<? extends Annotation>, Type>();
            LinkedHashMap<Type, Set<Class<? extends Annotation>>> families = new LinkedHashMap<Type, Set<Class<? extends Annotation>>>();
            LinkedHashMap<Class<? extends Annotation>, Set<Type>> inverseMap = new LinkedHashMap<Class<? extends Annotation>, Set<Type>>();
            LinkedHashSet<Class<? extends Annotation>> sqlTypes = new LinkedHashSet<Class<? extends Annotation>>();
            LinkedHashMap<String, Class<? extends Annotation>> annotationMap = new LinkedHashMap<String, Class<? extends Annotation>>();
            typeMap.put(Transient.class, Type.TRANSIENT);
            typeMap.put(Id.class, Type.ID);
            typeMap.put(Version.class, Type.VERSION);
            typeMap.put(LogicalDeleted.class, Type.LOGICAL_DELETED);
            typeMap.put(Formula.class, Type.FORMULA);
            typeMap.put(OneToOne.class, Type.ONE_TO_ONE);
            typeMap.put(ManyToOne.class, Type.MANY_TO_ONE);
            typeMap.put(OneToMany.class, Type.ONE_TO_MANY);
            typeMap.put(ManyToMany.class, Type.MANY_TO_MANY);
            typeMap.put(IdView.class, Type.ID_VIEW);
            typeMap.put(ManyToManyView.class, Type.MANY_TO_MANY_VIEW);
            families.put(Type.TRANSIENT, PropDescriptor.setOf(new Class[0]));
            families.put(Type.ID, PropDescriptor.setOf(new Class[]{Column.class, PropOverrides.class, PropOverride.class}));
            families.put(Type.VERSION, PropDescriptor.setOf(new Class[]{Column.class, Default.class}));
            families.put(Type.LOGICAL_DELETED, PropDescriptor.setOf(new Class[]{LogicalDeleted.class, Column.class, Default.class}));
            families.put(Type.FORMULA, PropDescriptor.setOf(new Class[]{Formula.class}));
            families.put(Type.BASIC, PropDescriptor.setOf(new Class[]{Key.class, Column.class, PropOverrides.class, PropOverride.class, Scalar.class, Serialized.class, Default.class}));
            families.put(Type.ONE_TO_ONE, PropDescriptor.setOf(new Class[]{Key.class, OnDissociate.class, JoinColumns.class, JoinColumn.class, JoinTable.class}));
            families.put(Type.MANY_TO_ONE, PropDescriptor.setOf(new Class[]{Key.class, OnDissociate.class, JoinColumns.class, JoinColumn.class, JoinTable.class}));
            families.put(Type.ONE_TO_MANY, PropDescriptor.setOf(new Class[0]));
            families.put(Type.MANY_TO_MANY, PropDescriptor.setOf(new Class[]{JoinTable.class, JoinSql.class}));
            families.put(Type.ID_VIEW, PropDescriptor.setOf(new Class[0]));
            families.put(Type.MANY_TO_MANY_VIEW, PropDescriptor.setOf(new Class[0]));
            for (Map.Entry entry : families.entrySet()) {
                Type type = (Type)((Object)entry.getKey());
                if (type.getAnnotationType() != null) {
                    sqlTypes.add(type.getAnnotationType());
                }
                for (Class annotationType : (Set)entry.getValue()) {
                    sqlTypes.add(annotationType);
                    inverseMap.computeIfAbsent(annotationType, it -> new LinkedHashSet()).add(type);
                }
            }
            for (Class clazz : sqlTypes) {
                annotationMap.put(clazz.getName(), clazz);
            }
            annotationMap.put(Null.class.getName(), Null.class);
            annotationMap.put(Nullable.class.getName(), Nullable.class);
            annotationMap.put(NotNull.class.getName(), NotNull.class);
            annotationMap.put(org.jetbrains.annotations.NotNull.class.getName(), org.jetbrains.annotations.NotNull.class);
            TYPE_MAP = typeMap;
            FAMILY_MAP = families;
            INVERSE_MAP = inverseMap;
            SQL_ANNOTATION_TYPES = sqlTypes;
            ANNOTATION_MAP = annotationMap;
        }
    }

    private static class AnnotationNullity {
        final String annotationTypeName;
        final boolean isNullable;

        AnnotationNullity(String annotationTypeName, boolean isNullable) {
            this.annotationTypeName = annotationTypeName;
            this.isNullable = isNullable;
        }

        public String toString() {
            return "AnnotationNullity{annotationTypeName='" + this.annotationTypeName + '\'' + ", isNullable=" + this.isNullable + '}';
        }
    }
}

