/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;

class PropDeserializeUtils {
    private static final boolean VERSION_GE_2_13 = PropDeserializeUtils.isVersionGe2_13();

    PropDeserializeUtils() {
    }

    public static Object readTreeAsValue(DeserializationContext ctx, JsonNode n, BeanProperty beanProp) throws IOException {
        if (n == null || n.isNull()) {
            return null;
        }
        if (VERSION_GE_2_13) {
            return PropDeserializeUtils.readTreeAsValue(n, beanProp, ctx);
        }
        try (TreeTraversingParser p = PropDeserializeUtils.treeAsTokens(n, ctx);){
            Object t = PropDeserializeUtils.readValue((JsonParser)p, beanProp, ctx);
            return t;
        }
    }

    private static TreeTraversingParser treeAsTokens(JsonNode n, DeserializationContext ctx) throws IOException {
        JsonParser parser = ctx.getParser();
        ObjectCodec codec = parser == null ? null : parser.getCodec();
        TreeTraversingParser p = new TreeTraversingParser(n, codec);
        p.nextToken();
        return p;
    }

    private static final boolean isVersionGe2_13() {
        Version version = PackageVersion.VERSION;
        if (version.getMajorVersion() > 2) {
            return true;
        }
        if (version.getMajorVersion() < 2) {
            return false;
        }
        return version.getMinorVersion() >= 13;
    }

    private static Object readTreeAsValue(JsonNode n, BeanProperty beanProp, DeserializationContext ctx) throws IOException {
        if (n == null) {
            return null;
        }
        try (TreeTraversingParser p = PropDeserializeUtils.treeAsTokens(n, ctx);){
            Object t = PropDeserializeUtils.readValue((JsonParser)p, beanProp, ctx);
            return t;
        }
    }

    public static <T> T readValue(JsonParser p, BeanProperty beanProp, DeserializationContext ctx) throws IOException {
        JavaType declaringType = beanProp.getType();
        JsonDeserializer deser = ctx.findContextualValueDeserializer(declaringType, beanProp);
        if (deser == null) {
            return (T)ctx.reportBadDefinition(declaringType, "Could not find JsonDeserializer for type " + ClassUtil.getTypeDescription((JavaType)declaringType));
        }
        TypeDeserializer td = (TypeDeserializer)declaringType.getTypeHandler();
        if (td == null) {
            td = ctx.getConfig().findTypeDeserializer(declaringType);
        }
        if (td != null) {
            td = td.forProperty(beanProp);
            deser = new TypeWrappedDeserializer(td, deser);
        }
        return (T)deser.deserialize(p, ctx);
    }
}

