/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;

public class DeserializeUtils {
    private static final boolean VERSION_GE_2_13 = DeserializeUtils.isVersionGe2_13();

    public static Object readTreeAsValue(DeserializationContext ctx, JsonNode n, JavaType targetType) throws IOException {
        if (n == null || n.isNull()) {
            return null;
        }
        if (VERSION_GE_2_13) {
            return ctx.readTreeAsValue(n, targetType);
        }
        try (TreeTraversingParser p = DeserializeUtils.treeAsTokens(n, ctx);){
            Object object = ctx.readValue((JsonParser)p, targetType);
            return object;
        }
    }

    private static TreeTraversingParser treeAsTokens(JsonNode n, DeserializationContext ctx) throws IOException {
        JsonParser parser = ctx.getParser();
        ObjectCodec codec = parser == null ? null : parser.getCodec();
        TreeTraversingParser p = new TreeTraversingParser(n, codec);
        p.nextToken();
        return p;
    }

    private static final boolean isVersionGe2_13() {
        Version version = PackageVersion.VERSION;
        if (version.getMajorVersion() > 2) {
            return true;
        }
        if (version.getMajorVersion() < 2) {
            return false;
        }
        return version.getMinorVersion() >= 13;
    }
}

