/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.ApiOperationImpl;
import org.babyfish.jimmer.client.meta.impl.ApiParameterImpl;
import org.babyfish.jimmer.client.meta.impl.ApiServiceImpl;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.PropImpl;
import org.babyfish.jimmer.client.meta.impl.SchemaBuilder;
import org.babyfish.jimmer.client.meta.impl.SchemaImpl;
import org.babyfish.jimmer.client.meta.impl.TypeDefinitionImpl;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;

public class TypeDefinitionVisitor<S>
implements AstNodeVisitor<S> {
    private final SchemaBuilder<S> builder;
    private final Map<TypeName, TypeDefinitionImpl<S>> typeDefinitionMap;

    public TypeDefinitionVisitor(SchemaBuilder<S> builder) {
        this.builder = builder;
        SchemaImpl schema = (SchemaImpl)builder.ancestor(SchemaImpl.class);
        this.typeDefinitionMap = schema.getTypeDefinitionMap();
    }

    @Override
    public boolean visitAstNode(AstNode<S> astNode) {
        if (TypeDefinitionVisitor.isContextNode(astNode)) {
            this.builder.push(astNode);
        } else if (astNode instanceof TypeRefImpl) {
            TypeDefinitionImpl existingDefinition;
            TypeName typeName = ((TypeRefImpl)astNode).getTypeName();
            if (!typeName.isGenerationRequired()) {
                return true;
            }
            List<String> groups = ((ApiOperationImpl)this.builder.ancestor(ApiOperationImpl.class)).getGroups();
            if (groups == null) {
                groups = ((ApiServiceImpl)this.builder.ancestor(ApiServiceImpl.class)).getGroups();
            }
            if ((existingDefinition = this.typeDefinitionMap.get(typeName)) != null) {
                existingDefinition.accept(new ApplyGroupsVisitor(this.typeDefinitionMap, groups));
                return true;
            }
            S source = this.builder.loadSource(typeName.toString());
            if (source == null) {
                this.builder.throwException(this.builder.ancestorSource(new Class[0]), "Cannot resolve the type name \"" + typeName + "\"");
            }
            List<String> finalGroups = groups;
            this.builder.definition(source, typeName, definition -> {
                this.typeDefinitionMap.put(typeName, (TypeDefinitionImpl<S>)definition);
                definition.mergeGroups(finalGroups);
                this.builder.fillDefinition(source);
                for (Prop prop : definition.getPropMap().values()) {
                    ((PropImpl)prop).accept(this);
                }
                for (TypeRef superType : definition.getSuperTypes()) {
                    ((TypeRefImpl)superType).accept(this);
                }
            });
        }
        return true;
    }

    @Override
    public void visitedAstNode(AstNode<S> astNode) {
        if (TypeDefinitionVisitor.isContextNode(astNode)) {
            this.builder.pop();
        }
    }

    private static boolean isContextNode(AstNode<?> astNode) {
        return astNode instanceof ApiServiceImpl || astNode instanceof ApiOperationImpl || astNode instanceof ApiParameterImpl;
    }

    private static class ApplyGroupsVisitor<S>
    implements AstNodeVisitor<S> {
        private static final Object PRESENT = new Object();
        private final IdentityHashMap<AstNode<S>, Object> map = new IdentityHashMap();
        private final Map<TypeName, TypeDefinitionImpl<S>> typeDefinitionMap;
        private final List<String> groups;

        private ApplyGroupsVisitor(Map<TypeName, TypeDefinitionImpl<S>> typeDefinitionMap, List<String> groups) {
            this.typeDefinitionMap = typeDefinitionMap;
            this.groups = groups;
        }

        @Override
        public boolean visitAstNode(AstNode<S> astNode) {
            TypeDefinitionImpl<S> definition;
            if (astNode instanceof TypeDefinitionImpl) {
                TypeDefinitionImpl definition2 = (TypeDefinitionImpl)astNode;
                if (this.map.put(definition2, PRESENT) != null) {
                    return false;
                }
                definition2.mergeGroups(this.groups);
            } else if (astNode instanceof TypeRefImpl && (definition = this.typeDefinitionMap.get(((TypeRefImpl)astNode).getTypeName())) != null) {
                definition.accept(this);
            }
            return true;
        }
    }
}

