/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.EnumConstant;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class EnumConstantImpl<S>
extends AstNode<S>
implements EnumConstant {
    private final String name;
    private Doc doc;

    public EnumConstantImpl(S source, String name) {
        super(source);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        visitor.visitAstNode(this);
        visitor.visitedAstNode(this);
    }

    public static class Deserializer
    extends JsonDeserializer<EnumConstantImpl<?>> {
        public EnumConstantImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            EnumConstantImpl<Object> constant = new EnumConstantImpl<Object>(null, jsonNode.get("name").asText());
            constant.setDoc((Doc)ctx.readTreeAsValue(jsonNode.get("doc"), Doc.class));
            return constant;
        }
    }

    public static class Serializer
    extends JsonSerializer<EnumConstantImpl<?>> {
        public void serialize(EnumConstantImpl<?> constant, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            provider.defaultSerializeField("name", (Object)constant.getName(), gen);
            if (constant.getDoc() != null) {
                provider.defaultSerializeField("doc", (Object)constant.getDoc(), gen);
            }
            gen.writeEndObject();
        }
    }
}

