/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TypeRefImpl<S>
extends AstNode<S>
implements TypeRef {
    private TypeName typeName;
    private boolean nullable;
    private List<TypeRefImpl<S>> arguments = new ArrayList<TypeRefImpl<S>>();
    private String fetchBy;
    private TypeName fetchOwner;
    private Doc fetcherDoc;

    public TypeRefImpl() {
        super(null);
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    public void setTypeName(TypeName typeName) {
        this.typeName = typeName;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public List<TypeRef> getArguments() {
        return this.arguments;
    }

    public void addArgument(TypeRefImpl<S> argument) {
        this.arguments.add(argument);
    }

    @Override
    @Nullable
    public String getFetchBy() {
        return this.fetchBy;
    }

    public void setFetchBy(String fetchBy) {
        this.fetchBy = fetchBy;
    }

    @Override
    @Nullable
    public TypeName getFetcherOwner() {
        return this.fetchOwner;
    }

    public void setFetcherOwner(TypeName fetchOwner) {
        this.fetchOwner = fetchOwner;
    }

    @Override
    @Nullable
    public Doc getFetcherDoc() {
        return this.fetcherDoc;
    }

    public void setFetcherDoc(Doc fetcherDoc) {
        this.fetcherDoc = fetcherDoc;
    }

    public void replaceBy(TypeRefImpl<S> typeRef, Boolean isNullable) {
        this.source = typeRef.source;
        this.typeName = typeRef.typeName;
        this.nullable = isNullable != null ? isNullable : typeRef.nullable;
        this.fetchBy = typeRef.fetchBy;
        this.fetchOwner = typeRef.fetchOwner;
        this.fetcherDoc = typeRef.fetcherDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        try {
            if (!visitor.visitAstNode(this)) {
                return;
            }
            if (this.arguments != null) {
                for (TypeRefImpl<S> argument : this.arguments) {
                    argument.accept(visitor);
                }
            }
        }
        finally {
            visitor.visitedAstNode(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeRefImpl typeRef = (TypeRefImpl)o;
        if (this.nullable != typeRef.nullable) {
            return false;
        }
        if (!this.typeName.equals(typeRef.typeName)) {
            return false;
        }
        if (!this.arguments.equals(typeRef.arguments)) {
            return false;
        }
        if (!Objects.equals(this.fetchBy, typeRef.fetchBy)) {
            return false;
        }
        return Objects.equals(this.fetchOwner, typeRef.fetchOwner);
    }

    public int hashCode() {
        int result = this.typeName.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + (this.fetchBy != null ? this.fetchBy.hashCode() : 0);
        result = 31 * result + (this.fetchOwner != null ? this.fetchOwner.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeRefImpl{typeName='" + this.typeName + '\'' + ", nullable=" + this.nullable + ", arguments=" + this.arguments + ", fetchBy='" + this.fetchBy + '\'' + ", fetchOwner='" + this.fetchOwner + '\'' + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<TypeRefImpl<?>> {
        public TypeRefImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            TypeRefImpl typeRef = new TypeRefImpl();
            typeRef.setTypeName((TypeName)ctx.readTreeAsValue(jsonNode.get("typeName"), TypeName.class));
            if (jsonNode.has("nullable")) {
                typeRef.setNullable(jsonNode.get("nullable").asBoolean());
            }
            if (jsonNode.has("arguments")) {
                for (JsonNode argNode : jsonNode.get("arguments")) {
                    TypeRefImpl arg = (TypeRefImpl)ctx.readTreeAsValue(argNode, TypeRefImpl.class);
                    typeRef.addArgument(arg);
                }
            }
            if (jsonNode.has("fetchBy")) {
                typeRef.setFetchBy(jsonNode.get("fetchBy").asText());
                typeRef.setFetcherOwner(TypeName.parse(jsonNode.get("fetcherOwner").asText()));
                if (jsonNode.has("fetcherDoc")) {
                    typeRef.setFetcherDoc((Doc)ctx.readTreeAsValue(jsonNode.get("fetcherDoc"), Doc.class));
                }
            }
            return typeRef;
        }
    }

    public static class Serializer
    extends JsonSerializer<TypeRefImpl<?>> {
        public void serialize(TypeRefImpl<?> typeRef, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            provider.defaultSerializeField("typeName", (Object)typeRef.getTypeName(), gen);
            if (typeRef.isNullable()) {
                gen.writeFieldName("nullable");
                gen.writeBoolean(true);
            }
            if (!typeRef.getArguments().isEmpty()) {
                provider.defaultSerializeField("arguments", typeRef.getArguments(), gen);
            }
            if (typeRef.getFetchBy() != null) {
                gen.writeFieldName("fetchBy");
                gen.writeString(typeRef.getFetchBy());
                gen.writeFieldName("fetcherOwner");
                gen.writeString(typeRef.getFetcherOwner().toString());
                provider.defaultSerializeField("fetcherDoc", (Object)typeRef.getFetcherDoc(), gen);
            }
            gen.writeEndObject();
        }
    }
}

