/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.jetbrains.annotations.NotNull;

public class Dependency {
    @NotNull
    private final List<ImmutableProp> props;

    public Dependency(List<ImmutableProp> props) {
        this.props = props;
    }

    public Dependency(ImmutableProp ... props) {
        ArrayList<ImmutableProp> list = new ArrayList<ImmutableProp>(props.length);
        for (ImmutableProp prop : props) {
            list.add(prop);
        }
        this.props = Collections.unmodifiableList(list);
    }

    @NotNull
    public List<ImmutableProp> getProps() {
        return this.props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.props.equals(that.props);
    }

    public int hashCode() {
        return this.props.hashCode();
    }

    public String toString() {
        return "Dependency{props=" + this.props + '}';
    }
}

