/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Page<T> {
    @NotNull
    private final List<T> rows;
    private final long totalRowCount;
    private final long totalPageCount;

    @JsonCreator
    public Page(@JsonProperty(value="rows") List<T> rows, @JsonProperty(value="totalRowCount") long totalRowCount, @JsonProperty(value="totalPageCount") long totalPageCount) {
        this.rows = rows != null && !rows.isEmpty() ? rows : Collections.emptyList();
        this.totalRowCount = totalRowCount;
        this.totalPageCount = totalPageCount;
    }

    @NotNull
    public List<T> getRows() {
        return this.rows;
    }

    public long getTotalPageCount() {
        return this.totalPageCount;
    }

    public long getTotalRowCount() {
        return this.totalRowCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        if (this.totalRowCount != page.totalRowCount) {
            return false;
        }
        if (this.totalPageCount != page.totalPageCount) {
            return false;
        }
        return this.rows.equals(page.rows);
    }

    public int hashCode() {
        int result = this.rows.hashCode();
        result = 31 * result + (int)(this.totalRowCount ^ this.totalRowCount >>> 32);
        result = 31 * result + (int)(this.totalPageCount ^ this.totalPageCount >>> 32);
        return result;
    }

    public String toString() {
        return "Page{rows=" + this.rows + ", totalRowCount=" + this.totalRowCount + ", totalPageCount=" + this.totalPageCount + '}';
    }
}

