/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.meta.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.meta.Prop;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.meta.impl.AstNode;
import org.babyfish.jimmer.client.meta.impl.AstNodeVisitor;
import org.babyfish.jimmer.client.meta.impl.TypeRefImpl;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class PropImpl<S>
extends AstNode<S>
implements Prop {
    private String name;
    private Doc doc;
    private TypeRefImpl<S> type;

    PropImpl(S source, String name) {
        super(source);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TypeRef getType() {
        return this.type;
    }

    public void setType(TypeRefImpl<S> type) {
        this.type = type;
    }

    @Override
    @Nullable
    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    public void accept(AstNodeVisitor<S> visitor) {
        try {
            if (!visitor.visitAstNode(this)) {
                return;
            }
            this.type.accept(visitor);
        }
        finally {
            visitor.visitedAstNode(this);
        }
    }

    public String toString() {
        return "PropImpl{name='" + this.name + '\'' + ", doc=" + this.doc + ", type=" + this.type + '}';
    }

    public static class Deserializer
    extends JsonDeserializer<PropImpl<?>> {
        public PropImpl<?> deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JacksonException {
            JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
            PropImpl<Object> prop = new PropImpl<Object>(null, jsonNode.get("name").asText());
            prop.setType((TypeRefImpl)ctx.readTreeAsValue(jsonNode.get("type"), TypeRefImpl.class));
            if (jsonNode.has("doc")) {
                prop.setDoc((Doc)ctx.readTreeAsValue(jsonNode.get("doc"), Doc.class));
            }
            return prop;
        }
    }

    public static class Serializer
    extends JsonSerializer<PropImpl<?>> {
        public void serialize(PropImpl<?> prop, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("name");
            gen.writeString(prop.getName());
            provider.defaultSerializeField("type", (Object)prop.getType(), gen);
            if (prop.getDoc() != null) {
                provider.defaultSerializeField("doc", (Object)prop.getDoc(), gen);
            }
            gen.writeEndObject();
        }
    }
}

