/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Objects;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.Storage;

public class MiddleTable
implements Storage {
    private final String tableName;
    private final ColumnDefinition definition;
    private final ColumnDefinition targetDefinition;
    private final boolean readonly;
    private final boolean deletionBySourcePrevented;
    private final boolean deletionByTargetPrevented;
    private final boolean deletedWhenEndpointIsLogicallyDeleted;
    private final LogicalDeletedInfo logicalDeletedInfo;
    private final JoinTableFilterInfo filterInfo;
    private MiddleTable inverse;

    public MiddleTable(String tableName, ColumnDefinition definition, ColumnDefinition targetDefinition, boolean readonly, boolean deletionBySourcePrevented, boolean deletionByTargetPrevented, boolean deletedWhenEndpointIsLogicallyDeleted, LogicalDeletedInfo logicalDeletedInfo, JoinTableFilterInfo filterInfo) {
        this.tableName = tableName;
        this.definition = definition;
        this.targetDefinition = targetDefinition;
        this.readonly = readonly;
        this.deletionBySourcePrevented = deletionBySourcePrevented;
        this.deletionByTargetPrevented = deletionByTargetPrevented;
        this.deletedWhenEndpointIsLogicallyDeleted = deletedWhenEndpointIsLogicallyDeleted;
        this.logicalDeletedInfo = logicalDeletedInfo;
        this.filterInfo = filterInfo;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ColumnDefinition getColumnDefinition() {
        return this.definition;
    }

    public ColumnDefinition getTargetColumnDefinition() {
        return this.targetDefinition;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isDeletionBySourcePrevented() {
        return this.deletionBySourcePrevented;
    }

    public boolean isDeletionByTargetPrevented() {
        return this.deletionByTargetPrevented;
    }

    public boolean isDeletedWhenEndpointIsLogicallyDeleted() {
        return this.deletedWhenEndpointIsLogicallyDeleted;
    }

    public LogicalDeletedInfo getLogicalDeletedInfo() {
        return this.logicalDeletedInfo;
    }

    public JoinTableFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public MiddleTable getInverse() {
        MiddleTable iv = this.inverse;
        if (iv == null) {
            this.inverse = iv = new MiddleTable(this.tableName, this.targetDefinition, this.definition, this.readonly, this.deletionByTargetPrevented, this.deletionBySourcePrevented, this.deletedWhenEndpointIsLogicallyDeleted, this.logicalDeletedInfo, this.filterInfo);
        }
        return iv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MiddleTable that = (MiddleTable)o;
        return this.readonly == that.readonly && this.deletionBySourcePrevented == that.deletionBySourcePrevented && this.deletionByTargetPrevented == that.deletionByTargetPrevented && this.tableName.equals(that.tableName) && this.definition.equals(that.definition) && this.targetDefinition.equals(that.targetDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.definition, this.targetDefinition, this.readonly, this.deletionBySourcePrevented, this.deletionByTargetPrevented);
    }

    public String toString() {
        return "MiddleTable{tableName='" + this.tableName + '\'' + ", definition=" + this.definition + ", targetDefinition=" + this.targetDefinition + ", readonly=" + this.readonly + ", deletionBySourcePrevented=" + this.deletionBySourcePrevented + ", deletionByTargetPrevented=" + this.deletionByTargetPrevented + ", deletedWhenEndpointIsLogicalDeleted=" + this.deletedWhenEndpointIsLogicallyDeleted + ", logicalDeletedInfo=" + this.logicalDeletedInfo + ", filterInfo=" + this.filterInfo + ", inverse=" + this.inverse + '}';
    }
}

