/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ListDraft<E>
implements List<E>,
Draft {
    private final DraftContext ctx;
    private final Class<E> elementType;
    private final List<E> base;
    private List<E> modified;
    private int modCount;

    public ListDraft(Class<E> elementType, List<E> base) {
        this(null, elementType, base);
    }

    public ListDraft(DraftContext ctx, Class<E> elementType, List<E> base) {
        this.ctx = ctx;
        this.elementType = Classes.boxTypeOf(elementType);
        this.base = base;
    }

    public DraftContext draftContext() {
        return this.ctx;
    }

    @Override
    public boolean isEmpty() {
        return (this.modified != null ? this.modified : this.base).isEmpty();
    }

    @Override
    public int size() {
        return (this.modified != null ? this.modified : this.base).size();
    }

    @Override
    public int indexOf(Object o) {
        return (this.modified != null ? this.modified : this.base).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return (this.modified != null ? this.modified : this.base).lastIndexOf(o);
    }

    @Override
    public E get(int index) {
        return this.output((this.modified != null ? this.modified : this.base).get(index));
    }

    @Override
    public boolean contains(Object o) {
        return (this.modified != null ? this.modified : this.base).contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return (this.modified != null ? this.modified : this.base).containsAll(c);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int index = 0;
        for (E e : this) {
            arr[index++] = e;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] arr = a.length >= size ? a : new Object[size];
        int index = 0;
        for (E e : this) {
            arr[index++] = e;
        }
        return arr;
    }

    @Override
    public int hashCode() {
        return (this.modified != null ? this.modified : this.base).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return (this.modified != null ? this.modified : this.base).equals(o);
    }

    public String toString() {
        return (this.modified != null ? this.modified : this.base).toString();
    }

    @Override
    public boolean add(E e) {
        this.input(e);
        ++this.modCount;
        return this.mutable().add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.input(o);
        }
        ++this.modCount;
        return this.mutable().addAll(c);
    }

    @Override
    public void add(int index, E e) {
        this.input(e);
        ++this.modCount;
        this.mutable().add(index, e);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E o : c) {
            this.input(o);
        }
        ++this.modCount;
        return this.mutable().addAll(index, c);
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.mutable().clear();
            ++this.modCount;
        }
    }

    @Override
    public boolean remove(Object o) {
        if (this.mutable().remove(o)) {
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.mutable().removeAll(c)) {
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.mutable().retainAll(c)) {
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        ++this.modCount;
        return this.output(this.mutable().set(index, element));
    }

    @Override
    public E remove(int index) {
        ++this.modCount;
        return this.output(this.mutable().remove(index));
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new Itr(0, 0, index, true, null);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> list;
        List<E> list2 = list = this.modified != null ? this.modified : this.base;
        if (fromIndex < 0 || toIndex > list.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new SubList(fromIndex, list.size() - toIndex);
    }

    private boolean removeRange(int headHide, int tailHide, Predicate<E> predicate) {
        ++this.modCount;
        List<E> m = this.mutable();
        ListIterator<E> itr = m.subList(headHide, m.size() - tailHide).listIterator(m.size() - headHide - tailHide);
        boolean changed = false;
        while (itr.hasPrevious()) {
            E element = itr.previous();
            if (predicate != null && !predicate.test(element)) continue;
            itr.remove();
            changed = true;
        }
        return changed;
    }

    private List<E> mutable() {
        List<E> m = this.modified;
        if (m == null) {
            this.modified = m = new ArrayList<E>(this.base);
        }
        return m;
    }

    private E input(Object element) {
        if (element == null || !this.elementType.isAssignableFrom(element.getClass())) {
            throw new IllegalArgumentException("New element's type must be \"" + this.elementType.getName() + "\"");
        }
        return (E)element;
    }

    private E output(E element) {
        if (this.ctx != null) {
            return (E)this.ctx.toDraftObject(element);
        }
        return element;
    }

    public List<E> resolve() {
        this.resolveElements();
        List<E> b = this.base;
        List<E> m = this.modified;
        if (m == null) {
            return b;
        }
        if (b.size() == m.size()) {
            Iterator<E> itr1 = b.iterator();
            Iterator<E> itr2 = m.iterator();
            boolean changed = false;
            while (!changed && itr1.hasNext() && itr2.hasNext()) {
                if (this.ctx != null) {
                    changed = !ImmutableSpi.equals(itr1.next(), itr2.next(), true);
                    continue;
                }
                changed = !itr1.next().equals(itr2.next());
            }
            if (!changed) {
                return b;
            }
        }
        return m;
    }

    private void resolveElements() {
        DraftContext ctx = this.ctx;
        if (ctx != null) {
            Itr itr = new Itr(0, 0, 0, false, null);
            while (itr.hasNext()) {
                Object resolved;
                Object unresolved = itr.next();
                if (unresolved == (resolved = ctx.resolveObject(unresolved))) continue;
                itr.set(resolved);
            }
        }
    }

    private class Itr
    implements ListIterator<E> {
        private final int headHide;
        private final int tailHide;
        private final boolean outputDraft;
        private final Consumer<Integer> modCountChanged;
        private int absIndex;
        private Cursor cursor;
        private int modCount;
        private ListIterator<E> baseItr;
        private ListIterator<E> modifiedItr;

        public Itr(int headHide, int tailHide, int index, boolean outputDraft, Consumer<Integer> modCountChanged) {
            this.headHide = headHide;
            this.tailHide = tailHide;
            this.modCountChanged = modCountChanged;
            this.outputDraft = outputDraft;
            this.absIndex = headHide + index;
            ListDraft parent = ListDraft.this;
            this.modCount = parent.modCount;
            this.baseItr = (parent.modified != null ? parent.modified : parent.base).listIterator(this.absIndex);
        }

        @Override
        public boolean hasNext() {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.absIndex < (parent.modified != null ? parent.modified : parent.base).size() - this.tailHide;
        }

        @Override
        public E next() {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.absIndex >= (parent.modified != null ? parent.modified : parent.base).size() - this.tailHide) {
                throw new NoSuchElementException();
            }
            this.cursor = new Cursor(true, this.absIndex++);
            Object next = (this.modifiedItr != null ? this.modifiedItr : this.baseItr).next();
            return this.outputDraft ? ListDraft.this.output(next) : next;
        }

        @Override
        public int nextIndex() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.absIndex - this.headHide;
        }

        @Override
        public boolean hasPrevious() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.absIndex > this.headHide;
        }

        @Override
        public E previous() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.absIndex <= this.headHide) {
                throw new NoSuchElementException();
            }
            this.cursor = new Cursor(false, --this.absIndex);
            Object previous = (this.modifiedItr != null ? this.modifiedItr : this.baseItr).previous();
            return this.outputDraft ? ListDraft.this.output(previous) : previous;
        }

        @Override
        public int previousIndex() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.absIndex - this.headHide - 1;
        }

        @Override
        public void remove() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor == null) {
                throw new IllegalStateException();
            }
            int pos = this.cursor.pos;
            this.mutableItr().remove();
            if (pos < this.absIndex) {
                --this.absIndex;
            }
            this.cursor = null;
            this.modCount = ListDraft.this.modCount;
            if (this.modCountChanged != null) {
                this.modCountChanged.accept(this.modCount);
            }
        }

        @Override
        public void add(E element) {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.mutableItr().add(ListDraft.this.input(element));
            ++this.absIndex;
            this.cursor = null;
            this.modCount = ListDraft.this.modCount;
            if (this.modCountChanged != null) {
                this.modCountChanged.accept(this.modCount);
            }
        }

        @Override
        public void set(E element) {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor == null) {
                throw new IllegalStateException();
            }
            this.mutableItr().set(ListDraft.this.input(element));
            this.modCount = ListDraft.this.modCount;
            if (this.modCountChanged != null) {
                this.modCountChanged.accept(this.modCount);
            }
        }

        private ListIterator<E> mutableItr() {
            ListIterator itr = this.modifiedItr;
            if (this.modifiedItr == null) {
                if (this.cursor == null) {
                    return ListDraft.this.mutable().listIterator(this.absIndex);
                }
                itr = this.cursor.recreate(ListDraft.this.mutable());
                this.modifiedItr = itr;
                this.baseItr = null;
            }
            return itr;
        }
    }

    private class SubList
    implements List<E> {
        private final int headHide;
        private final int tailHide;
        private int modCount;

        public SubList(int headHide, int tailHide) {
            this.headHide = headHide;
            this.tailHide = tailHide;
            this.modCount = ListDraft.this.modCount;
        }

        @Override
        public boolean isEmpty() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return ListDraft.this.size() <= this.headHide + this.tailHide;
        }

        @Override
        public int size() {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return ListDraft.this.size() - this.headHide - this.tailHide;
        }

        @Override
        public boolean contains(Object element) {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            int absIndex = ListDraft.this.indexOf(element);
            return absIndex >= this.headHide && absIndex < ListDraft.this.size() - this.tailHide;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            for (Object element : c) {
                int absIndex = ListDraft.this.indexOf(element);
                if (absIndex >= this.headHide && absIndex < ListDraft.this.size() - this.tailHide) continue;
                return false;
            }
            return true;
        }

        @Override
        public E get(int index) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (index < 0 || index >= parent.size() - this.headHide - this.tailHide) {
                throw new IndexOutOfBoundsException();
            }
            return parent.get(this.headHide + index);
        }

        @Override
        public int indexOf(Object element) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            int absIndex = parent.indexOf(element);
            if (absIndex >= this.headHide && absIndex < parent.size() - this.tailHide) {
                return absIndex - this.headHide;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object element) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            int absIndex = parent.lastIndexOf(element);
            if (absIndex >= this.headHide && absIndex < parent.size() - this.tailHide) {
                return absIndex - this.headHide;
            }
            return -1;
        }

        @Override
        public Object[] toArray() {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            Object[] arr = new Object[this.size()];
            int index = 0;
            for (Object e : this) {
                arr[index++] = e;
            }
            return arr;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            int size = this.size();
            Object[] arr = a.length >= size ? a : new Object[size];
            int index = 0;
            for (Object e : this) {
                arr[index++] = e;
            }
            return arr;
        }

        @Override
        public int hashCode() {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            int hashCode = 1;
            for (Object e : this) {
                hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            int size = this.size();
            if (size != other.size()) {
                return false;
            }
            if (size == 0) {
                return true;
            }
            Iterator itr = this.iterator();
            Iterator otherItr = other.iterator();
            while (itr.hasNext()) {
                if (Objects.equals(itr.next(), otherItr.next())) continue;
                return false;
            }
            return false;
        }

        public String toString() {
            Iterator itr = this.iterator();
            if (!itr.hasNext()) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            while (true) {
                Object e = itr.next();
                builder.append(e);
                if (!itr.hasNext()) {
                    return builder.append(']').toString();
                }
                builder.append(',').append(' ');
            }
        }

        @Override
        public boolean add(E element) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            parent.add(parent.size() - this.tailHide, element);
            this.modCount = parent.modCount;
            return true;
        }

        @Override
        public void add(int index, E element) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (index < 0 || index >= parent.size() - this.headHide - this.tailHide) {
                throw new IndexOutOfBoundsException();
            }
            parent.add(index + this.headHide, element);
            this.modCount = parent.modCount;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (parent.addAll(parent.size() - this.tailHide, c)) {
                this.modCount = parent.modCount;
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (index < 0 || index >= parent.size() - this.headHide - this.tailHide) {
                throw new IndexOutOfBoundsException();
            }
            if (parent.addAll(index + this.headHide, c)) {
                this.modCount = parent.modCount;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            parent.removeRange(this.headHide, this.tailHide, null);
            this.modCount = parent.modCount;
        }

        @Override
        public boolean remove(Object element) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (parent.removeRange(this.headHide, this.tailHide, it -> Objects.equals(it, element))) {
                this.modCount = parent.modCount;
                return true;
            }
            return false;
        }

        @Override
        public E remove(int index) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (index < 0 || index >= parent.size() - this.headHide - this.tailHide) {
                throw new IndexOutOfBoundsException();
            }
            Object result = parent.remove(index + this.headHide);
            this.modCount = parent.modCount;
            return ListDraft.this.output(result);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (parent.removeRange(this.headHide, this.tailHide, c::contains)) {
                this.modCount = parent.modCount;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ListDraft parent = ListDraft.this;
            if (this.modCount != parent.modCount) {
                throw new ConcurrentModificationException();
            }
            if (parent.removeRange(this.headHide, this.tailHide, it -> !c.contains(it))) {
                this.modCount = parent.modCount;
                return true;
            }
            return false;
        }

        @Override
        public E set(int index, E element) {
            ListDraft parent = ListDraft.this;
            if (index < 0 || index >= parent.size() - this.headHide - this.tailHide) {
                throw new IndexOutOfBoundsException();
            }
            Object result = parent.set(index + this.headHide, element);
            this.modCount = parent.modCount;
            return ListDraft.this.output(result);
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (this.modCount != ListDraft.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return new Itr(this.headHide, this.tailHide, index, true, it -> {
                this.modCount = it;
            });
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            ListDraft parent = ListDraft.this;
            int size = parent.size() - this.headHide - this.tailHide;
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            if (fromIndex < 0 || toIndex > size) {
                throw new IndexOutOfBoundsException();
            }
            return new SubList(this.headHide + fromIndex, this.tailHide + size - toIndex);
        }
    }

    private static class Cursor {
        boolean next;
        int pos;

        public Cursor(boolean next, int pos) {
            this.next = next;
            this.pos = pos;
        }

        public <E> ListIterator<E> recreate(List<E> list) {
            ListIterator<E> itr;
            if (this.next) {
                itr = list.listIterator(this.pos);
                itr.next();
            } else {
                itr = list.listIterator(this.pos + 1);
                itr.previous();
            }
            return itr;
        }
    }
}

