/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.Scalar;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.jackson.Converter;
import org.babyfish.jimmer.jackson.JsonConverter;
import org.babyfish.jimmer.meta.Dependency;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.ImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.meta.impl.Utils;
import org.babyfish.jimmer.meta.spi.ImmutablePropImplementor;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.Id;
import org.babyfish.jimmer.sql.IdView;
import org.babyfish.jimmer.sql.JoinSql;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.OrderedProp;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.Version;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.meta.impl.MetaCache;
import org.babyfish.jimmer.sql.meta.impl.Storages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutablePropImpl
implements ImmutableProp,
ImmutablePropImplementor {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final ImmutableTypeImpl declaringType;
    private final PropId id;
    private final String name;
    private final ImmutablePropCategory category;
    private final Class<?> elementClass;
    private final boolean nullable;
    private final boolean inputNotNull;
    private final KProperty1<?, ?> kotlinProp;
    private final Method javaGetter;
    private final Annotation associationAnnotation;
    private final Class<? extends Annotation> primaryAnnotationType;
    private final boolean isTransient;
    private final boolean hasTransientResolver;
    private final boolean isFormula;
    private final SqlTemplate sqlTemplate;
    private final DissociateAction dissociateAction;
    private final ImmutablePropImpl original;
    private Converter<?> converter;
    private boolean converterResolved;
    private int storageType;
    private ImmutableTypeImpl targetType;
    private boolean targetTypeResolved;
    private List<OrderedItem> orderedItems;
    private ImmutableProp mappedBy;
    private ImmutableProp acceptedMappedBy;
    private boolean mappedByResolved;
    private ImmutableProp opposite;
    private boolean oppositeResolved;
    private List<Dependency> dependencies;
    private List<ImmutableProp> propsDependOnSelf;
    private ImmutableProp idViewBaseProp;
    private boolean idViewBasePropResolved;
    private ImmutableProp manyToManyViewBaseProp;
    private ImmutableProp manyToManyViewBaseDeeperProp;
    private boolean manyToManyViewBasePropResolved;
    private Boolean isRemote;
    private final MetaCache<Storage> storageCache = new MetaCache<Storage>(it -> Storages.of(this, it));

    ImmutablePropImpl(ImmutableTypeImpl declaringType, PropId id, String name, ImmutablePropCategory category, Class<?> elementClass, boolean nullable, Class<? extends Annotation> associationType) {
        this.declaringType = declaringType;
        this.id = id;
        this.name = name;
        this.category = category;
        this.elementClass = elementClass;
        this.nullable = nullable;
        KClass<?> kotlinClass = declaringType.getKotlinClass();
        this.kotlinProp = kotlinClass != null ? KClasses.getDeclaredMemberProperties(kotlinClass).stream().filter(it -> name.equals(it.getName())).findFirst().get() : null;
        Method javaGetter = null;
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            if (javaGetter.getReturnType() != Boolean.TYPE) {
                javaGetter = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (javaGetter == null) {
            throw new AssertionError((Object)("Internal bug: Cannot find the getter of prop \"" + name + "\" of the interface \"" + declaringType.getJavaClass().getName() + "\""));
        }
        this.javaGetter = javaGetter;
        Transient trans = this.getAnnotation(Transient.class);
        this.isTransient = trans != null;
        this.hasTransientResolver = trans != null && (trans.value() != Void.TYPE || !trans.ref().isEmpty());
        Formula formula = this.getAnnotation(Formula.class);
        boolean bl = this.isFormula = formula != null;
        if (formula != null && this.isAssociation(TargetLevel.ENTITY)) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + Formula.class.getName() + "\" so that it cannot be association");
        }
        JoinSql joinSql = this.getAnnotation(JoinSql.class);
        if (formula != null && !formula.sql().isEmpty()) {
            try {
                this.sqlTemplate = FormulaTemplate.of(formula.sql());
            }
            catch (IllegalArgumentException ex) {
                throw new ModelException("Illegal property \"" + this + "\", the formula sql template: " + ex.getMessage());
            }
        } else {
            this.sqlTemplate = joinSql != null ? JoinTemplate.of(joinSql.value()) : null;
        }
        ManyToOne manyToOne = this.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        boolean bl2 = manyToOne != null ? manyToOne.inputNotNull() : (this.inputNotNull = oneToOne != null && oneToOne.inputNotNull());
        if (this.isInputNotNull() && !nullable) {
            throw new ModelException("Illegal property \"" + this + "\", it `inputNotNull` can only be specified for nullable property");
        }
        OnDissociate onDissociate = this.getAnnotation(OnDissociate.class);
        if (onDissociate != null) {
            if (category != ImmutablePropCategory.REFERENCE) {
                throw new ModelException("Illegal property \"" + this + "\", only reference property can be decorated by @OnDissociate");
            }
            if (oneToOne != null && !oneToOne.mappedBy().isEmpty()) {
                throw new ModelException("Illegal property \"" + this + "\", the one-to-one property with `mappedBy` cannot be decorated by @OnDissociate");
            }
            this.dissociateAction = onDissociate.value();
        } else {
            this.dissociateAction = DissociateAction.NONE;
        }
        if (associationType != null) {
            this.associationAnnotation = this.getAnnotation(associationType);
            this.primaryAnnotationType = associationType;
        } else {
            this.associationAnnotation = null;
            this.primaryAnnotationType = this.isId() ? Id.class : (this.isVersion() ? Version.class : (this.isLogicalDeleted() ? LogicalDeleted.class : (this.isFormula ? Formula.class : (this.isTransient ? Transient.class : (this.getAnnotation(IdView.class) != null ? IdView.class : (this.getAnnotation(ManyToManyView.class) != null ? ManyToManyView.class : Scalar.class))))));
        }
        this.original = null;
    }

    ImmutablePropImpl(ImmutablePropImpl original, ImmutableTypeImpl declaringType, PropId id) {
        if (!original.getDeclaringType().isAssignableFrom(declaringType)) {
            throw new IllegalArgumentException("The new declaring type \"" + declaringType + "\" is illegal, it is not derived type of original declaring type \"" + original.getDeclaringType() + "\"");
        }
        while (original.original != null) {
            original = original.original;
        }
        this.declaringType = declaringType;
        this.id = id != null ? id : original.id;
        this.name = original.name;
        this.category = original.category;
        this.elementClass = original.elementClass;
        this.nullable = original.nullable;
        this.inputNotNull = original.inputNotNull;
        this.kotlinProp = original.kotlinProp;
        this.javaGetter = original.javaGetter;
        this.associationAnnotation = original.associationAnnotation;
        this.primaryAnnotationType = original.primaryAnnotationType;
        this.isTransient = original.isTransient;
        this.isFormula = original.isFormula;
        this.sqlTemplate = original.sqlTemplate;
        this.hasTransientResolver = original.hasTransientResolver;
        this.dissociateAction = original.dissociateAction;
        this.original = original;
    }

    @Override
    @NotNull
    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public PropId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ImmutablePropCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    @NotNull
    public Class<?> getReturnClass() {
        return this.javaGetter.getReturnType();
    }

    @Override
    @NotNull
    public Type getGenericType() {
        return this.javaGetter.getGenericReturnType();
    }

    @Override
    public boolean isEmbedded(EmbeddedLevel level) {
        ImmutableType targetType = this.getTargetType();
        if (level.hasReference() && this.isReference(TargetLevel.PERSISTENT) && targetType.getIdProp().isEmbedded(EmbeddedLevel.SCALAR)) {
            return true;
        }
        return level.hasScalar() && targetType != null && targetType.isEmbeddable();
    }

    @Override
    public boolean isScalar(TargetLevel level) {
        if (level == TargetLevel.OBJECT) {
            return this.category == ImmutablePropCategory.SCALAR;
        }
        ImmutableType targetType = this.getTargetType();
        return targetType == null || !targetType.isEntity();
    }

    @Override
    public boolean isScalarList() {
        return this.category == ImmutablePropCategory.SCALAR_LIST;
    }

    @Override
    public boolean isAssociation(TargetLevel level) {
        if (!this.category.isAssociation()) {
            return false;
        }
        int ordinal = level.ordinal();
        if (ordinal >= TargetLevel.ENTITY.ordinal() && !this.getTargetType().isEntity()) {
            return false;
        }
        return ordinal < TargetLevel.PERSISTENT.ordinal() || !this.isTransient && !this.isRemote();
    }

    @Override
    public boolean isReference(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE && this.isAssociation(level);
    }

    @Override
    public boolean isReferenceList(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE_LIST && this.isAssociation(level);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isInputNotNull() {
        return this.inputNotNull;
    }

    @Override
    public boolean isMutable() {
        return !this.isFormula || this.sqlTemplate instanceof FormulaTemplate;
    }

    @Override
    public Method getJavaGetter() {
        return this.javaGetter;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Annotation annotation;
        if (this.kotlinProp != null && (annotation = (Annotation)this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).findFirst().orElse(null)) != null) {
            return (A)annotation;
        }
        return this.javaGetter.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] getterArr = this.javaGetter.getAnnotations();
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = this.kotlinProp.getAnnotations().toArray(EMPTY_ANNOTATIONS);
        }
        if (propArr == null || propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = new Annotation[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        Annotation[] getterArr = this.javaGetter.getAnnotationsByType(annotationType);
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = (Annotation[])this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).toArray();
        }
        if (propArr == null || propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = (Annotation[])new Object[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    @Override
    public Class<? extends Annotation> getPrimaryAnnotationType() {
        return this.primaryAnnotationType;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean hasTransientResolver() {
        return this.hasTransientResolver;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    @Nullable
    public SqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    @Override
    public boolean isView() {
        return this.idViewBaseProp != null || this.idViewBaseProp != null;
    }

    @Override
    public ImmutableProp getIdViewBaseProp() {
        ImmutableProp baseProp;
        if (this.idViewBasePropResolved) {
            return this.idViewBaseProp;
        }
        IdView idView = this.getAnnotation(IdView.class);
        if (idView == null) {
            baseProp = null;
        } else {
            String basePropName;
            if (this.isAssociation(TargetLevel.ENTITY)) {
                throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" so that it cannot be association");
            }
            if (idView.value().isEmpty()) {
                basePropName = Utils.defaultViewBasePropName(this.isReferenceList(TargetLevel.OBJECT) || this.isScalarList(), this.name);
                if (basePropName == null) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" but the base property name cannot be determined automatically");
                }
            } else {
                basePropName = idView.value();
            }
            if ((baseProp = this.declaringType.getProps().get(basePropName)) == null) {
                throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" but there is not base property named \"" + basePropName + "\" in the type \"" + this.declaringType + "\"");
            }
            if (baseProp.isTransient()) {
                throw new ModelException("Illegal property \"" + this + "\" is a scalar list property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\" but the base property \"" + baseProp + "\" is not a reference list property");
            }
            if (this.isScalarList() && !baseProp.isReferenceList(TargetLevel.ENTITY)) {
                throw new ModelException("Illegal property \"" + this + "\" is a scalar list property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\" but the base property \"" + baseProp + "\" is not a reference list property");
            }
            if (!this.isScalarList() && !baseProp.isReference(TargetLevel.ENTITY)) {
                throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\" but the base property \"" + baseProp + "\" is not a reference property");
            }
            if (!Classes.matches(baseProp.getTargetType().getIdProp().getElementClass(), this.getElementClass())) {
                throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\", the base property \"" + baseProp + "\" return the entity type whose id is \"" + baseProp.getTargetType().getIdProp().getElementClass() + "\" but the element type of the current property is \"" + this.getElementClass() + "\"");
            }
            if (this.isNullable() != baseProp.isNullable()) {
                throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + basePropName + "\", but the nullity of current property does not equal to the nullity of the base property \"" + baseProp + "\"");
            }
        }
        this.idViewBaseProp = baseProp;
        this.idViewBasePropResolved = true;
        return baseProp;
    }

    @Override
    public ImmutableProp getManyToManyViewBaseProp() {
        this.resolveManyToManyViewBaseProp();
        return this.manyToManyViewBaseProp;
    }

    @Override
    public ImmutableProp getManyToManyViewBaseDeeperProp() {
        this.resolveManyToManyViewBaseProp();
        return this.manyToManyViewBaseDeeperProp;
    }

    private void resolveManyToManyViewBaseProp() {
        if (this.manyToManyViewBasePropResolved) {
            return;
        }
        ManyToManyView manyToManyView = this.getAnnotation(ManyToManyView.class);
        if (manyToManyView == null) {
            return;
        }
        String propName = manyToManyView.prop();
        ImmutableProp prop = this.declaringType.getProps().get(propName);
        if (prop == null) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but there is not base property named \"" + propName + "\" in the type \"" + this.declaringType + "\"");
        }
        if (prop.getAnnotation(OneToMany.class) == null) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" with `prop` \"" + propName + "\", but prop \"" + prop + "\" in the type is not an one-to-many association");
        }
        ImmutableType middleType = prop.getTargetType();
        String deeperPropName = manyToManyView.deeperProp();
        ImmutableProp deeperProp = null;
        if (deeperPropName.isEmpty()) {
            for (ImmutableProp middleProp : middleType.getProps().values()) {
                if (middleProp.getTargetType() != this.getTargetType() || middleProp.getAnnotation(ManyToOne.class) == null) continue;
                if (deeperProp != null) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but the middle entity has two many-to-one association properties pointing to target type: \"" + deeperProp + "\" and \"" + middleProp + "\"");
                }
                deeperProp = middleProp;
            }
            if (deeperProp == null) {
                throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but the middle entity \"" + middleType + "\" has no many-to-one association properties pointing to target type: ");
            }
        } else {
            deeperProp = middleType.getProps().get(deeperPropName);
            if (deeperProp == null) {
                throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but there is not property \"" + deeperPropName + "\" in the middle entity type: " + middleType);
            }
        }
        if (deeperProp.getAnnotation(ManyToOne.class) == null || deeperProp.getTargetType() != this.getTargetType()) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + ManyToManyView.class.getName() + "\" but the deeper property \"" + deeperProp + "\" is not a many-to-one proerty pointing to the target type \"" + this.getTargetType() + "\"");
        }
        this.manyToManyViewBaseProp = prop;
        this.manyToManyViewBaseDeeperProp = deeperProp;
        this.manyToManyViewBasePropResolved = true;
    }

    @Override
    public Converter<?> getConverter() {
        if (this.converterResolved) {
            return this.converter;
        }
        Class annotationType = null;
        JsonConverter jsonConverter = this.getAnnotation(JsonConverter.class);
        if (jsonConverter != null) {
            annotationType = JsonConverter.class;
        }
        for (Annotation anno : this.getAnnotations()) {
            JsonConverter deepAnno;
            if (anno.annotationType() == JsonConverter.class || (deepAnno = anno.annotationType().getAnnotation(JsonConverter.class)) == null) continue;
            if (annotationType != null) {
                throw new ModelException("Illegal property \"" + this + "\", duplicate converter annotation @" + annotationType.getName() + " and @" + anno.annotationType().getName());
            }
            jsonConverter = deepAnno;
            annotationType = anno.annotationType();
        }
        if (jsonConverter != null) {
            Class<Converter<?>> converterType = jsonConverter.value();
            Collection genericArguments = TypeUtils.getTypeArguments(converterType, Converter.class).values();
            if (genericArguments.isEmpty() || !(genericArguments.iterator().next() instanceof Class)) {
                throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + annotationType.getName() + ", the converter type \"" + converterType.getName() + "\" does not specify the generic parameter of \"" + Converter.class.getName() + "\" as class");
            }
            Class convertedType = (Class)genericArguments.iterator().next();
            if (convertedType != this.javaGetter.getReturnType()) {
                throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + annotationType.getName() + ", the property type \"" + this.javaGetter.getReturnType() + "\" does not match the generic type \"" + convertedType.getName() + "\" of converter type \"" + converterType.getName() + "\"");
            }
            try {
                this.converter = converterType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + annotationType.getName() + ", cannot create instance for converter type \"" + converterType.getName() + "\"", ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex);
            }
        }
        this.converterResolved = true;
        return this.converter;
    }

    @Override
    @NotNull
    public DissociateAction getDissociateAction() {
        return this.dissociateAction;
    }

    @Override
    public boolean hasStorage() {
        return this.getStorageType() > 1;
    }

    @Override
    public boolean isColumnDefinition() {
        return this.getStorageType() == 2;
    }

    @Override
    public boolean isMiddleTableDefinition() {
        return this.getStorageType() == 3;
    }

    @Override
    public <S extends Storage> S getStorage(MetadataStrategy strategy) {
        if (this.getStorageType() <= 1) {
            return null;
        }
        return (S)this.storageCache.get(strategy);
    }

    private int getStorageType() {
        int type = this.storageType;
        if (type == 0) {
            int result = this.isTransient() || this.isFormula() || !this.getDependencies().isEmpty() || this.getDeclaringType().isEmbeddable() || this.getSqlTemplate() instanceof JoinTemplate || this.getMappedBy() != null ? 1 : (!(this.associationAnnotation instanceof ManyToMany) && this.getAnnotation(JoinTable.class) == null ? 2 : 3);
            this.storageType = type = result;
        }
        return type;
    }

    @Override
    public boolean isId() {
        return this == this.declaringType.getIdProp() || this.original != null && this.original.isId();
    }

    @Override
    public boolean isVersion() {
        return this == this.declaringType.getVersionProp() || this.original != null && this.original.isVersion();
    }

    @Override
    public boolean isLogicalDeleted() {
        LogicalDeletedInfo info = this.declaringType.getLogicalDeletedInfo();
        return info != null && info.getProp() == this || this.original != null && this.original.isLogicalDeleted();
    }

    @Override
    public ImmutableType getTargetType() {
        if (this.targetTypeResolved) {
            return this.targetType;
        }
        if (this.isAssociation(TargetLevel.OBJECT)) {
            this.targetType = Metadata.tryGet(this.elementClass);
            if (this.targetType == null) {
                throw new ModelException("Cannot resolve target type of \"" + this + "\"");
            }
            if (this.sqlTemplate != null && this.declaringType.isEntity() && !this.declaringType.getMicroServiceName().equals(this.targetType.getMicroServiceName())) {
                throw new ModelException("Illegal association property \"" + this + "\", it is is remote association so that it cannot be decorated by \"@" + JoinSql.class.getName() + "\"");
            }
        }
        this.targetTypeResolved = true;
        return this.targetType;
    }

    @Override
    public List<OrderedItem> getOrderedItems() {
        List<OrderedItem> orderedItems = this.orderedItems;
        if (orderedItems == null) {
            OrderedProp[] orderedProps = null;
            if (this.isReferenceList(TargetLevel.PERSISTENT)) {
                OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                if (oneToMany != null) {
                    orderedProps = oneToMany.orderedProps();
                } else {
                    ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
                    if (manyToMany != null) {
                        orderedProps = manyToMany.orderedProps();
                    }
                }
            }
            if (orderedProps == null || orderedProps.length == 0) {
                orderedItems = Collections.emptyList();
            } else {
                ImmutableType targetType = this.getTargetType();
                LinkedHashMap<String, OrderedItem> map = new LinkedHashMap<String, OrderedItem>((orderedProps.length * 4 + 2) / 3);
                for (OrderedProp orderedProp : orderedProps) {
                    if (map.containsKey(orderedProp.value())) {
                        throw new ModelException("Illegal property \"" + this + "\", duplicated ordered property \"" + orderedProp.value() + "\"");
                    }
                    ImmutableProp prop = targetType.getProps().get(orderedProp.value());
                    if (prop == null) {
                        throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + orderedProp.value() + "\" is not declared in target type \"" + targetType + "\"");
                    }
                    if (!prop.isScalar(TargetLevel.PERSISTENT)) {
                        throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + prop + "\" is not scalar field");
                    }
                    map.put(orderedProp.value(), new OrderedItem(prop, orderedProp.desc()));
                }
                orderedItems = Collections.unmodifiableList(new ArrayList(map.values()));
            }
            this.orderedItems = orderedItems;
        }
        return orderedItems;
    }

    @Override
    public ImmutableProp getMappedBy() {
        String mappedBy;
        if (this.mappedByResolved) {
            return this.mappedBy;
        }
        if (this.isAssociation(TargetLevel.ENTITY) && !(mappedBy = this.getMappedByValue()).isEmpty()) {
            ImmutableProp resolved = this.getTargetType().getProps().get(mappedBy);
            if (resolved == null) {
                throw new ModelException("Cannot resolve the mappedBy property name \"" + mappedBy + "\" for property \"" + this + "\"");
            }
            if (!resolved.hasStorage() && !(resolved.getSqlTemplate() instanceof JoinTemplate)) {
                throw new ModelException("The property \"" + resolved + "\" is illegal, it's not persistence property so that \"" + this + "\" cannot reference it by \"mappedBy\"");
            }
            if (resolved.getAssociationAnnotation().annotationType() == OneToOne.class && this.associationAnnotation.annotationType() != OneToOne.class) {
                throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
            }
            if (resolved.getAssociationAnnotation().annotationType() == ManyToOne.class && this.associationAnnotation.annotationType() != OneToMany.class) {
                throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
            }
            if (resolved.isReferenceList(TargetLevel.PERSISTENT) && this.associationAnnotation.annotationType() != ManyToMany.class) {
                throw new ModelException("Illegal property \"" + this + "\", it must be many-to-many property because its \"mappedBy\" property \"" + resolved + "\" is list");
            }
            ((ImmutablePropImpl)resolved).acceptMappedBy(this);
            this.mappedBy = resolved;
        }
        this.mappedByResolved = true;
        return this.mappedBy;
    }

    String getMappedByValue() {
        String mappedBy = "";
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            mappedBy = oneToOne.mappedBy();
        }
        if (mappedBy.isEmpty()) {
            ManyToMany manyToMany;
            OneToMany oneToMany = this.getAnnotation(OneToMany.class);
            if (oneToMany != null) {
                mappedBy = oneToMany.mappedBy();
            }
            if (mappedBy.isEmpty() && (manyToMany = this.getAnnotation(ManyToMany.class)) != null) {
                mappedBy = manyToMany.mappedBy();
            }
        }
        return mappedBy;
    }

    private void acceptMappedBy(ImmutableProp prop) {
        if (this.acceptedMappedBy != null) {
            throw new ModelException("Both `" + this.acceptedMappedBy + "` and `" + prop + "` use `mappedBy` to reference `" + this + "`");
        }
        this.acceptedMappedBy = prop;
    }

    @Override
    public ImmutableProp getOpposite() {
        if (this.oppositeResolved) {
            return this.opposite;
        }
        if (this.isAssociation(TargetLevel.PERSISTENT)) {
            if (!this.declaringType.isEntity()) {
                throw new UnsupportedOperationException("Cannot access the `opposite` of \"" + this + "\" because it is not declared in entity");
            }
            this.opposite = this.getMappedBy();
            if (this.opposite == null) {
                for (ImmutableProp backProp : this.getTargetType().getProps().values()) {
                    if (backProp.getMappedBy() != this) continue;
                    this.opposite = backProp;
                    break;
                }
            }
        }
        this.oppositeResolved = true;
        return this.opposite;
    }

    @Override
    public ImmutableProp getReal() {
        ImmutableProp mappedBy = this.getMappedBy();
        return mappedBy != null ? mappedBy : this;
    }

    @Override
    public List<Dependency> getDependencies() {
        List<Dependency> list = this.dependencies;
        if (list == null) {
            this.dependencies = list = Collections.unmodifiableList(this.getDependenciesImpl(new LinkedList<ImmutableProp>()));
        }
        return list;
    }

    @Override
    public List<ImmutableProp> getPropsDependOnSelf() {
        List<ImmutableProp> list = this.propsDependOnSelf;
        if (list == null) {
            list = new ArrayList<ImmutableProp>();
            for (ImmutableProp prop : this.getDeclaringType().getProps().values()) {
                if (prop == this || !prop.getDependencies().stream().anyMatch(it -> it.getProp() == this)) continue;
                list.add(prop);
            }
            this.propsDependOnSelf = Collections.unmodifiableList(list);
        }
        return list;
    }

    @Override
    public boolean isRemote() {
        Boolean remote = this.isRemote;
        if (remote == null) {
            if (this.isAssociation(TargetLevel.ENTITY)) {
                remote = !this.declaringType.getMicroServiceName().equals(this.getTargetType().getMicroServiceName());
                if (remote.booleanValue() && this.sqlTemplate != null) {
                    throw new ModelException("Illegal property \"" + this + "\", remote association(micro-service names of declaring type and target type are different) cannot be decorated by \"@" + JoinSql.class.getName() + "\"");
                }
            } else {
                remote = false;
            }
            this.isRemote = remote;
        }
        return remote;
    }

    @Override
    public ImmutableProp toOriginal() {
        return this.original != null ? this.original : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dependency> getDependenciesImpl(LinkedList<ImmutableProp> stack) {
        List<Dependency> list = this.dependencies;
        if (list == null) {
            list = new ArrayList<Dependency>();
            Formula formula = this.getAnnotation(Formula.class);
            if (formula != null) {
                String[] arr = formula.dependencies();
                if (arr.length != 0) {
                    Map<String, ImmutableProp> propMap = this.declaringType.getProps();
                    stack.push(this);
                    try {
                        for (String name : arr) {
                            boolean isValid;
                            ImmutableProp prop = propMap.get(name);
                            if (prop == null) {
                                throw new ModelException("Illegal property \"" + this + "\", its dependency property \"" + this.declaringType + '.' + name + "\" does not exists");
                            }
                            if (stack.contains(prop)) {
                                throw new ModelException("Illegal entity type \"" + this.declaringType + "\", dependency cycle has been found: " + stack);
                            }
                            boolean bl = isValid = prop.isFormula() || prop.hasStorage() && !prop.isReference(TargetLevel.PERSISTENT);
                            if (!isValid) {
                                throw new ModelException("Illegal property \"" + this + "\", its dependency property \"" + prop + "\" must be scalar property or another formula property");
                            }
                            if (prop.isFormula()) {
                                if (prop.getSqlTemplate() instanceof FormulaTemplate) {
                                    throw new ModelException("Illegal property \"" + this + "\", it is an abstract formula property based on SQL exception but its dependency property \"" + prop + "\" is another formula property(This is only allowed for non-abstract formula property based on java/kotlin expression)");
                                }
                                ((ImmutablePropImpl)prop).getDependenciesImpl(stack);
                            }
                            list.add(new Dependency(prop));
                        }
                    }
                    finally {
                        stack.pop();
                    }
                }
            } else if (this.getIdViewBaseProp() != null) {
                list.add(new Dependency(this.getIdViewBaseProp()));
            } else if (this.getManyToManyViewBaseProp() != null) {
                list.add(new Dependency(this.getManyToManyViewBaseProp(), this.getManyToManyViewBaseDeeperProp()));
            }
        }
        return list;
    }

    ImmutableProp getOriginal() {
        return this.original;
    }

    public int hashCode() {
        return this.declaringType.hashCode() ^ System.identityHashCode(this.original != null ? this.original : this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutablePropImpl)) {
            return false;
        }
        ImmutablePropImpl prop = (ImmutablePropImpl)o;
        return this.declaringType == prop.declaringType && (this.original != null ? this.original : this) == (prop.original != null ? prop.original : prop);
    }

    public String toString() {
        return this.declaringType.toString() + '.' + this.name;
    }
}

