/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Objects;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.Storage;

public class MiddleTable
implements Storage {
    private final String tableName;
    private final ColumnDefinition definition;
    private final ColumnDefinition targetDefinition;
    private MiddleTable inverse;

    public MiddleTable(String tableName, ColumnDefinition definition, ColumnDefinition targetDefinition) {
        this.tableName = tableName;
        this.definition = definition;
        this.targetDefinition = targetDefinition;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ColumnDefinition getColumnDefinition() {
        return this.definition;
    }

    public ColumnDefinition getTargetColumnDefinition() {
        return this.targetDefinition;
    }

    public MiddleTable getInverse() {
        MiddleTable iv = this.inverse;
        if (iv == null) {
            this.inverse = iv = new MiddleTable(this.tableName, this.targetDefinition, this.definition);
        }
        return iv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MiddleTable that = (MiddleTable)o;
        return this.tableName.equals(that.tableName) && this.definition.equals(that.definition) && this.targetDefinition.equals(that.targetDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.definition, this.targetDefinition);
    }

    public String toString() {
        return "MiddleTable{tableName='" + this.tableName + '\'' + ", definition=" + this.definition + ", targetDefinition=" + this.targetDefinition + '}';
    }
}

