/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.runtime;

import java.util.Arrays;

public abstract class Visibility {
    public abstract boolean visible(int var1);

    public abstract void show(int var1, boolean var2);

    public static Visibility of(int propCount) {
        int longCount = (propCount + 63) / 64;
        switch (longCount) {
            case 0: 
            case 1: {
                return new Simple();
            }
            case 2: {
                return new Composite2();
            }
            case 3: {
                return new Composite3();
            }
            case 4: {
                return new Composite4();
            }
        }
        if (propCount < 0) {
            throw new IllegalArgumentException("`propCount` cannot be negative number");
        }
        return new CompositeAny(longCount);
    }

    abstract int longCount();

    public String toString() {
        int lc = this.longCount();
        int propId = 0;
        boolean addComma = false;
        StringBuilder builder = new StringBuilder();
        builder.append("Visibility{hiddenPropIds=[");
        for (int i = 0; i < lc; ++i) {
            if (this.visible(++propId)) continue;
            if (addComma) {
                builder.append(',');
            } else {
                addComma = true;
            }
            builder.append(propId);
        }
        builder.append("]}");
        return builder.toString();
    }

    private static class Simple
    extends Visibility {
        private long hidden;

        private Simple() {
        }

        @Override
        int longCount() {
            return 1;
        }

        @Override
        public final boolean visible(int propId) {
            long mask = 1L << propId - 1;
            return (this.hidden & mask) == 0L;
        }

        @Override
        public final void show(int propId, boolean visible) {
            long mask = 1L << propId - 1;
            this.hidden = visible ? (this.hidden &= mask ^ 0xFFFFFFFFFFFFFFFFL) : (this.hidden |= mask);
        }

        public int hashCode() {
            return Long.hashCode(this.hidden);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple simple = (Simple)o;
            return this.hidden == simple.hidden;
        }
    }

    private static class Composite2
    extends Composite {
        private long hidden0;
        private long hidden1;

        private Composite2() {
        }

        @Override
        int longCount() {
            return 2;
        }

        @Override
        long hidden(int index) {
            switch (index) {
                case 0: {
                    return this.hidden0;
                }
                case 1: {
                    return this.hidden1;
                }
            }
            throw new AssertionError((Object)"Internal bug");
        }

        @Override
        void hidden(int index, long value) {
            switch (index) {
                case 0: {
                    this.hidden0 = value;
                    break;
                }
                case 1: {
                    this.hidden1 = value;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Internal bug");
                }
            }
        }

        public int hashCode() {
            return Arrays.hashCode(new long[]{this.hidden0, this.hidden1});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Composite2)) {
                return false;
            }
            Composite2 composite = (Composite2)o;
            return this.hidden0 == composite.hidden0 && this.hidden1 == composite.hidden1;
        }
    }

    private static class Composite3
    extends Composite {
        private long hidden0;
        private long hidden1;
        private long hidden2;

        private Composite3() {
        }

        @Override
        int longCount() {
            return 3;
        }

        @Override
        long hidden(int index) {
            switch (index) {
                case 0: {
                    return this.hidden0;
                }
                case 1: {
                    return this.hidden1;
                }
                case 2: {
                    return this.hidden2;
                }
            }
            throw new AssertionError((Object)"Internal bug");
        }

        @Override
        void hidden(int index, long value) {
            switch (index) {
                case 0: {
                    this.hidden0 = value;
                    break;
                }
                case 1: {
                    this.hidden1 = value;
                    break;
                }
                case 2: {
                    this.hidden2 = value;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Internal bug");
                }
            }
        }

        public int hashCode() {
            return Arrays.hashCode(new long[]{this.hidden0, this.hidden1, this.hidden2});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Composite3)) {
                return false;
            }
            Composite3 composite = (Composite3)o;
            return this.hidden0 == composite.hidden0 && this.hidden1 == composite.hidden1 && this.hidden2 == composite.hidden2;
        }
    }

    private static class Composite4
    extends Composite {
        private long hidden0;
        private long hidden1;
        private long hidden2;
        private long hidden3;

        private Composite4() {
        }

        @Override
        int longCount() {
            return 4;
        }

        @Override
        long hidden(int index) {
            switch (index) {
                case 0: {
                    return this.hidden0;
                }
                case 1: {
                    return this.hidden1;
                }
                case 2: {
                    return this.hidden2;
                }
                case 3: {
                    return this.hidden3;
                }
            }
            throw new AssertionError((Object)"Internal bug");
        }

        @Override
        void hidden(int index, long value) {
            switch (index) {
                case 0: {
                    this.hidden0 = value;
                    break;
                }
                case 1: {
                    this.hidden1 = value;
                    break;
                }
                case 2: {
                    this.hidden2 = value;
                    break;
                }
                case 3: {
                    this.hidden3 = value;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Internal bug");
                }
            }
        }

        public int hashCode() {
            return Arrays.hashCode(new long[]{this.hidden0, this.hidden1, this.hidden2, this.hidden3});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Composite4)) {
                return false;
            }
            Composite4 composite = (Composite4)o;
            return this.hidden0 == composite.hidden0 && this.hidden1 == composite.hidden1 && this.hidden2 == composite.hidden2 && this.hidden3 == composite.hidden3;
        }
    }

    private static class CompositeAny
    extends Composite {
        private final long[] hiddenArr;

        public CompositeAny(int longCount) {
            this.hiddenArr = new long[longCount];
        }

        @Override
        int longCount() {
            return this.hiddenArr.length;
        }

        @Override
        long hidden(int index) {
            return this.hiddenArr[index];
        }

        @Override
        void hidden(int index, long value) {
            this.hiddenArr[index] = value;
        }

        public int hashCode() {
            return Arrays.hashCode(this.hiddenArr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeAny)) {
                return false;
            }
            CompositeAny composite = (CompositeAny)o;
            return Arrays.equals(this.hiddenArr, composite.hiddenArr);
        }
    }

    private static abstract class Composite
    extends Visibility {
        abstract long hidden(int var1);

        abstract void hidden(int var1, long var2);

        Composite() {
        }

        @Override
        public final boolean visible(int propId) {
            int index = propId - 1;
            int arrIndex = index / 64;
            long mask = 1L << index - arrIndex * 64;
            return (this.hidden(arrIndex) & mask) == 0L;
        }

        @Override
        public final void show(int propId, boolean visible) {
            int index = propId - 1;
            int arrIndex = index / 64;
            long mask = 1L << index - arrIndex * 64;
            if (visible) {
                this.hidden(arrIndex, this.hidden(arrIndex) & (mask ^ 0xFFFFFFFFFFFFFFFFL));
            } else {
                this.hidden(arrIndex, this.hidden(arrIndex) | mask);
            }
        }
    }
}

