/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kotlin.jvm.internal.ClassBasedDeclarationContainer;
import kotlin.reflect.KClass;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.AbstractImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.ImmutablePropImpl;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.Table;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.impl.IdGenerators;
import org.babyfish.jimmer.sql.meta.impl.MetaCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableTypeImpl
extends AbstractImmutableTypeImpl {
    private static final Class<? extends Annotation>[] SQL_ANNOTATION_TYPES = new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class};
    private static final IdGenerator NIL_ID_GENERATOR = new IdGenerator(){};
    private final Class<?> javaClass;
    private final boolean isEntity;
    private final boolean isMappedSupperClass;
    private final boolean isEmbeddable;
    private final Annotation immutableAnnotation;
    private KClass<?> kotlinClass;
    private final ImmutableType superType;
    private final BiFunction<DraftContext, Object, Draft> draftFactory;
    private Map<String, ImmutableProp> declaredProps;
    private Map<String, ImmutableProp> props;
    private ImmutableProp[] propArr;
    private Map<String, ImmutableProp> selectableProps;
    private Map<String, ImmutableProp> selectableReferenceProps;
    private ImmutableProp idProp;
    private ImmutableProp versionProp;
    private LogicalDeletedInfo declaredLogicalDeletedInfo;
    private LogicalDeletedInfo logicalDeletedInfo;
    private Set<ImmutableProp> keyProps = Collections.emptySet();
    private final String microServiceName;
    private final MetaCache<String> tableNameCache = new MetaCache<String>(this::getTableName0);
    private final MetaCache<IdGenerator> idGeneratorCache = new MetaCache<IdGenerator>(it -> {
        IdGenerator g = IdGenerators.of(this, it.getNamingStrategy());
        return g != null ? g : NIL_ID_GENERATOR;
    });

    ImmutableTypeImpl(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        Annotation sqlAnnotation = null;
        for (Class<? extends Annotation> sqlAnnotationType : SQL_ANNOTATION_TYPES) {
            Annotation anno = javaClass.getAnnotation(sqlAnnotationType);
            if (anno == null) continue;
            if (sqlAnnotation != null) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", it cannot be decorated by both @" + sqlAnnotation.annotationType().getName() + " and @" + anno.annotationType().getName());
            }
            sqlAnnotation = anno;
        }
        if (sqlAnnotation != null) {
            this.immutableAnnotation = sqlAnnotation;
        } else {
            this.immutableAnnotation = javaClass.getAnnotation(Immutable.class);
            if (this.immutableAnnotation == null) {
                throw new ModelException("Illegal type \"" + javaClass.getName() + "\", it is not immutable type");
            }
        }
        this.javaClass = javaClass;
        this.superType = superType;
        this.draftFactory = draftFactory;
        this.isEntity = this.immutableAnnotation instanceof Entity;
        this.isMappedSupperClass = this.immutableAnnotation instanceof MappedSuperclass;
        this.isEmbeddable = this.immutableAnnotation instanceof Embeddable;
        if (superType != null) {
            if ((this.isEntity || this.isMappedSupperClass) && !superType.isMappedSuperclass()) {
                throw new ModelException("Illegal immutable type \"" + this + "\", the super type \"" + superType + "\" is not decorated by @" + MappedSuperclass.class.getName());
            }
            if ((superType.isEntity() || superType.isMappedSuperclass()) && !this.isEntity && !this.isMappedSupperClass) {
                throw new ModelException("Illegal immutable type \"" + this + "\", it has super type because it is decorated by neither @" + Entity.class.getName() + " nor @" + MappedSuperclass.class.getName());
            }
        }
        this.microServiceName = this.isEntity ? javaClass.getAnnotation(Entity.class).microServiceName() : (this.isMappedSupperClass ? javaClass.getAnnotation(MappedSuperclass.class).microServiceName() : "");
    }

    ImmutableTypeImpl(KClass<?> kotlinClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
        this(((ClassBasedDeclarationContainer)kotlinClass).getJClass(), superType, draftFactory);
        this.kotlinClass = kotlinClass;
    }

    @Override
    @NotNull
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isKotlinClass() {
        return this.kotlinClass != null;
    }

    @Override
    public boolean isEntity() {
        return this.isEntity;
    }

    @Override
    public boolean isMappedSuperclass() {
        return this.isMappedSupperClass;
    }

    @Override
    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    @Override
    @NotNull
    public Annotation getImmutableAnnotation() {
        return this.immutableAnnotation;
    }

    @Nullable
    KClass<?> getKotlinClass() {
        return this.kotlinClass;
    }

    @Override
    public boolean isAssignableFrom(ImmutableType type) {
        return this.javaClass.isAssignableFrom(type.getJavaClass());
    }

    @Override
    @Nullable
    public ImmutableType getSuperType() {
        return this.superType;
    }

    @Override
    @NotNull
    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        return this.draftFactory;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.declaredProps;
    }

    @Override
    public ImmutableProp getIdProp() {
        return this.idProp;
    }

    @Override
    @Nullable
    public ImmutableProp getVersionProp() {
        return this.versionProp;
    }

    @Override
    @Nullable
    public LogicalDeletedInfo getDeclaredLogicalDeletedInfo() {
        return this.declaredLogicalDeletedInfo;
    }

    @Override
    @Nullable
    public LogicalDeletedInfo getLogicalDeletedInfo() {
        return this.logicalDeletedInfo;
    }

    @Override
    @NotNull
    public Set<ImmutableProp> getKeyProps() {
        return this.keyProps;
    }

    @Override
    @NotNull
    public Map<String, ImmutableProp> getProps() {
        Map<String, ImmutableProp> props = this.props;
        if (props == null) {
            if (this.superType == null) {
                props = this.declaredProps;
            } else {
                props = new LinkedHashMap<String, ImmutableProp>(this.superType.getProps());
                for (ImmutableProp declaredProp : this.declaredProps.values()) {
                    ImmutableProp conflictProp = props.put(declaredProp.getName(), declaredProp);
                    if (conflictProp == null || conflictProp == ((ImmutablePropImpl)declaredProp).getOriginal()) continue;
                    throw new ModelException("The property \"" + declaredProp + "\" overrides property of super type, this is not allowed");
                }
            }
            this.props = Collections.unmodifiableMap(props);
        }
        return props;
    }

    @Override
    @NotNull
    public ImmutableProp getProp(String name) {
        ImmutableProp prop = this.getProps().get(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property \"" + name + "\" in \"" + this + "\"");
        }
        return prop;
    }

    @Override
    @NotNull
    public ImmutableProp getProp(int id) {
        ImmutableProp[] arr = this.getPropArr();
        if (id < 1 || id >= arr.length) {
            throw new IllegalArgumentException("There is no property whose id is " + id + " in \"" + this + "\"");
        }
        return arr[id];
    }

    @NotNull
    private ImmutableProp[] getPropArr() {
        ImmutableProp[] arr = this.propArr;
        if (arr == null) {
            arr = new ImmutableProp[this.getProps().size() + 1];
            Iterator<ImmutableProp> iterator = this.getProps().values().iterator();
            while (iterator.hasNext()) {
                ImmutableProp prop;
                arr[prop.getId()] = prop = iterator.next();
            }
            this.propArr = arr;
        }
        return arr;
    }

    @Override
    public Map<String, ImmutableProp> getSelectableProps() {
        Map<String, ImmutableProp> map = this.selectableProps;
        if (map == null) {
            map = new LinkedHashMap<String, ImmutableProp>();
            map.put(this.idProp.getName(), this.idProp);
            for (ImmutableProp prop : this.getProps().values()) {
                if (prop.isId() || !prop.isColumnDefinition()) continue;
                map.put(prop.getName(), prop);
            }
            this.selectableProps = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    @Override
    public Map<String, ImmutableProp> getSelectableReferenceProps() {
        Map<String, ImmutableProp> map = this.selectableReferenceProps;
        if (map == null) {
            map = new LinkedHashMap<String, ImmutableProp>();
            for (ImmutableProp prop : this.getProps().values()) {
                if (!prop.isReference(TargetLevel.PERSISTENT) || !prop.isColumnDefinition()) continue;
                map.put(prop.getName(), prop);
            }
            this.selectableReferenceProps = map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    void setDeclaredProps(Map<String, ImmutableProp> map) {
        this.declaredProps = Collections.unmodifiableMap(map);
    }

    void setIdProp(ImmutableProp idProp) {
        if (idProp.getDeclaringType() != this) {
            idProp = this.getProp(idProp.getName());
        }
        if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
            this.validateEmbeddedIdType(idProp.getTargetType(), null);
        }
        this.idProp = idProp;
    }

    void setVersionProp(ImmutableProp versionProp) {
        if (versionProp != null && versionProp.getDeclaringType() != this) {
            versionProp = this.getProp(versionProp.getName());
        }
        this.versionProp = versionProp;
    }

    void setDeclaredLogicalDeletedInfo(LogicalDeletedInfo declaredLogicalDeletedInfo) {
        LogicalDeletedInfo superInfo;
        LogicalDeletedInfo logicalDeletedInfo = superInfo = this.superType != null ? this.superType.getLogicalDeletedInfo() : null;
        if (superInfo != null && declaredLogicalDeletedInfo != null) {
            throw new AssertionError((Object)("Internal bug, @LogicalDeleted field is configured in both \"" + this + "\" and its super type"));
        }
        this.declaredLogicalDeletedInfo = declaredLogicalDeletedInfo;
        this.logicalDeletedInfo = superInfo != null ? superInfo.to(new ImmutablePropImpl(this, (ImmutablePropImpl)superInfo.getProp())) : declaredLogicalDeletedInfo;
    }

    void setKeyProps(Set<ImmutableProp> keyProps) {
        LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
        for (ImmutableProp keyProp : keyProps) {
            if (keyProp.getDeclaringType() != this) {
                keyProp = this.getProp(keyProp.getName());
            }
            set.add(keyProp);
        }
        this.keyProps = Collections.unmodifiableSet(set);
    }

    @Override
    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @Override
    public String getTableName(MetadataStrategy strategy) {
        return this.tableNameCache.get(strategy);
    }

    private String getTableName0(MetadataStrategy strategy) {
        String tableName;
        Table table = this.javaClass.getAnnotation(Table.class);
        String string = tableName = table != null ? table.name() : "";
        if (tableName.isEmpty()) {
            return strategy.getNamingStrategy().tableName(this);
        }
        return tableName;
    }

    @Override
    public IdGenerator getIdGenerator(MetadataStrategy strategy) {
        IdGenerator generator = this.idGeneratorCache.get(strategy);
        return generator == NIL_ID_GENERATOR ? null : generator;
    }

    public String toString() {
        return this.javaClass.getName();
    }

    private void validateEntity() {
        if (!this.isEntity) {
            throw new IllegalStateException("The current type \"" + this + "\" is not entity");
        }
    }

    private void validateEmbeddedIdType(ImmutableType type, String path) {
        String prefix = path != null ? path + '.' : "";
        for (ImmutableProp prop : type.getProps().values()) {
            if (prop.isNullable()) {
                throw new ModelException("Illegal id property \"" + this + "\", the embedded property \"" + prefix + prop.getName() + "\" cannot be nullable");
            }
            if (!prop.isEmbedded(EmbeddedLevel.SCALAR)) continue;
            this.validateEmbeddedIdType(prop.getTargetType(), prefix + prop.getName());
        }
    }

    private static class PropBuilder {
        final int id;
        final String name;
        final ImmutablePropCategory category;
        final Class<?> elementType;
        final boolean nullable;
        final Class<? extends Annotation> associationType;

        private PropBuilder(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            this.id = id;
            this.name = name;
            this.category = category;
            this.elementType = elementType;
            this.nullable = nullable;
            this.associationType = associationType;
        }

        public ImmutableProp build(ImmutableTypeImpl declaringType) {
            return new ImmutablePropImpl(declaringType, this.id, this.name, this.category, this.elementType, this.nullable, this.associationType);
        }
    }

    public static class BuilderImpl
    implements ImmutableType.Builder {
        private final KClass<?> kotlinType;
        private final Class<?> javaClass;
        private final ImmutableType superType;
        private final BiFunction<DraftContext, Object, Draft> draftFactory;
        private String idPropName;
        private String versionPropName;
        private String logicalDeletedPropName;
        private final List<String> keyPropNames = new ArrayList<String>();
        private final Set<Integer> propIds;
        private final Map<String, PropBuilder> propBuilderMap = new LinkedHashMap<String, PropBuilder>();

        BuilderImpl(Class<?> javaClass, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.kotlinType = null;
            this.javaClass = javaClass;
            this.superType = superType;
            this.draftFactory = draftFactory;
            this.propIds = superType != null ? superType.getProps().values().stream().map(ImmutableProp::getId).collect(Collectors.toSet()) : new HashSet<Integer>();
        }

        BuilderImpl(KClass<?> kotlinType, ImmutableType superType, BiFunction<DraftContext, Object, Draft> draftFactory) {
            this.kotlinType = kotlinType;
            this.javaClass = ((ClassBasedDeclarationContainer)kotlinType).getJClass();
            this.superType = superType;
            this.draftFactory = draftFactory;
            this.propIds = superType != null ? superType.getProps().values().stream().map(ImmutableProp::getId).collect(Collectors.toSet()) : new HashSet<Integer>();
        }

        @Override
        public ImmutableType.Builder id(int id, String name, Class<?> elementType) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set id property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            if (this.superType != null && this.superType.getIdProp() != null) {
                throw new IllegalStateException("Cannot set id property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + this.superType.getJavaClass().getName() + "\"");
            }
            if (this.idPropName != null) {
                throw new IllegalStateException("Conflict id properties \"" + this.idPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.idPropName = name;
            return this.add(id, name, BuilderImpl.category(elementType), elementType, false);
        }

        @Override
        public ImmutableType.Builder key(int id, String name, Class<?> elementType, boolean nullable) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set key property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            this.keyPropNames.add(name);
            return this.add(id, name, BuilderImpl.category(elementType), elementType, nullable);
        }

        @Override
        public ImmutableType.Builder keyReference(int id, String name, Class<? extends Annotation> associationAnnotationType, Class<?> elementType, boolean nullable) {
            if (associationAnnotationType != OneToOne.class && associationAnnotationType != ManyToOne.class) {
                throw new IllegalArgumentException("The `associationAnnotationType` must be `OneOne` or `ManyToOne`");
            }
            this.keyPropNames.add(name);
            return this.add(id, name, ImmutablePropCategory.REFERENCE, elementType, nullable, associationAnnotationType);
        }

        @Override
        public ImmutableType.Builder version(int id, String name) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set version property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            if (this.superType != null && this.superType.getVersionProp() != null) {
                throw new IllegalStateException("Cannot set version property for type \"" + this.javaClass.getName() + "\" because there is an version property in the super type \"" + this.superType.getJavaClass().getName() + "\"");
            }
            if (this.versionPropName != null) {
                throw new IllegalStateException("Conflict version properties \"" + this.versionPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.versionPropName = name;
            return this.add(id, name, ImmutablePropCategory.SCALAR, Integer.TYPE, false);
        }

        @Override
        public ImmutableType.Builder logicalDeleted(int id, String name, Class<?> elementType, boolean nullable) {
            if (!this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set logical deleted property for type \"" + this.javaClass.getName() + "\" which is not entity or mapped super class");
            }
            if (this.superType != null && this.superType.getLogicalDeletedInfo() != null) {
                throw new IllegalStateException("Cannot set logical deleted property for type \"" + this.javaClass.getName() + "\" because there is an id property in the super type \"" + this.superType.getJavaClass().getName() + "\"");
            }
            if (this.logicalDeletedPropName != null) {
                throw new IllegalStateException("Conflict logical deleted properties \"" + this.logicalDeletedPropName + "\" and \"" + name + "\" in \"" + this.javaClass.getName() + "\"");
            }
            this.logicalDeletedPropName = name;
            return this.add(id, name, ImmutablePropCategory.SCALAR, elementType, nullable);
        }

        @Override
        public ImmutableType.Builder add(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable) {
            return this.add(id, name, category, elementType, nullable, null);
        }

        @Override
        public ImmutableType.Builder add(int id, String name, Class<? extends Annotation> associationType, Class<?> elementType, boolean nullable) {
            ImmutablePropCategory category;
            if (associationType == OneToOne.class || associationType == ManyToOne.class) {
                category = ImmutablePropCategory.REFERENCE;
            } else if (associationType == OneToMany.class || associationType == ManyToMany.class || associationType == ManyToManyView.class) {
                category = ImmutablePropCategory.REFERENCE_LIST;
            } else {
                throw new IllegalArgumentException("Invalid association type");
            }
            return this.add(id, name, category, elementType, nullable, associationType);
        }

        private ImmutableType.Builder add(int id, String name, ImmutablePropCategory category, Class<?> elementType, boolean nullable, Class<? extends Annotation> associationType) {
            if (category.isAssociation() && elementType.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(Entity.class) && !this.javaClass.isAnnotationPresent(MappedSuperclass.class)) {
                throw new IllegalStateException("Cannot set association for type that is not entity or mapped super class");
            }
            if (!this.propIds.add(id)) {
                throw new IllegalArgumentException("The property id \"" + id + "." + name + "\" is already exists in current type or the super type");
            }
            if (this.propBuilderMap.containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.javaClass.getName() + "." + name + "\", it is already exists");
            }
            if (this.superType != null && this.superType.getProps().containsKey(name)) {
                throw new IllegalArgumentException("The property \"" + this.javaClass.getName() + "." + name + "\" is already exists in super type");
            }
            this.propBuilderMap.put(name, new PropBuilder(id, name, category, elementType, nullable, associationType));
            return this;
        }

        private static ImmutablePropCategory category(Class<?> elementType) {
            return elementType.isAnnotationPresent(Embeddable.class) ? ImmutablePropCategory.REFERENCE : ImmutablePropCategory.SCALAR;
        }

        @Override
        public ImmutableTypeImpl build() {
            ImmutableProp superIdProp;
            ImmutableTypeImpl type = this.kotlinType != null ? new ImmutableTypeImpl(this.kotlinType, this.superType, this.draftFactory) : new ImmutableTypeImpl(this.javaClass, this.superType, this.draftFactory);
            LinkedHashMap<String, ImmutableProp> map = new LinkedHashMap<String, ImmutableProp>();
            if (this.superType != null && !this.superType.isEntity() && this.javaClass.isAnnotationPresent(Entity.class)) {
                for (ImmutableProp prop : this.superType.getProps().values()) {
                    map.put(prop.getName(), new ImmutablePropImpl(type, (ImmutablePropImpl)prop));
                }
            }
            for (Map.Entry<String, PropBuilder> e : this.propBuilderMap.entrySet()) {
                map.put(e.getKey(), e.getValue().build(type));
            }
            type.setDeclaredProps(map);
            if (this.idPropName != null) {
                type.setIdProp((ImmutableProp)type.declaredProps.get(this.idPropName));
            } else if (type.superType != null && (superIdProp = type.superType.getIdProp()) != null) {
                type.setIdProp(superIdProp);
            }
            if (this.versionPropName != null) {
                type.setVersionProp((ImmutableProp)type.declaredProps.get(this.versionPropName));
            } else if (type.superType != null) {
                type.setVersionProp(type.superType.getVersionProp());
            }
            if (this.logicalDeletedPropName != null) {
                type.setDeclaredLogicalDeletedInfo(LogicalDeletedInfo.of((ImmutableProp)type.declaredProps.get(this.logicalDeletedPropName)));
            } else {
                type.setDeclaredLogicalDeletedInfo(null);
            }
            LinkedHashSet<ImmutableProp> keyProps = type.superType != null ? new LinkedHashSet<ImmutableProp>(type.superType.getKeyProps()) : new LinkedHashSet();
            for (String keyPropName : this.keyPropNames) {
                keyProps.add((ImmutableProp)type.declaredProps.get(keyPropName));
            }
            type.setKeyProps(keyProps);
            return type;
        }
    }
}

