/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.jetbrains.annotations.NotNull;

public class ManyToManyViewList<M, E>
implements List<E> {
    private final int deeperPropId;
    private final List<M> middleList;

    public ManyToManyViewList(int deeperPropId, List<M> middleList) {
        this.deeperPropId = deeperPropId;
        this.middleList = middleList;
    }

    @Override
    public boolean isEmpty() {
        return this.middleList.isEmpty();
    }

    @Override
    public int size() {
        return this.middleList.size();
    }

    @Override
    public boolean contains(Object o) {
        for (M middle : this.middleList) {
            if (!this.toElement(middle).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object target : c) {
            if (this.contains(target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<M> itr = this.middleList.listIterator(0);
        while (itr.hasNext()) {
            if (!itr.next().equals(o)) continue;
            return itr.nextIndex() - 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator<M> itr = this.middleList.listIterator(this.middleList.size());
        while (itr.hasPrevious()) {
            if (!itr.previous().equals(o)) continue;
            return itr.previousIndex() + 1;
        }
        return -1;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] arr = new Object[this.middleList.size()];
        int index = 0;
        for (M middle : this.middleList) {
            arr[index++] = this.toElement(middle);
        }
        return arr;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        int size = this.middleList.size();
        if (size > a.length) {
            a = new Object[size];
        }
        int index = 0;
        for (M middle : this.middleList) {
            a[index++] = this.toElement(middle);
        }
        return a;
    }

    @Override
    public E get(int index) {
        return this.toElement(this.middleList.get(index));
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        return new ManyToManyViewList<M, E>(this.deeperPropId, this.middleList.subList(fromIndex, toIndex));
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Itr(this.middleList.listIterator(0));
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return new Itr(this.middleList.listIterator(0));
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return new Itr(this.middleList.listIterator(index));
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (M middle : this.middleList) {
            hashCode = 31 * hashCode + this.toElement(middle).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (this.middleList.size() != ((List)o).size()) {
            return false;
        }
        Iterator<M> middleItr = this.middleList.iterator();
        Iterator otherItr = ((List)o).iterator();
        while (middleItr.hasNext() && otherItr.hasNext()) {
            if (this.toElement(middleItr.next()).equals(otherItr.next())) continue;
            return false;
        }
        return !middleItr.hasNext() && !otherItr.hasNext();
    }

    public String toString() {
        Iterator<M> itr = this.middleList.iterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            M middle = itr.next();
            sb.append(this.toElement(middle));
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private E toElement(M middle) {
        return (E)((ImmutableSpi)middle).__get(this.deeperPropId);
    }

    @Override
    @Deprecated
    public boolean add(E e) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public E remove(int index) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    @Deprecated
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException("The current list is immutable");
    }

    private class Itr
    implements ListIterator<E> {
        private final ListIterator<M> itr;

        private Itr(ListIterator<M> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public E next() {
            return ManyToManyViewList.this.toElement(this.itr.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public E previous() {
            return ManyToManyViewList.this.toElement(this.itr.previous());
        }

        @Override
        public int nextIndex() {
            return this.itr.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.itr.previousIndex();
        }

        @Override
        @Deprecated
        public void remove() {
            throw new UnsupportedOperationException("The current list is immutable");
        }

        @Override
        @Deprecated
        public void set(E e) {
            throw new UnsupportedOperationException("The current list is immutable");
        }

        @Override
        @Deprecated
        public void add(E e) {
            throw new UnsupportedOperationException("The current list is immutable");
        }
    }
}

