/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class SqlTemplate {
    private final List<Object> parts;
    private final int charCount;
    private final Map<Placeholder, Integer> placeholderCountMap;

    protected SqlTemplate(List<Object> parts) {
        this.parts = parts;
        this.charCount = parts.stream().mapToInt(it -> it instanceof String ? ((String)it).length() : 0).sum();
        HashMap<Placeholder, Integer> map = new HashMap<Placeholder, Integer>();
        for (Object o : parts) {
            Placeholder placeholder;
            if (!(o instanceof Placeholder)) continue;
            Integer count = (Integer)map.get(placeholder = (Placeholder)o);
            map.put(placeholder, count != null ? count + 1 : 1);
        }
        this.placeholderCountMap = map;
    }

    protected static <T extends SqlTemplate> T create(String sql, Collection<Placeholder> placeholders, Function<List<Object>, T> constructor) {
        SqlTemplate template;
        if (sql.isEmpty()) {
            throw new IllegalArgumentException("Empty sql");
        }
        ArrayList<Object> parts = new ArrayList<Object>();
        StringBuilder partBuilder = new StringBuilder();
        boolean inStr = false;
        int parenthesesDepth = 0;
        int size = sql.length();
        for (int i = 0; i < size; ++i) {
            char c = sql.charAt(i);
            if (c == '\'') {
                boolean bl = inStr = !inStr;
            }
            if (inStr) {
                partBuilder.append(c);
                continue;
            }
            if (c == '%') {
                boolean foundPlaceHolder = false;
                for (Placeholder placeHolder : placeholders) {
                    String word;
                    char end;
                    boolean expectedEnd;
                    int holderLen = placeHolder.name.length();
                    if (i + holderLen + 1 > size || !(expectedEnd = i + holderLen + 1 < size ? (end = sql.charAt(i + holderLen + 1)) != '_' && end != '$' && !Character.isLetter(end) && !Character.isDigit(c) : true) || !(word = sql.substring(i + 1, i + holderLen + 1)).equals(placeHolder.name)) continue;
                    String part = partBuilder.toString();
                    if (!part.isEmpty()) {
                        parts.add(part);
                        partBuilder = new StringBuilder();
                    }
                    parts.add(placeHolder);
                    i += holderLen;
                    foundPlaceHolder = true;
                    break;
                }
                if (foundPlaceHolder) continue;
            }
            switch (c) {
                case '(': {
                    ++parenthesesDepth;
                    break;
                }
                case ')': {
                    --parenthesesDepth;
                    break;
                }
                case ' ': 
                case ',': {
                    if (parenthesesDepth != 0) break;
                    throw new IllegalArgumentException("Unexpected character '" + c + "' the formula sql \"" + sql + "\"");
                }
            }
            partBuilder.append(c);
        }
        String part = partBuilder.toString();
        if (!part.isEmpty()) {
            parts.add(part);
        }
        SqlTemplate sqlTemplate = template = (SqlTemplate)constructor.apply(parts);
        for (Placeholder placeholder : placeholders) {
            if (sqlTemplate.placeholderCountMap.containsKey(placeholder)) continue;
            throw new IllegalArgumentException("The placeholder \"%" + placeholder.name + "\" is missing");
        }
        return (T)template;
    }

    public String toSql(Map<Placeholder, String> placeHolderValues) {
        int capacity = this.charCount;
        for (Map.Entry<Placeholder, Integer> e : this.placeholderCountMap.entrySet()) {
            String value = placeHolderValues.get(e.getKey());
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("The value of placeholder \"%" + e.getKey() + "\" is not specified");
            }
            capacity += value.length() * e.getValue();
        }
        StringBuilder builder = new StringBuilder(capacity);
        for (Object part : this.parts) {
            if (part instanceof String) {
                builder.append(part);
                continue;
            }
            builder.append(placeHolderValues.get((Placeholder)part));
        }
        return builder.toString();
    }

    protected static class Placeholder {
        final String name;

        public Placeholder(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Placeholder)) {
                return false;
            }
            Placeholder that = (Placeholder)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "PlaceHolder{name='" + this.name + '\'' + '}';
        }
    }
}

