/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.meta.impl.EmbeddedTree;
import org.babyfish.jimmer.sql.Column;
import org.babyfish.jimmer.sql.JoinColumn;
import org.babyfish.jimmer.sql.JoinColumns;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;

public class Storages {
    static Storage of(ImmutableProp prop) {
        if (prop.isTransient() || prop.isFormula() || !prop.getDependencies().isEmpty() || prop.getDeclaringType().isEmbeddable() || prop.getSqlTemplate() instanceof JoinTemplate) {
            return null;
        }
        Annotation annotation = prop.getAssociationAnnotation();
        if (annotation instanceof OneToOne && !((OneToOne)annotation).mappedBy().isEmpty() || annotation instanceof OneToMany || annotation instanceof ManyToMany && !((ManyToMany)annotation).mappedBy().isEmpty()) {
            return null;
        }
        if (annotation == null) {
            String columnName;
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                return new EmbeddedTree(prop).toEmbeddedColumns();
            }
            Column column = prop.getAnnotation(Column.class);
            String string = columnName = column != null ? column.name() : "";
            if (columnName.isEmpty()) {
                columnName = DatabaseIdentifiers.databaseIdentifier(prop.getName());
            }
            return new SingleColumn(columnName, false);
        }
        Storage storage = Storages.middleTable(prop, false);
        if (storage == null) {
            storage = Storages.joinColumn(prop, false);
        }
        if (storage == null) {
            storage = prop.getAssociationAnnotation() instanceof ManyToMany ? Storages.middleTable(prop, true) : Storages.joinColumn(prop, true);
        }
        return storage;
    }

    private static ColumnDefinition joinColumn(ImmutableProp prop, boolean force) {
        ColumnDefinition definition;
        JoinColumn joinColumn = prop.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = prop.getAnnotation(JoinColumns.class);
        if (joinColumn == null && joinColumns == null && !force) {
            return null;
        }
        JoinColumnObj[] columns = joinColumns != null ? JoinColumnObj.array(joinColumns.value()) : JoinColumnObj.array(joinColumn);
        try {
            definition = Storages.joinDefinition(columns, prop.getTargetType(), prop.isEmbedded(EmbeddedLevel.REFERENCE));
        }
        catch (IllegalJoinColumnCount ex) {
            throw new ModelException("Illegal property \"" + prop + "\", it has " + ex.actual + " join column(s), but the referenced property \"" + prop.getTargetType().getIdProp() + "\" has " + ex.expect + " join column(s)");
        }
        catch (NoReference ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` of join columns must be set when multiple join columns are used");
        }
        catch (ReferenceNothing ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` \"" + ex.ref + "\" is illegal");
        }
        catch (SourceConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict column name \"" + ex.name + "\" in several join columns");
        }
        catch (TargetConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict referenced column name \"" + ex.ref + "\" in several join columns");
        }
        catch (ForeignKeyConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict columns \"" + ex.columnName1 + "\" and \"" + ex.columnName2 + "\", their attribute `foreignKey` is different");
        }
        if (definition != null) {
            return definition;
        }
        return new SingleColumn(DatabaseIdentifiers.databaseIdentifier(prop.getName()) + "_ID", true);
    }

    private static MiddleTable middleTable(ImmutableProp prop, boolean force) {
        String tableName;
        ColumnDefinition targetDefinition;
        ColumnDefinition definition;
        JoinColumnObj[] referencedColumns;
        JoinColumnObj[] joinColumns;
        JoinTable joinTable = prop.getAnnotation(JoinTable.class);
        if (joinTable == null && !force) {
            return null;
        }
        if (joinTable != null) {
            if (!joinTable.joinColumnName().isEmpty() && joinTable.joinColumns().length != 0) {
                throw new ModelException("Illegal property \"" + prop + "\", `joinColumnName` and `joinColumns` of `@" + JoinTable.class.getName() + "` cannot be specified at the same time");
            }
            if (!joinTable.inverseJoinColumnName().isEmpty() && joinTable.inverseColumns().length != 0) {
                throw new ModelException("Illegal property \"" + prop + "\", `inverseJoinColumnName` and `inverseColumns` of `@" + JoinTable.class.getName() + "` cannot be specified at the same time");
            }
            joinColumns = JoinColumnObj.array(joinTable.joinColumnName());
            if (joinColumns == null) {
                joinColumns = JoinColumnObj.array(joinTable.joinColumns());
            }
            if ((referencedColumns = JoinColumnObj.array(joinTable.inverseJoinColumnName())) == null) {
                referencedColumns = JoinColumnObj.array(joinTable.inverseColumns());
            }
        } else {
            joinColumns = null;
            referencedColumns = null;
        }
        boolean leftParsed = false;
        try {
            definition = Storages.joinDefinition(joinColumns, prop.getDeclaringType(), prop.getDeclaringType().getIdProp().isEmbedded(EmbeddedLevel.SCALAR));
            leftParsed = true;
            targetDefinition = Storages.joinDefinition(referencedColumns, prop.getTargetType(), prop.getTargetType().getIdProp().isEmbedded(EmbeddedLevel.SCALAR));
        }
        catch (IllegalJoinColumnCount ex) {
            throw new ModelException("Illegal property \"" + prop + "\", there are " + ex.actual + " `" + (leftParsed ? "inverseColumn(s)" : "joinColumn(s)") + "`, but the id property \"" + (leftParsed ? prop.getTargetType() : prop.getDeclaringType()).getIdProp() + "\" has " + ex.expect + " column(s)");
        }
        catch (NoReference ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumns` of `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` must be specified when multiple `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` are used");
        }
        catch (ReferenceNothing ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` \"" + ex.ref + "\" of `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` is illegal");
        }
        catch (SourceConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict column name \"" + ex.name + "\" in several " + (leftParsed ? "inverseColumns" : "joinColumns"));
        }
        catch (TargetConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict referenced column name \"" + ex.ref + "\" in several " + (leftParsed ? "inverseColumns" : "joinColumns"));
        }
        catch (ForeignKeyConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict columns \"" + ex.columnName1 + "\" and \"" + ex.columnName2 + "\" in " + (leftParsed ? "inverseColumns" : "joinColumns") + ", their attribute `foreignKey` is different");
        }
        String string = tableName = joinTable != null ? joinTable.name() : "";
        if (tableName.isEmpty()) {
            tableName = DatabaseIdentifiers.databaseIdentifier(prop.getDeclaringType().getJavaClass().getSimpleName()) + '_' + DatabaseIdentifiers.databaseIdentifier(prop.getElementClass().getSimpleName()) + "_MAPPING";
        }
        if (definition == null) {
            definition = new SingleColumn(DatabaseIdentifiers.databaseIdentifier(prop.getDeclaringType().getJavaClass().getSimpleName()) + "_ID", true);
        }
        if (targetDefinition == null) {
            targetDefinition = new SingleColumn(DatabaseIdentifiers.databaseIdentifier(prop.getTargetType().getJavaClass().getSimpleName()) + "_ID", true);
        }
        return new MiddleTable(tableName, definition, targetDefinition);
    }

    private static ColumnDefinition joinDefinition(JoinColumnObj[] joinColumns, ImmutableType targetType, boolean isEmbedded) throws IllegalJoinColumnCount, NoReference, ReferenceNothing, TargetConflict, SourceConflict, ForeignKeyConflict {
        if (joinColumns == null || joinColumns.length == 0) {
            ColumnDefinition definition = (ColumnDefinition)targetType.getIdProp().getStorage();
            if (definition.size() == 1) {
                return null;
            }
            throw new IllegalJoinColumnCount(definition.size(), 0);
        }
        JoinColumnObj firstJoinColumn = null;
        for (JoinColumnObj joinColumn : joinColumns) {
            if (firstJoinColumn == null) {
                firstJoinColumn = joinColumn;
                continue;
            }
            if (firstJoinColumn.foreignKey == joinColumn.foreignKey) continue;
            throw new ForeignKeyConflict(firstJoinColumn.name, joinColumn.name);
        }
        ColumnDefinition targetIdDefinition = (ColumnDefinition)targetType.getIdProp().getStorage();
        if (joinColumns.length != targetIdDefinition.size()) {
            throw new IllegalJoinColumnCount(targetIdDefinition.size(), joinColumns.length);
        }
        if (joinColumns.length == 1) {
            if (joinColumns[0].name.isEmpty()) {
                return null;
            }
            String ref = joinColumns[0].referencedColumnName;
            if (!ref.isEmpty() && !ref.equals(targetIdDefinition.name(0))) {
                throw new ReferenceNothing(ref);
            }
            return new SingleColumn(joinColumns[0].name, joinColumns[0].foreignKey);
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (JoinColumnObj joinColumn : joinColumns) {
            String ref = joinColumn.referencedColumnName;
            if (ref.isEmpty()) {
                throw new NoReference();
            }
            if (targetIdDefinition.index(ref) == -1) {
                throw new ReferenceNothing(ref);
            }
            if (columnMap.put(ref, joinColumn.name) == null) continue;
            throw new TargetConflict(ref);
        }
        LinkedHashMap<String, String> referencedColumnMap = new LinkedHashMap<String, String>();
        for (String targetColumnName : targetIdDefinition) {
            String name = (String)columnMap.get(targetColumnName);
            if (referencedColumnMap.put(name, targetColumnName) == null) continue;
            throw new SourceConflict(name);
        }
        return new MultipleJoinColumns(referencedColumnMap, isEmbedded, joinColumns[0].foreignKey);
    }

    private static class JoinColumnObj {
        final String name;
        final String referencedColumnName;
        final boolean foreignKey;

        JoinColumnObj(String name, String referencedColumnName, boolean foreignKey) {
            this.name = name;
            this.referencedColumnName = referencedColumnName;
            this.foreignKey = foreignKey;
        }

        JoinColumnObj(JoinColumn joinColumn) {
            this.name = joinColumn.name();
            this.referencedColumnName = joinColumn.referencedColumnName();
            this.foreignKey = joinColumn.foreignKey();
        }

        static JoinColumnObj[] array(String name) {
            if (name.isEmpty()) {
                return null;
            }
            return new JoinColumnObj[]{new JoinColumnObj(name, "", true)};
        }

        static JoinColumnObj[] array(JoinColumn joinColumn) {
            if (joinColumn == null) {
                return null;
            }
            return new JoinColumnObj[]{new JoinColumnObj(joinColumn.name(), joinColumn.referencedColumnName(), joinColumn.foreignKey())};
        }

        static JoinColumnObj[] array(JoinColumn[] arr) {
            if (arr.length == 0) {
                return null;
            }
            return (JoinColumnObj[])Arrays.stream(arr).map(JoinColumnObj::new).toArray(JoinColumnObj[]::new);
        }
    }

    private static class IllegalJoinColumnCount
    extends Exception {
        final int expect;
        final int actual;

        private IllegalJoinColumnCount(int expect, int actual) {
            this.expect = expect;
            this.actual = actual;
        }
    }

    private static class NoReference
    extends Exception {
        private NoReference() {
        }
    }

    private static class ReferenceNothing
    extends Exception {
        final String ref;

        ReferenceNothing(String ref) {
            this.ref = ref;
        }
    }

    private static class SourceConflict
    extends Exception {
        final String name;

        SourceConflict(String name) {
            this.name = name;
        }
    }

    private static class TargetConflict
    extends Exception {
        final String ref;

        TargetConflict(String ref) {
            this.ref = ref;
        }
    }

    private static class ForeignKeyConflict
    extends Exception {
        final String columnName1;
        final String columnName2;

        private ForeignKeyConflict(String columnName1, String columnName2) {
            this.columnName1 = columnName1;
            this.columnName2 = columnName2;
        }
    }
}

