/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import java.io.IOException;
import org.babyfish.jimmer.jackson.PropUtils;
import org.babyfish.jimmer.jackson.meta.BeanProps;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class ImmutableSerializer
extends StdSerializer<ImmutableSpi> {
    private final ImmutableType immutableType;

    public ImmutableSerializer(ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.immutableType = immutableType;
    }

    public void serialize(ImmutableSpi value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        this.serializeFields(value, gen, provider);
        gen.writeEndObject();
    }

    public void serializeWithType(ImmutableSpi value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.START_OBJECT));
        this.serializeFields(value, gen, serializers);
        gen.writeEndObject();
    }

    private void serializeFields(ImmutableSpi immutable, JsonGenerator gen, SerializerProvider provider) throws IOException {
        for (ImmutableProp prop : this.immutableType.getProps().values()) {
            JsonIgnore ignore = prop.getAnnotation(JsonIgnore.class);
            if (ignore != null && ignore.value() || !immutable.__isLoaded(prop.getId()) || !immutable.__isVisible(prop.getId())) continue;
            Object value = immutable.__get(prop.getId());
            if (value != null && prop.getConverter() != null) {
                value = prop.getConverter().output(value);
            }
            if (value == null) {
                provider.defaultSerializeField(prop.getName(), null, gen);
                continue;
            }
            if (prop.isAssociation(TargetLevel.OBJECT) || prop.isScalarList()) {
                TypeSerializer typeSer = null;
                gen.writeFieldName(prop.getName());
                if (!prop.isReferenceList(TargetLevel.OBJECT) && value instanceof ImmutableSpi && ((ImmutableSpi)value).__type() != this.immutableType) {
                    typeSer = provider.findTypeSerializer(PropUtils.getJacksonType(prop));
                }
                if (typeSer != null) {
                    provider.findValueSerializer(value.getClass()).serializeWithType(value, gen, provider, typeSer);
                    continue;
                }
                provider.findValueSerializer(PropUtils.getJacksonType(prop)).serialize(value, gen, provider);
                continue;
            }
            gen.writeFieldName(prop.getName());
            JsonSerializer serializer = provider.findTypedValueSerializer(prop.getElementClass(), true, (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            if (serializer instanceof DateSerializer) {
                serializer = ((DateSerializer)serializer).createContextual(provider, (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            } else if (serializer instanceof LocalDateSerializer) {
                serializer = ((LocalDateSerializer)serializer).createContextual(provider, (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            } else if (serializer instanceof LocalDateTimeSerializer) {
                serializer = ((LocalDateTimeSerializer)serializer).createContextual(provider, (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            } else if (serializer instanceof OffsetDateTimeSerializer) {
                serializer = ((OffsetDateTimeSerializer)serializer).createContextual(provider, (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            } else if (serializer instanceof ZonedDateTimeSerializer) {
                serializer = ((ZonedDateTimeSerializer)serializer).createContextual(provider, (BeanProperty)BeanProps.get(provider.getTypeFactory(), prop));
            }
            serializer.serialize(value, gen, provider);
        }
    }
}

