/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Formula;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.jackson.Converter;
import org.babyfish.jimmer.jackson.JsonConverter;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.ImmutableTypeImpl;
import org.babyfish.jimmer.meta.impl.Metadata;
import org.babyfish.jimmer.meta.impl.Storages;
import org.babyfish.jimmer.meta.spi.EntityPropImplementor;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.IdView;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.OrderedProp;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutablePropImpl
implements ImmutableProp,
EntityPropImplementor {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final ImmutableTypeImpl declaringType;
    private final int id;
    private final String name;
    private final ImmutablePropCategory category;
    private final Class<?> elementClass;
    private final boolean nullable;
    private final boolean inputNotNull;
    private final KProperty1<?, ?> kotlinProp;
    private final Method javaGetter;
    private final Annotation associationAnnotation;
    private final boolean isTransient;
    private final boolean hasTransientResolver;
    private final boolean isFormula;
    private final boolean isIdView;
    private final FormulaTemplate formulaTemplate;
    private final DissociateAction dissociateAction;
    private final ImmutableProp base;
    private Converter<?> converter;
    private boolean converterResolved;
    private Storage storage;
    private boolean storageResolved;
    private ImmutableTypeImpl targetType;
    private boolean targetTypeResolved;
    private List<OrderedItem> orderedItems;
    private ImmutableProp mappedBy;
    private ImmutableProp acceptedMappedBy;
    private boolean mappedByResolved;
    private ImmutableProp opposite;
    private boolean oppositeResolved;
    private List<ImmutableProp> dependencies;

    ImmutablePropImpl(ImmutableTypeImpl declaringType, int id, String name, ImmutablePropCategory category, Class<?> elementClass, boolean nullable, Class<? extends Annotation> associationType) {
        this.declaringType = declaringType;
        this.id = id;
        this.name = name;
        this.category = category;
        this.elementClass = elementClass;
        this.nullable = nullable;
        KClass<?> kotlinClass = declaringType.getKotlinClass();
        this.kotlinProp = kotlinClass != null ? KClasses.getDeclaredMemberProperties(kotlinClass).stream().filter(it -> name.equals(it.getName())).findFirst().get() : null;
        Method javaGetter = null;
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            javaGetter = declaringType.getJavaClass().getDeclaredMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            if (javaGetter.getReturnType() != Boolean.TYPE) {
                javaGetter = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (javaGetter == null) {
            throw new AssertionError((Object)("Internal bug: Cannot find the getter of prop \"" + name + "\" of the interface \"" + declaringType.getJavaClass().getName() + "\""));
        }
        this.javaGetter = javaGetter;
        Transient trans = this.getAnnotation(Transient.class);
        this.isTransient = trans != null;
        this.hasTransientResolver = trans != null && (trans.value() != Void.TYPE || !trans.ref().isEmpty());
        this.associationAnnotation = associationType != null ? this.getAnnotation(associationType) : null;
        Formula formula = this.getAnnotation(Formula.class);
        boolean bl = this.isFormula = formula != null;
        if (formula != null && this.isAssociation(TargetLevel.ENTITY)) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + Formula.class.getName() + "\" so that it cannot be association");
        }
        if (formula != null && !formula.sql().isEmpty()) {
            try {
                this.formulaTemplate = FormulaTemplate.of(formula.sql());
            }
            catch (IllegalArgumentException ex) {
                throw new ModelException("Illegal property \"" + this + "\", the formula sql template: " + ex.getMessage());
            }
        } else {
            this.formulaTemplate = null;
        }
        IdView idView = this.getAnnotation(IdView.class);
        boolean bl2 = this.isIdView = idView != null;
        if (idView != null && this.isAssociation(TargetLevel.ENTITY)) {
            throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" so that it cannot be association");
        }
        ManyToOne manyToOne = this.getAnnotation(ManyToOne.class);
        OneToOne oneToOne = this.getAnnotation(OneToOne.class);
        boolean bl3 = manyToOne != null ? manyToOne.inputNotNull() : (this.inputNotNull = oneToOne != null && oneToOne.inputNotNull());
        if (this.isInputNotNull() && !nullable) {
            throw new ModelException("Illegal property \"" + this + "\", it `inputNotNull` can only be specified for nullable property");
        }
        OnDissociate onDissociate = this.getAnnotation(OnDissociate.class);
        if (onDissociate != null) {
            if (category != ImmutablePropCategory.REFERENCE) {
                throw new ModelException("Illegal property \"" + this + "\", only reference property can be decorated by @OnDissociate");
            }
            if (oneToOne != null && !oneToOne.mappedBy().isEmpty()) {
                throw new ModelException("Illegal property \"" + this + "\", the one-to-one property with `mappedBy` cannot be decorated by @OnDissociate");
            }
            this.dissociateAction = onDissociate.value();
        } else {
            this.dissociateAction = DissociateAction.NONE;
        }
        this.base = null;
    }

    ImmutablePropImpl(ImmutableTypeImpl declaringType, ImmutablePropImpl base) {
        if (!base.getDeclaringType().isAssignableFrom(declaringType)) {
            throw new IllegalArgumentException("The new declaring type \"" + declaringType + "\" is illegal, it is not derived type of original declaring type \"" + base.getDeclaringType() + "\"");
        }
        this.declaringType = declaringType;
        this.id = base.id;
        this.name = base.name;
        this.category = base.category;
        this.elementClass = base.elementClass;
        this.nullable = base.nullable;
        this.inputNotNull = base.inputNotNull;
        this.kotlinProp = base.kotlinProp;
        this.javaGetter = base.javaGetter;
        this.associationAnnotation = base.associationAnnotation;
        this.isTransient = base.isTransient;
        this.isFormula = base.isFormula;
        this.isIdView = base.isIdView;
        this.formulaTemplate = base.formulaTemplate;
        this.hasTransientResolver = base.hasTransientResolver;
        this.dissociateAction = base.dissociateAction;
        this.base = base.base != null ? base.base : base;
    }

    @Override
    @NotNull
    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ImmutablePropCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public boolean isEmbedded(EmbeddedLevel level) {
        ImmutableType targetType = this.getTargetType();
        if (level.hasReference() && this.isReference(TargetLevel.PERSISTENT) && targetType.getIdProp().isEmbedded(EmbeddedLevel.SCALAR)) {
            return true;
        }
        return level.hasScalar() && targetType != null && targetType.isEmbeddable();
    }

    @Override
    public boolean isScalar(TargetLevel level) {
        if (level == TargetLevel.OBJECT) {
            return this.category == ImmutablePropCategory.SCALAR;
        }
        ImmutableType targetType = this.getTargetType();
        return targetType == null || !targetType.isEntity();
    }

    @Override
    public boolean isScalarList() {
        return this.category == ImmutablePropCategory.SCALAR_LIST;
    }

    @Override
    public boolean isAssociation(TargetLevel level) {
        if (!this.category.isAssociation()) {
            return false;
        }
        int ordinal = level.ordinal();
        if (ordinal >= TargetLevel.ENTITY.ordinal() && !this.getTargetType().isEntity()) {
            return false;
        }
        return ordinal < TargetLevel.PERSISTENT.ordinal() || !this.isTransient;
    }

    @Override
    public boolean isReference(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE && this.isAssociation(level);
    }

    @Override
    public boolean isReferenceList(TargetLevel level) {
        return this.category == ImmutablePropCategory.REFERENCE_LIST && this.isAssociation(level);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isInputNotNull() {
        return this.inputNotNull;
    }

    @Override
    public boolean isMutable() {
        return !this.isFormula || this.formulaTemplate != null;
    }

    @Override
    public Method getJavaGetter() {
        return this.javaGetter;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Annotation annotation;
        if (this.kotlinProp != null && (annotation = (Annotation)this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).findFirst().orElse(null)) != null) {
            return (A)annotation;
        }
        return this.javaGetter.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] getterArr = this.javaGetter.getAnnotations();
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = this.kotlinProp.getAnnotations().toArray(EMPTY_ANNOTATIONS);
        }
        if (propArr == null || propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = new Annotation[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
        Annotation[] getterArr = this.javaGetter.getAnnotationsByType(annotationType);
        Annotation[] propArr = null;
        if (this.kotlinProp != null) {
            propArr = (Annotation[])this.kotlinProp.getAnnotations().stream().filter(it -> it.annotationType() == annotationType).toArray();
        }
        if (propArr == null || propArr.length == 0) {
            return getterArr;
        }
        Annotation[] mergedArr = (Annotation[])new Object[propArr.length + getterArr.length];
        System.arraycopy(propArr, 0, mergedArr, 0, propArr.length);
        System.arraycopy(getterArr, 0, mergedArr, propArr.length, getterArr.length);
        return mergedArr;
    }

    @Override
    public Annotation getAssociationAnnotation() {
        return this.associationAnnotation;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean hasTransientResolver() {
        return this.hasTransientResolver;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    @Nullable
    public FormulaTemplate getFormulaTemplate() {
        return this.formulaTemplate;
    }

    @Override
    public boolean isIdView() {
        return this.isIdView;
    }

    @Override
    public Converter<?> getConverter() {
        if (this.converterResolved) {
            return this.converter;
        }
        Class annotationType = null;
        JsonConverter jsonConverter = this.getAnnotation(JsonConverter.class);
        if (jsonConverter != null) {
            annotationType = JsonConverter.class;
        }
        for (Annotation anno : this.getAnnotations()) {
            JsonConverter deepAnno;
            if (anno.annotationType() == JsonConverter.class || (deepAnno = anno.annotationType().getAnnotation(JsonConverter.class)) == null) continue;
            if (annotationType != null) {
                throw new ModelException("Illegal property \"" + this + "\", duplicate converter annotation @" + annotationType.getName() + " and @" + anno.annotationType().getName());
            }
            jsonConverter = deepAnno;
            annotationType = anno.annotationType();
        }
        if (jsonConverter != null) {
            Class<Converter<?>> converterType = jsonConverter.value();
            Collection genericArguments = TypeUtils.getTypeArguments(converterType, Converter.class).values();
            if (genericArguments.isEmpty() || !(genericArguments.iterator().next() instanceof Class)) {
                throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + annotationType.getName() + ", the converter type \"" + converterType.getName() + "\" does not specify the generic parameter of \"" + Converter.class.getName() + "\" as class");
            }
            Class convertedType = (Class)genericArguments.iterator().next();
            if (convertedType != this.javaGetter.getReturnType()) {
                throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + annotationType.getName() + ", the property type \"" + this.javaGetter.getReturnType() + "\" does not match the generic type \"" + convertedType.getName() + "\" of converter type \"" + converterType.getName() + "\"");
            }
            try {
                this.converter = converterType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new ModelException("Illegal property \"" + this + "\", it cannot be decorated by @" + annotationType.getName() + ", cannot create instance for converter type \"" + converterType.getName() + "\"", ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex);
            }
        }
        this.converterResolved = true;
        return this.converter;
    }

    @Override
    @NotNull
    public DissociateAction getDissociateAction() {
        return this.dissociateAction;
    }

    @Override
    public <S extends Storage> S getStorage() {
        if (this.storageResolved) {
            return (S)this.storage;
        }
        this.validateDeclaringEntity("storage");
        this.storage = Storages.of(this);
        this.storageResolved = true;
        return (S)this.storage;
    }

    @Override
    public boolean isId() {
        return this == this.declaringType.getIdProp() || this.base != null && this.base.isId();
    }

    @Override
    public boolean isVersion() {
        return this == this.declaringType.getVersionProp() || this.base != null && this.base.isVersion();
    }

    @Override
    public boolean isLogicalDeleted() {
        LogicalDeletedInfo info = this.declaringType.getLogicalDeletedInfo();
        return info != null && info.getProp() == this || this.base != null && this.base.isLogicalDeleted();
    }

    @Override
    public ImmutableType getTargetType() {
        if (this.targetTypeResolved) {
            return this.targetType;
        }
        if (this.isAssociation(TargetLevel.OBJECT)) {
            this.targetType = Metadata.tryGet(this.elementClass);
            if (this.targetType == null) {
                throw new ModelException("Cannot resolve target type of \"" + this + "\"");
            }
        }
        this.targetTypeResolved = true;
        return this.targetType;
    }

    @Override
    public List<OrderedItem> getOrderedItems() {
        List<OrderedItem> orderedItems = this.orderedItems;
        if (orderedItems == null) {
            OrderedProp[] orderedProps = null;
            if (this.isReferenceList(TargetLevel.PERSISTENT)) {
                OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                if (oneToMany != null) {
                    orderedProps = oneToMany.orderedProps();
                } else {
                    ManyToMany manyToMany = this.getAnnotation(ManyToMany.class);
                    if (manyToMany != null) {
                        orderedProps = manyToMany.orderedProps();
                    }
                }
            }
            if (orderedProps == null || orderedProps.length == 0) {
                orderedItems = Collections.emptyList();
            } else {
                ImmutableType targetType = this.getTargetType();
                LinkedHashMap<String, OrderedItem> map = new LinkedHashMap<String, OrderedItem>((orderedProps.length * 4 + 2) / 3);
                for (OrderedProp orderedProp : orderedProps) {
                    if (map.containsKey(orderedProp.value())) {
                        throw new ModelException("Illegal property \"" + this + "\", duplicated ordered property \"" + orderedProp.value() + "\"");
                    }
                    ImmutableProp prop = targetType.getProp(orderedProp.value());
                    if (prop == null) {
                        throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + orderedProp.value() + "\" is not declared in target type \"" + targetType + "\"");
                    }
                    if (!prop.isScalar(TargetLevel.PERSISTENT)) {
                        throw new ModelException("Illegal property \"" + this + "\", the ordered property \"" + prop + "\" is not scalar field");
                    }
                    map.put(orderedProp.value(), new OrderedItem(prop, orderedProp.desc()));
                }
                orderedItems = Collections.unmodifiableList(new ArrayList(map.values()));
            }
            this.orderedItems = orderedItems;
        }
        return orderedItems;
    }

    @Override
    public ImmutableProp getMappedBy() {
        if (this.mappedByResolved) {
            return this.mappedBy;
        }
        if (this.isAssociation(TargetLevel.PERSISTENT)) {
            this.validateDeclaringEntity("mappedBy");
            String mappedBy = "";
            OneToOne oneToOne = this.getAnnotation(OneToOne.class);
            if (oneToOne != null) {
                mappedBy = oneToOne.mappedBy();
            }
            if (mappedBy.isEmpty()) {
                ManyToMany manyToMany;
                OneToMany oneToMany = this.getAnnotation(OneToMany.class);
                if (oneToMany != null) {
                    mappedBy = oneToMany.mappedBy();
                }
                if (mappedBy.isEmpty() && (manyToMany = this.getAnnotation(ManyToMany.class)) != null) {
                    mappedBy = manyToMany.mappedBy();
                }
            }
            if (!mappedBy.isEmpty()) {
                ImmutableProp resolved = this.getTargetType().getProps().get(mappedBy);
                if (resolved == null) {
                    throw new ModelException("Cannot resolve the mappedBy property name \"" + mappedBy + "\" for property \"" + this + "\"");
                }
                if (resolved.getStorage() == null) {
                    throw new ModelException("The property \"" + resolved + "\" is illegal, it's not persistence property so that \"this\" cannot reference it by \"mappedBy\"");
                }
                if (resolved.getAssociationAnnotation().annotationType() == OneToOne.class && this.associationAnnotation.annotationType() != OneToOne.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
                }
                if (resolved.getAssociationAnnotation().annotationType() == ManyToOne.class && this.associationAnnotation.annotationType() != OneToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be one-to-one property because its \"mappedBy\" property \"" + resolved + "\" is one-to-one property");
                }
                if (resolved.isReferenceList(TargetLevel.PERSISTENT) && this.associationAnnotation.annotationType() != ManyToMany.class) {
                    throw new ModelException("Illegal property \"" + this + "\", it must be many-to-many property because its \"mappedBy\" property \"" + resolved + "\" is list");
                }
                ((ImmutablePropImpl)resolved).acceptMappedBy(this);
                this.mappedBy = resolved;
            }
        }
        this.mappedByResolved = true;
        return this.mappedBy;
    }

    private void acceptMappedBy(ImmutableProp prop) {
        if (this.acceptedMappedBy != null) {
            throw new ModelException("Both `" + this.acceptedMappedBy + "` and `" + prop + "` use `mappedBy` to reference `" + this + "`");
        }
        this.acceptedMappedBy = prop;
    }

    @Override
    public ImmutableProp getOpposite() {
        if (this.oppositeResolved) {
            return this.opposite;
        }
        if (this.isAssociation(TargetLevel.PERSISTENT)) {
            this.validateDeclaringEntity("opposite");
            this.opposite = this.getMappedBy();
            if (this.opposite == null) {
                for (ImmutableProp backProp : this.getTargetType().getProps().values()) {
                    if (backProp.getMappedBy() != this) continue;
                    this.opposite = backProp;
                    break;
                }
            }
        }
        this.oppositeResolved = true;
        return this.opposite;
    }

    @Override
    public List<ImmutableProp> getDependencies() {
        List<ImmutableProp> list = this.dependencies;
        if (list == null) {
            return this.getDependenciesImpl(new LinkedList<ImmutableProp>());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImmutableProp> getDependenciesImpl(LinkedList<ImmutableProp> stack) {
        List<ImmutableProp> list = this.dependencies;
        if (list == null) {
            list = new ArrayList<ImmutableProp>();
            Formula formula = this.getAnnotation(Formula.class);
            IdView idView = this.getAnnotation(IdView.class);
            if (formula != null) {
                String[] arr = formula.dependencies();
                if (arr.length != 0) {
                    Map<String, ImmutableProp> propMap = this.declaringType.getProps();
                    stack.push(this);
                    try {
                        for (String name : arr) {
                            boolean isValid;
                            ImmutableProp prop = propMap.get(name);
                            if (prop == null) {
                                throw new ModelException("Illegal property \"" + this + "\", its dependency property \"" + this.declaringType + '.' + name + "\" does not exists");
                            }
                            if (stack.contains(prop)) {
                                throw new ModelException("Illegal entity type \"" + this.declaringType + "\", dependency cycle has been found: " + stack);
                            }
                            boolean bl = isValid = prop.isFormula() || prop.getStorage() != null && !prop.isReference(TargetLevel.PERSISTENT);
                            if (!isValid) {
                                throw new ModelException("Illegal property \"" + this + "\", its dependency property \"" + prop + "\" must be scalar property or another formula property");
                            }
                            if (prop.isFormula()) {
                                if (prop.getFormulaTemplate() != null) {
                                    throw new ModelException("Illegal property \"" + this + "\", it is an abstract formula property based on SQL exception but its dependency property \"" + prop + "\" is another formula property(This is only allowed for non-abstract formula property based on java/kotlin expression)");
                                }
                                ((ImmutablePropImpl)prop).getDependenciesImpl(stack);
                            }
                            list.add(prop);
                        }
                    }
                    finally {
                        stack.pop();
                    }
                }
            } else if (idView != null) {
                String base = idView.value();
                if (base.isEmpty()) {
                    if (!this.isScalarList() && this.name.length() > 2 && this.name.endsWith("Id") && !Character.isUpperCase(this.name.charAt(this.name.length() - 3))) {
                        base = this.name.substring(0, this.name.length() - 2);
                    } else {
                        throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\" without argument, but the base property name cannot be determined automatically, please specify the argument of that annotation");
                    }
                }
                if (base.equals(this.name)) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\", the argument of that annotation can not be equal to the current property name \"" + this.name + "\"");
                }
                ImmutableProp baseProp = this.declaringType.getProps().get(base);
                if (baseProp == null) {
                    throw new ModelException("Illegal property \"" + this + "\", it is decorated by \"" + IdView.class.getName() + "\", the argument of that annotation is \"" + base + "\" but there is no such property in the declaring type");
                }
                if (this.isScalarList() && !baseProp.isReferenceList(TargetLevel.PERSISTENT)) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar list property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + base + "\" but the base property \"" + baseProp + "\" is not a persistent reference list property");
                }
                if (!this.isScalarList() && !baseProp.isReference(TargetLevel.PERSISTENT)) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + base + "\" but the base property \"" + baseProp + "\" is not a persistent reference property");
                }
                if (!Classes.matches(baseProp.getTargetType().getIdProp().getElementClass(), this.getElementClass())) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + base + "\", the base property \"" + baseProp + "\" return the entity type whose id is \"" + baseProp.getTargetType().getIdProp().getElementClass() + "\" but the element type of the current property is \"" + this.getElementClass() + "\"");
                }
                if (this.isNullable() != baseProp.isNullable()) {
                    throw new ModelException("Illegal property \"" + this + "\" is a scalar property, it is decorated by \"" + IdView.class.getName() + "\" whose argument of that annotation is \"" + base + "\", but the nullity of current property does not equal to the nullity of the base property \"" + baseProp + "\"");
                }
                list.add(baseProp);
            }
            this.dependencies = Collections.unmodifiableList(list);
        }
        return list;
    }

    ImmutableProp getBase() {
        return this.base;
    }

    public int hashCode() {
        return System.identityHashCode(this.base != null ? this.base : this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutablePropImpl)) {
            return false;
        }
        ImmutablePropImpl prop = (ImmutablePropImpl)o;
        return (this.base != null ? this.base : this) == (prop.base != null ? prop.base : prop);
    }

    public String toString() {
        return this.declaringType.toString() + '.' + this.name;
    }

    private void validateDeclaringEntity(String value) {
        if (!this.declaringType.isEntity()) {
            throw new UnsupportedOperationException("Cannot get the `" + value + "` of \"" + this + "\" because it is not declared in entity");
        }
    }
}

