/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.babyfish.jimmer.jackson.PropDeserializeUtils;
import org.babyfish.jimmer.jackson.meta.BeanProps;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;

public class ImmutableDeserializer
extends StdDeserializer<Object> {
    private final ImmutableType immutableType;

    public ImmutableDeserializer(ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.immutableType = immutableType;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce(this.immutableType, null, draft -> {
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (!prop.isMutable() || !node.has(prop.getName())) continue;
                Object value = PropDeserializeUtils.readTreeAsValue(ctx, node.get(prop.getName()), (BeanProperty)BeanProps.get(ctx.getTypeFactory(), prop));
                if (value != null && prop.getConverter() != null) {
                    value = prop.getConverter().input(value);
                }
                ((DraftSpi)draft).__set(prop.getId(), value);
            }
        });
    }
}

